/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.parse;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClasspathResolver
implements EntityResolver,
LSResourceResolver {
    public static final String CLASSPATH_URI_SCHEME = "classpath:";
    private final Logger log = Logger.getLogger(ClasspathResolver.class);

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream resourceStream = this.resolver(publicId, systemId);
        if (resourceStream != null) {
            return new InputSource(resourceStream);
        }
        return null;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        return new LSInputImpl(publicId, systemId, this.resolver(publicId, systemId));
    }

    protected InputStream resolver(String publicId, String systemId) {
        String resource = null;
        InputStream resourceIns = null;
        if (systemId.startsWith(CLASSPATH_URI_SCHEME)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to resolve, within the classpath, the entity with the following system id: " + systemId));
            }
            resource = systemId.replaceFirst(CLASSPATH_URI_SCHEME, "");
            resourceIns = this.getClass().getResourceAsStream(resource);
        }
        if (resourceIns == null && publicId != null && publicId.startsWith(CLASSPATH_URI_SCHEME)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to resolve, within the classpath, the entity with the following public id: " + resource));
            }
            resource = publicId.replaceFirst(CLASSPATH_URI_SCHEME, "");
            resourceIns = this.getClass().getResourceAsStream(resource);
        }
        if (resourceIns == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Entity was not resolved from classpath");
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Entity resolved from classpath");
        }
        return resourceIns;
    }

    protected class LSInputImpl
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream buffInput;

        public LSInputImpl(String pubId, String sysId, InputStream input) {
            this.publicId = pubId;
            this.systemId = sysId;
            this.buffInput = new BufferedInputStream(input);
        }

        public String getBaseURI() {
            return null;
        }

        public InputStream getByteStream() {
            return this.buffInput;
        }

        public boolean getCertifiedText() {
            return false;
        }

        public Reader getCharacterStream() {
            return new InputStreamReader(this.buffInput);
        }

        public String getEncoding() {
            return null;
        }

        public String getPublicId() {
            return this.publicId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.buffInput;
            synchronized (bufferedInputStream) {
                try {
                    this.buffInput.reset();
                    byte[] input = new byte[this.buffInput.available()];
                    this.buffInput.read(input);
                    return new String(input);
                }
                catch (IOException e) {
                    return null;
                }
            }
        }

        public String getSystemId() {
            return this.systemId;
        }

        public void setBaseURI(String uri) {
        }

        public void setByteStream(InputStream byteStream) {
        }

        public void setCertifiedText(boolean isCertifiedText) {
        }

        public void setCharacterStream(Reader characterStream) {
        }

        public void setEncoding(String encoding) {
        }

        public void setPublicId(String id) {
        }

        public void setStringData(String stringData) {
        }

        public void setSystemId(String id) {
        }
    }
}

