/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.schema;

import org.opensaml.xml.util.DatatypeHelper;

public class XSBooleanValue {
    private boolean numeric;
    private Boolean value;

    public XSBooleanValue() {
        this.numeric = false;
        this.value = null;
    }

    public XSBooleanValue(Boolean newValue, boolean numericRepresentation) {
        this.numeric = numericRepresentation;
        this.value = newValue;
    }

    public Boolean getValue() {
        return this.value;
    }

    public void setValue(Boolean newValue) {
        this.value = newValue;
    }

    public boolean isNumericRepresentation() {
        return this.numeric;
    }

    public void setNumericRepresentation(boolean numericRepresentation) {
        this.numeric = numericRepresentation;
    }

    public int hashCode() {
        int hash = this.numeric ? (this.value == null ? 0 : (this.value.booleanValue() ? 1 : 3)) : (this.value == null ? 4 : (this.value != false ? 5 : 6));
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof XSBooleanValue) {
            XSBooleanValue otherValue = (XSBooleanValue)obj;
            return this.hashCode() == otherValue.hashCode();
        }
        return false;
    }

    public String toString() {
        return XSBooleanValue.toString(this.value, this.numeric);
    }

    public static String toString(Boolean value, boolean numericRepresentation) {
        if (value == null) {
            return "false";
        }
        if (numericRepresentation) {
            if (value.booleanValue()) {
                return "1";
            }
            return "0";
        }
        return value.toString();
    }

    public static XSBooleanValue valueOf(String booleanString) {
        String trimmedBooleanString = DatatypeHelper.safeTrimOrNullString(booleanString);
        if (trimmedBooleanString != null) {
            if (trimmedBooleanString.equals("1")) {
                return new XSBooleanValue(Boolean.TRUE, true);
            }
            if (trimmedBooleanString.equals("0")) {
                return new XSBooleanValue(Boolean.FALSE, true);
            }
            if (trimmedBooleanString.equals("true")) {
                return new XSBooleanValue(Boolean.TRUE, false);
            }
        }
        return new XSBooleanValue(Boolean.FALSE, false);
    }
}

