/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential;

import java.util.HashSet;
import java.util.Set;
import org.opensaml.xml.security.CriteriaFilteringIterable;
import org.opensaml.xml.security.EvaluableCriteria;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.AbstractCredentialResolver;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteria;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.credential.EvaluableCredentialCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCriteriaFilteringCredentialResolver
extends AbstractCredentialResolver {
    private boolean meetAllCriteria = true;
    private boolean unevaluableSatisfies = true;

    @Override
    public Iterable<Credential> resolve(CredentialCriteriaSet criteriaSet) throws SecurityException {
        Iterable<Credential> storeCandidates = this.resolveFromSource(criteriaSet);
        Set evaluableCriteria = this.getEvaluableCriteria(criteriaSet);
        return new CriteriaFilteringIterable<Credential>(storeCandidates, evaluableCriteria, this.meetAllCriteria, this.unevaluableSatisfies);
    }

    public boolean isMeetAllCriteria() {
        return this.meetAllCriteria;
    }

    public void setMeetAllCriteria(boolean flag) {
        this.meetAllCriteria = flag;
    }

    public boolean isUnevaluableSatisfies() {
        return this.unevaluableSatisfies;
    }

    public void setUnevaluableSatisfies(boolean flag) {
        this.unevaluableSatisfies = flag;
    }

    protected abstract Iterable<Credential> resolveFromSource(CredentialCriteriaSet var1) throws SecurityException;

    private Set<EvaluableCriteria<Credential>> getEvaluableCriteria(CredentialCriteriaSet criteriaSet) {
        HashSet<EvaluableCriteria<Credential>> evaluable = new HashSet<EvaluableCriteria<Credential>>();
        for (CredentialCriteria criteria : criteriaSet) {
            if (!(criteria instanceof EvaluableCredentialCriteria)) continue;
            evaluable.add((EvaluableCriteria)((Object)criteria));
        }
        return evaluable;
    }
}

