/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.keyinfo;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.AbstractCriteriaFilteringCredentialResolver;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialContext;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoProvider;
import org.opensaml.xml.security.keyinfo.provider.DSAKeyValueProvider;
import org.opensaml.xml.security.keyinfo.provider.RSAKeyValueProvider;
import org.opensaml.xml.security.keyinfo.provider.X509DataProvider;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.KeyInfoHelper;
import org.opensaml.xml.signature.KeyName;
import org.opensaml.xml.signature.KeyValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoCredentialResolver
extends AbstractCriteriaFilteringCredentialResolver {
    private static Logger log = Logger.getLogger(KeyInfoCredentialResolver.class);
    private List<KeyInfoProvider> providers = new ArrayList<KeyInfoProvider>();

    public KeyInfoCredentialResolver() {
        this.providers.add(new RSAKeyValueProvider());
        this.providers.add(new DSAKeyValueProvider());
        this.providers.add(new X509DataProvider());
    }

    @Override
    protected Iterable<Credential> resolveFromSource(CredentialCriteriaSet criteriaSet) throws SecurityException {
        KeyInfoCriteria kiCriteria = criteriaSet.get(KeyInfoCriteria.class);
        if (kiCriteria == null) {
            log.error((Object)"No KeyInfo criteria supplied, resolver could not process");
            throw new SecurityException("Credential criteria set did not contain an instance ofKeyInfoCredentialCriteria");
        }
        KeyInfo keyInfo = kiCriteria.getKeyInfo();
        ArrayList<Credential> credentials = new ArrayList<Credential>();
        KeyInfoResolutionContext kiContext = new KeyInfoResolutionContext(credentials);
        if (keyInfo != null) {
            this.initResolutionContext(kiContext, keyInfo, criteriaSet);
            this.processKeyInfoChildren(kiContext, criteriaSet, credentials);
            if (credentials.isEmpty() && kiContext.getKeyValueCredential() != null) {
                log.debug((Object)"No credentials extracted by registered non-KeyValue handling providers, adding KeyValue credential to returned credential set");
                credentials.add(kiContext.getKeyValueCredential());
            }
        } else {
            log.info((Object)"KeyInfo was null, any credentials will be resolved by post-processing hooks only");
        }
        this.postProcess(kiContext, criteriaSet, credentials);
        if (credentials.isEmpty()) {
            log.debug((Object)"No credentials were found, calling empty credentials post-processing hook");
            this.postProcessEmptyCredentials(kiContext, criteriaSet, credentials);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("A total of " + credentials.size() + " credentials were resolved"));
        }
        return credentials;
    }

    protected void postProcess(KeyInfoResolutionContext kiContext, CredentialCriteriaSet criteriaSet, List<Credential> credentials) throws SecurityException {
    }

    protected void postProcessEmptyCredentials(KeyInfoResolutionContext kiContext, CredentialCriteriaSet criteriaSet, List<Credential> credentials) throws SecurityException {
    }

    private void processKeyInfoChildren(KeyInfoResolutionContext kiContext, CredentialCriteriaSet criteriaSet, List<Credential> credentials) throws SecurityException {
        for (XMLObject keyInfoChild : kiContext.getKeyInfo().getXMLObjects()) {
            Collection<Credential> childCreds;
            if (keyInfoChild instanceof KeyValue) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing KeyInfo child with qname: " + keyInfoChild.getElementQName()));
            }
            if ((childCreds = this.processKeyInfoChild(kiContext, criteriaSet, keyInfoChild)) != null && !childCreds.isEmpty()) {
                credentials.addAll(childCreds);
                continue;
            }
            if (keyInfoChild instanceof KeyName) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("KeyName with value '" + ((KeyName)keyInfoChild).getValue() + "' did not independently produce a credential based on any registered providers"));
                continue;
            }
            log.warn((Object)("No credentials could be extracted from KeyInfo child with qname " + keyInfoChild.getElementQName() + " by any registered provider"));
        }
    }

    private Collection<Credential> processKeyInfoChild(KeyInfoResolutionContext kiContext, CredentialCriteriaSet criteriaSet, XMLObject keyInfoChild) throws SecurityException {
        for (KeyInfoProvider provider : this.providers) {
            Collection<Credential> creds;
            if (!provider.handles(keyInfoChild)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Provider " + provider.getClass().getName() + " doesn't handle objects of type " + keyInfoChild.getElementQName() + ", skipping"));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing KeyInfo child " + keyInfoChild.getElementQName() + " with provider " + provider.getClass().getName()));
            }
            if ((creds = provider.process(this, keyInfoChild, criteriaSet, kiContext)) == null || creds.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Credentials (count = " + creds.size() + ") successfully extracted from child " + keyInfoChild.getElementQName() + " by provider " + provider.getClass().getName()));
            }
            return creds;
        }
        return null;
    }

    private void initResolutionContext(KeyInfoResolutionContext kiContext, KeyInfo keyInfo, CredentialCriteriaSet criteriaSet) throws SecurityException {
        kiContext.setKeyInfo(keyInfo);
        kiContext.setKeyNames(KeyInfoHelper.getKeyNames(keyInfo));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + kiContext.getKeyNames().size() + " key names: " + kiContext.getKeyNames()));
        }
        this.resolveKeyValue(kiContext, criteriaSet, keyInfo.getKeyValues());
    }

    protected void resolveKeyValue(KeyInfoResolutionContext kiContext, CredentialCriteriaSet criteriaSet, List<KeyValue> keyValues) throws SecurityException {
        for (KeyValue keyValue : keyValues) {
            Collection<Credential> creds = this.processKeyInfoChild(kiContext, criteriaSet, keyValue);
            if (creds == null || creds.isEmpty()) continue;
            kiContext.setKeyValueCredential(creds.iterator().next());
            if (log.isDebugEnabled()) {
                Key key = this.extractKeyValue(kiContext.getKeyValueCredential());
                log.debug((Object)("Found a credential based on a KeyValue having key type: " + key.getAlgorithm()));
            }
            return;
        }
    }

    public KeyInfoCredentialContext buildCredentialContext(KeyInfoResolutionContext kiContext) {
        return new KeyInfoCredentialContext(kiContext.getKeyInfo());
    }

    protected Credential buildKeyNameOnlyCredential(KeyInfoResolutionContext kiContext) throws SecurityException {
        BasicCredential basicCredential = new BasicCredential();
        basicCredential.getKeyNames().addAll(kiContext.getKeyNames());
        basicCredential.getCredentalContextSet().add(this.buildCredentialContext(kiContext));
        return basicCredential;
    }

    protected Key extractKeyValue(Credential cred) {
        if (cred == null) {
            return null;
        }
        if (cred.getPublicKey() != null) {
            return cred.getPublicKey();
        }
        if (cred.getSecretKey() != null) {
            return cred.getSecretKey();
        }
        if (cred.getPrivateKey() != null) {
            return cred.getPrivateKey();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeyInfoResolutionContext {
        private KeyInfo keyInfo;
        private List<String> names;
        private Credential credential;
        private Collection<Credential> resolvedCredentials;
        private final Map<String, Object> properties;

        public KeyInfoResolutionContext(Collection<Credential> credentials) {
            this.resolvedCredentials = Collections.unmodifiableCollection(credentials);
            this.properties = new HashMap<String, Object>();
        }

        public KeyInfo getKeyInfo() {
            return this.keyInfo;
        }

        public void setKeyInfo(KeyInfo newKeyInfo) {
            this.keyInfo = newKeyInfo;
        }

        public List<String> getKeyNames() {
            return this.names;
        }

        public void setKeyNames(List<String> keyNames) {
            this.names = keyNames;
        }

        public Credential getKeyValueCredential() {
            return this.credential;
        }

        public Collection<Credential> getResolvedCredentials() {
            return this.resolvedCredentials;
        }

        public void setKeyValueCredential(Credential keyValueCredential) {
            this.credential = keyValueCredential;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }
    }
}

