/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.trust;

import org.apache.log4j.Logger;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.trust.ExplicitX509CertificateTrustEvaluator;
import org.opensaml.xml.security.trust.TrustedCredentialTrustEngine;
import org.opensaml.xml.security.x509.X509Credential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitX509CertificateTrustEngine
implements TrustedCredentialTrustEngine<X509Credential> {
    private static Logger log = Logger.getLogger(ExplicitX509CertificateTrustEngine.class);
    private CredentialResolver credentialResolver;
    private ExplicitX509CertificateTrustEvaluator trustEvaluator;

    public ExplicitX509CertificateTrustEngine(CredentialResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Credential resolver may not be null");
        }
        this.credentialResolver = resolver;
        this.trustEvaluator = new ExplicitX509CertificateTrustEvaluator();
    }

    @Override
    public CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    public boolean validate(X509Credential untrustedCredential, CriteriaSet trustBasisCriteria) throws SecurityException {
        this.checkParams(untrustedCredential, trustBasisCriteria);
        CredentialCriteriaSet credentialCriteria = SecurityHelper.getCredentialCriteria(trustBasisCriteria);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating credential for entity " + untrustedCredential.getEntityId()));
        }
        Iterable<Credential> trustedCredentials = this.getCredentialResolver().resolve(credentialCriteria);
        return this.trustEvaluator.validate(untrustedCredential, trustedCredentials);
    }

    protected void checkParams(X509Credential untrustedCredential, CriteriaSet trustBasisCriteria) throws SecurityException {
        if (untrustedCredential == null) {
            throw new SecurityException("Untrusted credential was null");
        }
        if (trustBasisCriteria == null) {
            throw new SecurityException("Trust basis criteria set was null");
        }
        if (trustBasisCriteria.isEmpty()) {
            throw new SecurityException("Trust basis criteria set was empty");
        }
    }
}

