/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.trust;

import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.X509Credential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitX509CertificateTrustEvaluator {
    private static Logger log = Logger.getLogger(ExplicitX509CertificateTrustEvaluator.class);

    public boolean validate(X509Certificate untrustedCertificate, X509Certificate trustedCertificate) {
        return untrustedCertificate.equals(trustedCertificate);
    }

    public boolean validate(X509Certificate untrustedCertificate, Iterable<X509Certificate> trustedCertificates) {
        for (X509Certificate trustedCertificate : trustedCertificates) {
            if (!untrustedCertificate.equals(trustedCertificate)) continue;
            return true;
        }
        return false;
    }

    public boolean validate(X509Credential untrustedCredential, X509Credential trustedCredential) {
        X509Certificate untrustedCertificate = untrustedCredential.getEntityCertificate();
        X509Certificate trustedCertificate = trustedCredential.getEntityCertificate();
        if (untrustedCertificate == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Untrusted credential contained no entity certificate, unable to evaluate");
            }
            return false;
        }
        if (trustedCertificate == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Trusted credential contained no entity certificate, unable to evaluate");
            }
            return false;
        }
        if (this.validate(untrustedCertificate, trustedCertificate)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validated credential for entity " + untrustedCredential.getEntityId() + " against trusted entity certificate"));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Credential for entity " + untrustedCredential.getEntityId() + " did not validate against trusted entity certificate"));
        }
        return false;
    }

    public boolean validate(X509Credential untrustedCredential, Iterable<Credential> trustedCredentials) {
        for (Credential trustedCredential : trustedCredentials) {
            if (!(trustedCredential instanceof X509Credential)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"Skipping evaluation against trusted, non-X509Credential");
                continue;
            }
            X509Credential trustedX509Credential = (X509Credential)trustedCredential;
            if (!this.validate(untrustedCredential, trustedX509Credential)) continue;
            return true;
        }
        return false;
    }
}

