/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.signature.DSAKeyValue;
import org.opensaml.xml.signature.Exponent;
import org.opensaml.xml.signature.G;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.KeyName;
import org.opensaml.xml.signature.KeyValue;
import org.opensaml.xml.signature.Modulus;
import org.opensaml.xml.signature.P;
import org.opensaml.xml.signature.Q;
import org.opensaml.xml.signature.RSAKeyValue;
import org.opensaml.xml.signature.X509CRL;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.signature.X509IssuerName;
import org.opensaml.xml.signature.X509IssuerSerial;
import org.opensaml.xml.signature.X509SKI;
import org.opensaml.xml.signature.X509SerialNumber;
import org.opensaml.xml.signature.X509SubjectName;
import org.opensaml.xml.signature.Y;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.DatatypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyInfoHelper {
    private static Logger log = Logger.getLogger(KeyInfoHelper.class);
    private static CertificateFactory x509CertFactory;

    protected KeyInfoHelper() {
    }

    public static List<String> getKeyNames(KeyInfo keyInfo) {
        LinkedList<String> keynameList = new LinkedList<String>();
        if (keyInfo == null) {
            return keynameList;
        }
        List<KeyName> keyNames = keyInfo.getKeyNames();
        for (KeyName keyName : keyNames) {
            if (keyName.getValue() == null) continue;
            keynameList.add(keyName.getValue());
        }
        return keynameList;
    }

    public static void addKeyName(KeyInfo keyInfo, String keyNameValue) {
        KeyName keyName = (KeyName)Configuration.getBuilderFactory().getBuilder(KeyName.DEFAULT_ELEMENT_NAME).buildObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(keyNameValue);
        keyInfo.getKeyNames().add(keyName);
    }

    public static List<java.security.cert.X509Certificate> getCertificates(KeyInfo keyInfo) throws CertificateException {
        LinkedList<java.security.cert.X509Certificate> certList = new LinkedList<java.security.cert.X509Certificate>();
        if (keyInfo == null) {
            return certList;
        }
        List<X509Data> x509Datas = keyInfo.getX509Datas();
        for (X509Data x509Data : x509Datas) {
            if (x509Data == null) continue;
            certList.addAll(KeyInfoHelper.getCertificates(x509Data));
        }
        return certList;
    }

    public static List<java.security.cert.X509Certificate> getCertificates(X509Data x509Data) throws CertificateException {
        LinkedList<java.security.cert.X509Certificate> certList = new LinkedList<java.security.cert.X509Certificate>();
        if (x509Data == null) {
            return certList;
        }
        for (X509Certificate xmlCert : x509Data.getX509Certificates()) {
            if (xmlCert == null || xmlCert.getValue() == null) continue;
            java.security.cert.X509Certificate newCert = KeyInfoHelper.getCertificate(xmlCert);
            certList.add(newCert);
        }
        return certList;
    }

    public static java.security.cert.X509Certificate getCertificate(X509Certificate xmlCert) throws CertificateException {
        if (xmlCert == null || xmlCert.getValue() == null) {
            return null;
        }
        CertificateFactory cf = KeyInfoHelper.getX509CertFactory();
        ByteArrayInputStream input = new ByteArrayInputStream(Base64.decode(xmlCert.getValue()));
        java.security.cert.X509Certificate newCert = (java.security.cert.X509Certificate)cf.generateCertificate(input);
        return newCert;
    }

    public static List<java.security.cert.X509CRL> getCRLs(KeyInfo keyInfo) throws CRLException {
        LinkedList<java.security.cert.X509CRL> crlList = new LinkedList<java.security.cert.X509CRL>();
        if (keyInfo == null) {
            return crlList;
        }
        List<X509Data> x509Datas = keyInfo.getX509Datas();
        for (X509Data x509Data : x509Datas) {
            if (x509Data == null) continue;
            crlList.addAll(KeyInfoHelper.getCRLs(x509Data));
        }
        return crlList;
    }

    public static List<java.security.cert.X509CRL> getCRLs(X509Data x509Data) throws CRLException {
        LinkedList<java.security.cert.X509CRL> crlList = new LinkedList<java.security.cert.X509CRL>();
        if (x509Data == null) {
            return crlList;
        }
        for (X509CRL xmlCRL : x509Data.getX509CRLs()) {
            if (xmlCRL == null || xmlCRL.getValue() == null) continue;
            java.security.cert.X509CRL newCRL = KeyInfoHelper.getCRL(xmlCRL);
            crlList.add(newCRL);
        }
        return crlList;
    }

    public static java.security.cert.X509CRL getCRL(X509CRL xmlCRL) throws CRLException {
        if (xmlCRL == null || xmlCRL.getValue() == null) {
            return null;
        }
        try {
            CertificateFactory cf = KeyInfoHelper.getX509CertFactory();
            ByteArrayInputStream input = new ByteArrayInputStream(Base64.decode(xmlCRL.getValue()));
            java.security.cert.X509CRL newCRL = (java.security.cert.X509CRL)cf.generateCRL(input);
            return newCRL;
        }
        catch (CertificateException e) {
            throw new CRLException("Unable to create X509 certificate factory", e);
        }
    }

    public static void addCertificate(KeyInfo keyInfo, java.security.cert.X509Certificate cert) throws CertificateEncodingException {
        X509Data x509Data = keyInfo.getX509Datas().get(0);
        if (x509Data == null) {
            x509Data = (X509Data)Configuration.getBuilderFactory().getBuilder(X509Data.DEFAULT_ELEMENT_NAME).buildObject(X509Data.DEFAULT_ELEMENT_NAME);
            keyInfo.getX509Datas().add(x509Data);
        }
        x509Data.getX509Certificates().add(KeyInfoHelper.buildX509Certificate(cert));
    }

    public static void addCRL(KeyInfo keyInfo, java.security.cert.X509CRL crl) throws CRLException {
        X509Data x509Data = keyInfo.getX509Datas().get(0);
        if (x509Data == null) {
            x509Data = (X509Data)Configuration.getBuilderFactory().getBuilder(X509Data.DEFAULT_ELEMENT_NAME).buildObject(X509Data.DEFAULT_ELEMENT_NAME);
            keyInfo.getX509Datas().add(x509Data);
        }
        x509Data.getX509CRLs().add(KeyInfoHelper.buildX509CRL(crl));
    }

    public static X509Certificate buildX509Certificate(java.security.cert.X509Certificate cert) throws CertificateEncodingException {
        X509Certificate xmlCert = (X509Certificate)Configuration.getBuilderFactory().getBuilder(X509Certificate.DEFAULT_ELEMENT_NAME).buildObject(X509Certificate.DEFAULT_ELEMENT_NAME);
        xmlCert.setValue(Base64.encodeBytes(cert.getEncoded()));
        return xmlCert;
    }

    public static X509CRL buildX509CRL(java.security.cert.X509CRL crl) throws CRLException {
        X509CRL xmlCRL = (X509CRL)Configuration.getBuilderFactory().getBuilder(X509CRL.DEFAULT_ELEMENT_NAME).buildObject(X509CRL.DEFAULT_ELEMENT_NAME);
        xmlCRL.setValue(Base64.encodeBytes(crl.getEncoded()));
        return xmlCRL;
    }

    public static X509SubjectName buildX509SubjectName(String subjectName) {
        X509SubjectName xmlSubjectName = (X509SubjectName)Configuration.getBuilderFactory().getBuilder(X509SubjectName.DEFAULT_ELEMENT_NAME).buildObject(X509SubjectName.DEFAULT_ELEMENT_NAME);
        xmlSubjectName.setValue(subjectName);
        return xmlSubjectName;
    }

    public static X509IssuerSerial buildX509IssuerSerial(String issuerName, BigInteger serialNumber) {
        X509IssuerName xmlIssuerName = (X509IssuerName)Configuration.getBuilderFactory().getBuilder(X509IssuerName.DEFAULT_ELEMENT_NAME).buildObject(X509IssuerName.DEFAULT_ELEMENT_NAME);
        xmlIssuerName.setValue(issuerName);
        X509SerialNumber xmlSerialNumber = (X509SerialNumber)Configuration.getBuilderFactory().getBuilder(X509SerialNumber.DEFAULT_ELEMENT_NAME).buildObject(X509SerialNumber.DEFAULT_ELEMENT_NAME);
        xmlSerialNumber.setValue(serialNumber);
        X509IssuerSerial xmlIssuerSerial = (X509IssuerSerial)Configuration.getBuilderFactory().getBuilder(X509IssuerSerial.DEFAULT_ELEMENT_NAME).buildObject(X509IssuerSerial.DEFAULT_ELEMENT_NAME);
        xmlIssuerSerial.setX509IssuerName(xmlIssuerName);
        xmlIssuerSerial.setX509SerialNumber(xmlSerialNumber);
        return xmlIssuerSerial;
    }

    public static X509SKI buildX509SKI(java.security.cert.X509Certificate javaCert) {
        byte[] skiPlainValue = X509Util.getSubjectKeyIdentifier(javaCert);
        if (skiPlainValue == null || skiPlainValue.length == 0) {
            return null;
        }
        X509SKI xmlSKI = (X509SKI)Configuration.getBuilderFactory().getBuilder(X509SKI.DEFAULT_ELEMENT_NAME).buildObject(X509SKI.DEFAULT_ELEMENT_NAME);
        xmlSKI.setValue(Base64.encodeBytes(skiPlainValue));
        return xmlSKI;
    }

    public static void addPublicKey(KeyInfo keyInfo, PublicKey pk) throws IllegalArgumentException {
        KeyValue keyValue = (KeyValue)Configuration.getBuilderFactory().getBuilder(KeyValue.DEFAULT_ELEMENT_NAME).buildObject(KeyValue.DEFAULT_ELEMENT_NAME);
        if (pk instanceof RSAPublicKey) {
            keyValue.setRSAKeyValue(KeyInfoHelper.buildRSAKeyValue((RSAPublicKey)pk));
        } else if (pk instanceof DSAPublicKey) {
            keyValue.setDSAKeyValue(KeyInfoHelper.buildDSAKeyValue((DSAPublicKey)pk));
        } else {
            throw new IllegalArgumentException("Only RSAPublicKey and DSAPublicKey are supported");
        }
        keyInfo.getKeyValues().add(keyValue);
    }

    public static RSAKeyValue buildRSAKeyValue(RSAPublicKey rsaPubKey) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        RSAKeyValue rsaKeyValue = (RSAKeyValue)builderFactory.getBuilder(RSAKeyValue.DEFAULT_ELEMENT_NAME).buildObject(RSAKeyValue.DEFAULT_ELEMENT_NAME);
        Modulus modulus = (Modulus)builderFactory.getBuilder(Modulus.DEFAULT_ELEMENT_NAME).buildObject(Modulus.DEFAULT_ELEMENT_NAME);
        Exponent exponent = (Exponent)builderFactory.getBuilder(Exponent.DEFAULT_ELEMENT_NAME).buildObject(Exponent.DEFAULT_ELEMENT_NAME);
        modulus.setValue(Base64.encodeBytes(rsaPubKey.getModulus().toByteArray()));
        rsaKeyValue.setModulus(modulus);
        exponent.setValue(Base64.encodeBytes(rsaPubKey.getPublicExponent().toByteArray()));
        rsaKeyValue.setExponent(exponent);
        return rsaKeyValue;
    }

    public static DSAKeyValue buildDSAKeyValue(DSAPublicKey dsaPubKey) {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        DSAKeyValue dsaKeyValue = (DSAKeyValue)builderFactory.getBuilder(DSAKeyValue.DEFAULT_ELEMENT_NAME).buildObject(DSAKeyValue.DEFAULT_ELEMENT_NAME);
        Y y = (Y)builderFactory.getBuilder(Y.DEFAULT_ELEMENT_NAME).buildObject(Y.DEFAULT_ELEMENT_NAME);
        G g = (G)builderFactory.getBuilder(G.DEFAULT_ELEMENT_NAME).buildObject(G.DEFAULT_ELEMENT_NAME);
        P p = (P)builderFactory.getBuilder(P.DEFAULT_ELEMENT_NAME).buildObject(P.DEFAULT_ELEMENT_NAME);
        Q q = (Q)builderFactory.getBuilder(Q.DEFAULT_ELEMENT_NAME).buildObject(Q.DEFAULT_ELEMENT_NAME);
        y.setValue(Base64.encodeBytes(dsaPubKey.getY().toByteArray()));
        dsaKeyValue.setY(y);
        g.setValue(Base64.encodeBytes(dsaPubKey.getParams().getG().toByteArray()));
        dsaKeyValue.setG(g);
        p.setValue(Base64.encodeBytes(dsaPubKey.getParams().getP().toByteArray()));
        dsaKeyValue.setP(p);
        q.setValue(Base64.encodeBytes(dsaPubKey.getParams().getQ().toByteArray()));
        dsaKeyValue.setQ(q);
        return dsaKeyValue;
    }

    public static List<PublicKey> getPublicKeys(KeyInfo keyInfo) throws KeyException {
        LinkedList<PublicKey> keys = new LinkedList<PublicKey>();
        if (keyInfo == null || keyInfo.getKeyValues() == null) {
            return keys;
        }
        for (KeyValue keyDescriptor : keyInfo.getKeyValues()) {
            keys.add(KeyInfoHelper.getKey(keyDescriptor));
        }
        return keys;
    }

    public static PublicKey getKey(KeyValue keyValue) throws KeyException {
        if (keyValue.getDSAKeyValue() != null) {
            return KeyInfoHelper.getDSAKey(keyValue.getDSAKeyValue());
        }
        if (keyValue.getRSAKeyValue() != null) {
            return KeyInfoHelper.getRSAKey(keyValue.getRSAKeyValue());
        }
        return null;
    }

    public static PublicKey getDSAKey(DSAKeyValue keyDescriptor) throws KeyException {
        if (!KeyInfoHelper.hasCompleteDSAParams(keyDescriptor)) {
            throw new KeyException("DSAKeyValue element did not contain at least one of DSA parameters P, Q or G");
        }
        String encodedG = keyDescriptor.getG().getValue();
        BigInteger gComponent = new BigInteger(Base64.decode(encodedG));
        String encodedP = keyDescriptor.getP().getValue();
        BigInteger pComponent = new BigInteger(Base64.decode(encodedP));
        String encodedQ = keyDescriptor.getQ().getValue();
        BigInteger qComponent = new BigInteger(Base64.decode(encodedQ));
        DSAParameterSpec dsaParams = new DSAParameterSpec(pComponent, qComponent, gComponent);
        return KeyInfoHelper.getDSAKey(keyDescriptor, dsaParams);
    }

    public static PublicKey getDSAKey(DSAKeyValue keyDescriptor, DSAParams dsaParams) throws KeyException {
        String encodedY = keyDescriptor.getY().getValue();
        BigInteger yComponent = new BigInteger(Base64.decode(encodedY));
        DSAPublicKeySpec keySpec = new DSAPublicKeySpec(yComponent, dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
        return KeyInfoHelper.buildKey(keySpec, "DSA");
    }

    public static boolean hasCompleteDSAParams(DSAKeyValue keyDescriptor) {
        return keyDescriptor.getG() != null && !DatatypeHelper.isEmpty(keyDescriptor.getG().getValue()) && keyDescriptor.getP() != null && !DatatypeHelper.isEmpty(keyDescriptor.getP().getValue()) && keyDescriptor.getQ() != null && !DatatypeHelper.isEmpty(keyDescriptor.getQ().getValue());
    }

    public static PublicKey getRSAKey(RSAKeyValue keyDescriptor) throws KeyException {
        String encodedModulus = keyDescriptor.getModulus().getValue();
        BigInteger modulus = new BigInteger(Base64.decode(encodedModulus));
        String encodedExponent = keyDescriptor.getExponent().getValue();
        BigInteger exponent = new BigInteger(Base64.decode(encodedExponent));
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
        return KeyInfoHelper.buildKey(keySpec, "RSA");
    }

    protected static PublicKey buildKey(KeySpec keySpec, String keyAlgorithm) throws KeyException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)(keyAlgorithm + " algorithm is not supported by this VM"), (Throwable)e);
            throw new KeyException(keyAlgorithm + "algorithm is not supported by the JCE", e);
        }
        catch (InvalidKeySpecException e) {
            log.error((Object)"Invalid key information", (Throwable)e);
            throw new KeyException("Invalid key information", e);
        }
    }

    protected static CertificateFactory getX509CertFactory() throws CertificateException {
        if (x509CertFactory == null) {
            x509CertFactory = CertificateFactory.getInstance("X.509");
        }
        return x509CertFactory;
    }
}

