/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature;

import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.SignatureImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signer {
    private static Logger log = Logger.getLogger(Signer.class);

    protected Signer() {
    }

    public static void signObjects(List<Signature> xmlObjects) {
        for (Signature xmlObject : xmlObjects) {
            Signer.signObject(xmlObject);
        }
    }

    public static void signObject(Signature signature) {
        try {
            XMLSignature xmlSignature = ((SignatureImpl)signature).getXMLSignature();
            if (xmlSignature == null) {
                log.warn((Object)"Unable to compute signature, Signature XMLObject does not have the XMLSignature created during marshalling.");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating XMLSignature object");
            }
            xmlSignature.sign(SecurityHelper.extractSigningKey(signature.getSigningCredential()));
        }
        catch (XMLSecurityException e) {
            log.error((Object)"An error occured computing the digital signature", (Throwable)e);
        }
    }

    static {
        if (!Init.isInitialized()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing XML security library");
            }
            Init.init();
        }
    }
}

