/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import org.apache.log4j.Logger;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureTrustEngine;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSignatureTrustEngine<TrustBasisType>
implements SignatureTrustEngine {
    private static Logger log = Logger.getLogger(BaseSignatureTrustEngine.class);
    private KeyInfoCredentialResolver keyInfoCredentialResolver;

    public BaseSignatureTrustEngine(KeyInfoCredentialResolver keyInfoResolver) {
        if (keyInfoResolver == null) {
            throw new IllegalArgumentException("KeyInfo credential resolver may not be null");
        }
        this.keyInfoCredentialResolver = keyInfoResolver;
    }

    @Override
    public KeyInfoCredentialResolver getKeyInfoResolver() {
        return this.keyInfoCredentialResolver;
    }

    @Override
    public boolean validate(byte[] signature, byte[] content, String sigAlg, Credential credential) throws SecurityException {
        return false;
    }

    protected boolean validate(Signature signature, TrustBasisType trustBasis) throws SecurityException {
        log.debug((Object)"Attempting to verify signature and establish trust using KeyInfo-derived credentials");
        if (signature.getKeyInfo() != null) {
            KeyInfoCriteria keyInfoCriteria = new KeyInfoCriteria(signature.getKeyInfo());
            CredentialCriteriaSet keyInfoCriteriaSet = new CredentialCriteriaSet(keyInfoCriteria);
            for (Credential kiCred : this.getKeyInfoResolver().resolve(keyInfoCriteriaSet)) {
                if (!this.verifySignature(signature, kiCred)) continue;
                log.debug((Object)"Successfully verified signature using KeyInfo-derived credential");
                log.debug((Object)"Attempting to establish trust of KeyInfo-derived credential");
                if (this.evaluateTrust(kiCred, trustBasis)) {
                    log.debug((Object)"Successfully established trust of KeyInfo-derived credential");
                    return true;
                }
                log.debug((Object)"Failed to establish trust of KeyInfo-derived credential");
            }
        } else {
            log.info((Object)"Signature contained no KeyInfo element, could not resolve verification credentials");
        }
        log.debug((Object)"Failed to verify signature and/or establish trust using any KeyInfo-derived credentials");
        return false;
    }

    protected abstract boolean evaluateTrust(Credential var1, TrustBasisType var2) throws SecurityException;

    protected boolean verifySignature(Signature signature, Credential credential) {
        SignatureValidator validator = new SignatureValidator(credential);
        try {
            validator.validate(signature);
        }
        catch (ValidationException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Signature validation using candidate validation credential failed", (Throwable)e);
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Signature validation using candidate credential was successful");
        }
        return true;
    }

    protected void checkParams(Signature signature, CriteriaSet trustBasisCriteria) throws SecurityException {
        if (signature == null) {
            throw new SecurityException("Signature was null");
        }
        if (trustBasisCriteria == null) {
            throw new SecurityException("Trust basis criteria set was null");
        }
        if (trustBasisCriteria.isEmpty()) {
            throw new SecurityException("Trust basis criteria set was empty");
        }
    }
}

