/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import org.apache.log4j.Logger;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialCriteriaSet;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.UsageCriteria;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.trust.ExplicitKeyTrustEvaluator;
import org.opensaml.xml.security.trust.TrustedCredentialTrustEngine;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.BaseSignatureTrustEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplicitKeySignatureTrustEngine
extends BaseSignatureTrustEngine<Iterable<Credential>>
implements TrustedCredentialTrustEngine<Signature> {
    private static Logger log = Logger.getLogger(ExplicitKeySignatureTrustEngine.class);
    private CredentialResolver credentialResolver;
    private ExplicitKeyTrustEvaluator keyTrust;

    public ExplicitKeySignatureTrustEngine(CredentialResolver resolver, KeyInfoCredentialResolver keyInfoResolver) {
        super(keyInfoResolver);
        if (resolver == null) {
            throw new IllegalArgumentException("Credential resolver may not be null");
        }
        this.credentialResolver = resolver;
        this.keyTrust = new ExplicitKeyTrustEvaluator();
    }

    @Override
    public CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    public boolean validate(Signature signature, CriteriaSet trustBasisCriteria) throws SecurityException {
        Iterable trustedCredentials;
        this.checkParams(signature, trustBasisCriteria);
        CredentialCriteriaSet credentialCriteria = SecurityHelper.getCredentialCriteria(trustBasisCriteria);
        if (!credentialCriteria.contains(UsageCriteria.class)) {
            credentialCriteria.add(new UsageCriteria(UsageType.SIGNING));
        }
        if (this.validate(signature, trustedCredentials = this.getCredentialResolver().resolve(credentialCriteria))) {
            return true;
        }
        log.debug((Object)"Attempting to verify signature using trusted credentials");
        for (Credential trustedCredential : trustedCredentials) {
            if (!this.verifySignature(signature, trustedCredential)) continue;
            log.debug((Object)"Successfully verified signature using resolved trusted credential");
            return true;
        }
        log.error((Object)"Failed to verify signature using either KeyInfo-derived or directly trusted credentials");
        return false;
    }

    @Override
    protected boolean evaluateTrust(Credential untrustedCredential, Iterable<Credential> trustedCredentials) throws SecurityException {
        return this.keyTrust.validate(untrustedCredential, trustedCredentials);
    }
}

