/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import java.util.Set;
import org.apache.log4j.Logger;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.x509.PKIXCriteriaSet;
import org.opensaml.xml.security.x509.PKIXTrustEngine;
import org.opensaml.xml.security.x509.PKIXTrustEvaluator;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.BaseSignatureTrustEngine;
import org.opensaml.xml.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKIXSignatureTrustEngine
extends BaseSignatureTrustEngine<Pair<Set<String>, Iterable<PKIXValidationInformation>>>
implements PKIXTrustEngine<Signature> {
    private static Logger log = Logger.getLogger(PKIXSignatureTrustEngine.class);
    private PKIXValidationInformationResolver pkixResolver;
    private PKIXTrustEvaluator pkixTrustEvaluator;

    public PKIXSignatureTrustEngine(PKIXValidationInformationResolver resolver, KeyInfoCredentialResolver keyInfoResolver) {
        super(keyInfoResolver);
        if (resolver == null) {
            throw new IllegalArgumentException("PKIX trust information resolver may not be null");
        }
        this.pkixResolver = resolver;
        this.pkixTrustEvaluator = new PKIXTrustEvaluator();
    }

    public PKIXTrustEvaluator getPKIXTrustEvaluator() {
        return this.pkixTrustEvaluator;
    }

    @Override
    public PKIXValidationInformationResolver getPKIXResolver() {
        return this.pkixResolver;
    }

    @Override
    public boolean validate(Signature signature, CriteriaSet trustBasisCriteria) throws SecurityException {
        Iterable validationInfoSet;
        Pair validationPair;
        this.checkParams(signature, trustBasisCriteria);
        PKIXCriteriaSet pkixCriteria = SecurityHelper.getPKIXCriteria(trustBasisCriteria);
        Set<String> trustedNames = null;
        if (this.pkixTrustEvaluator.isNameChecking()) {
            if (this.pkixResolver.supportsTrustedNameResolution()) {
                trustedNames = this.pkixResolver.resolveTrustedNames(pkixCriteria);
            } else {
                log.debug((Object)"PKIX resolver does not support resolution of trusted names, skipping name checking");
            }
        }
        if (this.validate(signature, validationPair = new Pair(trustedNames, validationInfoSet = this.pkixResolver.resolve(pkixCriteria)))) {
            return true;
        }
        log.error((Object)"PKIX validation of signature failed, unable to resolve valid and trusted signing key");
        return false;
    }

    @Override
    protected boolean evaluateTrust(Credential untrustedCredential, Pair<Set<String>, Iterable<PKIXValidationInformation>> validationPair) throws SecurityException {
        if (!(untrustedCredential instanceof X509Credential)) {
            log.info((Object)"Can not evaluate trust of non-X509Credential");
            return false;
        }
        X509Credential untrustedX509Credential = (X509Credential)untrustedCredential;
        Set<String> trustedNames = validationPair.getFirst();
        Iterable<PKIXValidationInformation> validationInfoSet = validationPair.getSecond();
        for (PKIXValidationInformation validationInfo : validationInfoSet) {
            if (!this.pkixTrustEvaluator.pkixValidate(validationInfo, trustedNames, untrustedX509Credential)) continue;
            log.debug((Object)"Signature trust established via PKIX validation of signing credential");
            return true;
        }
        return false;
    }
}

