/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.impl;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.signature.ContentReference;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.SignatureImpl;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureMarshaller
implements Marshaller {
    private static Logger log = Logger.getLogger(SignatureMarshaller.class);

    public SignatureMarshaller() {
        if (!Init.isInitialized()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initializing XML security library");
            }
            Init.init();
        }
    }

    public Element marshall(XMLObject xmlObject) throws MarshallingException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            return this.marshall(xmlObject, document);
        }
        catch (ParserConfigurationException e) {
            throw new MarshallingException("Unable to create Document to place marshalled elements in", e);
        }
    }

    public Element marshall(XMLObject xmlObject, Element parentElement) throws MarshallingException {
        Element signatureElement = this.createSignatureElement((SignatureImpl)xmlObject, parentElement.getOwnerDocument());
        XMLHelper.appendChildElement(parentElement, signatureElement);
        return signatureElement;
    }

    public Element marshall(XMLObject xmlObject, Document document) throws MarshallingException {
        Element signatureElement = this.createSignatureElement((SignatureImpl)xmlObject, document);
        Element documentRoot = document.getDocumentElement();
        if (documentRoot != null) {
            document.replaceChild(signatureElement, documentRoot);
        } else {
            document.appendChild(signatureElement);
        }
        return signatureElement;
    }

    private Element createSignatureElement(Signature signature, Document document) throws MarshallingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting to marshall " + signature.getElementQName()));
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating XMLSignature object");
            }
            XMLSignature dsig = null;
            dsig = signature.getHMACOutputLength() != null && SecurityHelper.isHMAC(signature.getSignatureAlgorithm()) ? new XMLSignature(document, "", signature.getSignatureAlgorithm(), signature.getHMACOutputLength().intValue(), signature.getCanonicalizationAlgorithm()) : new XMLSignature(document, "", signature.getSignatureAlgorithm(), signature.getCanonicalizationAlgorithm());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding content to XMLSignature.");
            }
            for (ContentReference contentReference : signature.getContentReferences()) {
                contentReference.createReference(dsig);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating Signature DOM element");
            }
            Element signatureElement = dsig.getElement();
            if (signature.getKeyInfo() != null) {
                Marshaller keyInfoMarshaller = Configuration.getMarshallerFactory().getMarshaller(KeyInfo.DEFAULT_ELEMENT_NAME);
                keyInfoMarshaller.marshall((XMLObject)signature.getKeyInfo(), signatureElement);
            }
            ((SignatureImpl)signature).setXMLSignature(dsig);
            signature.setDOM(signatureElement);
            signature.releaseParentDOM(true);
            return signatureElement;
        }
        catch (XMLSecurityException e) {
            log.error((Object)("Unable to construct signature Element " + signature.getElementQName()), (Throwable)e);
            throw new MarshallingException("Unable to construct signature Element " + signature.getElementQName(), (Exception)((Object)e));
        }
    }
}

