/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatatypeHelper {
    private static DatatypeFactory dataTypeFactory;

    private DatatypeHelper() {
    }

    public static DatatypeFactory getDataTypeFactory() {
        if (dataTypeFactory == null) {
            try {
                dataTypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                // empty catch block
            }
        }
        return dataTypeFactory;
    }

    public static boolean isEmpty(String s) {
        String sTrimmed;
        return s == null || (sTrimmed = s.trim()).length() <= 0;
    }

    public static <T> boolean safeEquals(T s1, T s2) {
        if (s1 == null || s2 == null) {
            return s1 == s2;
        }
        return s1.equals(s2);
    }

    public static String safeTrim(String s) {
        if (s != null) {
            return s.trim();
        }
        return null;
    }

    public static String safeTrimOrNullString(String s) {
        String sTrimmed;
        if (s != null && (sTrimmed = s.trim()).length() > 0) {
            return sTrimmed;
        }
        return null;
    }

    public static String inputstreamToString(InputStream input, CharsetDecoder decoder) throws IOException {
        CharsetDecoder charsetDecoder = decoder;
        if (decoder == null) {
            charsetDecoder = Charset.defaultCharset().newDecoder();
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, charsetDecoder));
        char[] chars = new char[1024];
        while (reader.read(chars) > -1) {
            stringBuffer.append(String.valueOf(chars));
            chars = new char[1024];
        }
        reader.close();
        return stringBuffer.toString();
    }
}

