/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.validation;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.opensaml.xml.AbstractXMLObject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.validation.ValidatingXMLObject;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidatingXMLObject
extends AbstractXMLObject
implements ValidatingXMLObject {
    private static Logger log = Logger.getLogger(AbstractValidatingXMLObject.class);
    private List<Validator> validators = new LinkedList<Validator>();

    protected AbstractValidatingXMLObject(String namespaceURI, String elementLocalName, String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
    }

    @Override
    public List<Validator> getValidators() {
        if (this.validators.size() > 0) {
            return Collections.unmodifiableList(this.validators);
        }
        return null;
    }

    @Override
    public void registerValidator(Validator validator) {
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    @Override
    public void deregisterValidator(Validator validator) {
        this.validators.remove(validator);
    }

    @Override
    public void validate(boolean validateDescendants) throws ValidationException {
        for (Validator validator : this.validators) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validating " + this.getElementQName() + " using Validator class" + validator.getClass().getName()));
            }
            validator.validate(this);
        }
        if (validateDescendants) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Validating descendants of " + this.getElementQName()));
            }
            this.validateChildren(this);
        }
    }

    protected void validateChildren(XMLObject xmlObject) throws ValidationException {
        for (XMLObject childObject : xmlObject.getOrderedChildren()) {
            if (childObject instanceof ValidatingXMLObject) {
                ((ValidatingXMLObject)childObject).validate(false);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)(childObject.getElementQName() + " does not implement ValidatingXMLObject, ignoring it."));
            }
            if (!childObject.hasChildren()) continue;
            this.validateChildren(childObject);
        }
    }
}

