/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.gguava.eventbus;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import org.nnsoft.guice.gguava.eventbus.BusMatcher;

public abstract class EventBusModule
extends AbstractModule {
    protected BusMatcher bindBus(final String identifier) {
        Preconditions.checkArgument((identifier != null ? 1 : 0) != 0, (Object)"Event bus identifier must be not null");
        return new BusMatcher(){

            @Override
            public void toAnyBoundClass() {
                this.to((Matcher<Object>)Matchers.any());
            }

            @Override
            public void to(Matcher<Object> matcher) {
                Preconditions.checkArgument((matcher != null ? 1 : 0) != 0, (Object)"Event bus matcher must be not null");
                final EventBus eventBus = new EventBus(identifier);
                EventBusModule.this.bind(EventBus.class).annotatedWith((Annotation)Names.named((String)identifier)).toInstance((Object)eventBus);
                EventBusModule.this.bindListener(matcher, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                        typeEncounter.register(new InjectionListener<I>(){

                            public void afterInjection(I injectee) {
                                eventBus.register(injectee);
                            }
                        });
                    }
                });
            }
        };
    }
}

