/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.maven.plugin;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.antublue.test.engine.AntuBLUETestEngine;
import org.antublue.test.engine.internal.configuration.Configuration;
import org.antublue.test.engine.internal.util.AnsiColor;
import org.antublue.test.engine.maven.plugin.Information;
import org.antublue.test.engine.maven.plugin.listener.DelegatingEngineExecutionListener;
import org.antublue.test.engine.maven.plugin.listener.StatusEngineExecutionListener;
import org.antublue.test.engine.maven.plugin.listener.SummaryEngineExecutionListener;
import org.antublue.test.engine.maven.plugin.logger.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

@Mojo(name="test", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class AntuBLUETestEngineMavenPlugin
extends AbstractMojo {
    private static final String GROUP_ID = "org.antublue";
    private static final String ARTIFACT_ID = "test-engine-maven-plugin";
    private static final String VERSION = Information.getInstance().getVersion();
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="properties")
    private Map<String, String> properties;

    public void execute() throws MojoFailureException, MojoExecutionException {
        Logger logger = Logger.from(this.getLog());
        try {
            List artifactList;
            Set artifactSet;
            Artifact artifact;
            Object path;
            Configuration configuration = Configuration.getInstance();
            configuration.set("antublue.test.engine.maven.plugin", "true");
            logger.debug("property [%s] = [%s]", "antublue.test.engine.maven.plugin", "true");
            if (this.mavenSession.getRequest().isInteractiveMode()) {
                configuration.set("antublue.test.engine.maven.plugin.mode", "antublue.test.engine.maven.plugin.interactive");
                logger.debug("property [%s] = [%s]", "antublue.test.engine.maven.plugin.mode", "antublue.test.engine.maven.plugin.interactive");
            } else {
                configuration.set("antublue.test.engine.maven.plugin.mode", "antublue.test.engine.maven.plugin.batch");
                logger.debug("property [%s] = [%s]", "antublue.test.engine.maven.plugin.mode", "antublue.test.engine.maven.plugin.mode");
            }
            if (this.properties != null) {
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    System.setProperty(entry.getKey(), entry.getValue());
                    logger.debug("property [%s] = [%s]", entry.getKey(), entry.getValue());
                }
            }
            LinkedHashSet<Object> artifactPaths = new LinkedHashSet<Object>();
            List classpathElements = this.mavenProject.getCompileClasspathElements();
            if (classpathElements != null) {
                for (String classpathElement : classpathElements) {
                    path = new File(classpathElement).toPath();
                    artifactPaths.add(path);
                    logger.debug("classpathElement [%s]", path);
                }
            }
            if ((classpathElements = this.mavenProject.getCompileClasspathElements()) != null) {
                for (String classpathElement : classpathElements) {
                    path = new File(classpathElement).toPath();
                    artifactPaths.add(path);
                    logger.debug("classpathElement [%s]", path);
                }
            }
            if ((classpathElements = this.mavenProject.getRuntimeClasspathElements()) != null) {
                for (String classpathElement : classpathElements) {
                    path = new File(classpathElement).toPath();
                    artifactPaths.add(path);
                    logger.debug("classpathElement [%s]", path);
                }
            }
            if ((classpathElements = this.mavenProject.getTestClasspathElements()) != null) {
                for (String classpathElement : classpathElements) {
                    path = new File(classpathElement).toPath();
                    artifactPaths.add(path);
                    logger.debug("classpathElement [%s]", path);
                }
            }
            if ((artifact = this.mavenProject.getArtifact()) != null) {
                Path path2 = artifact.getFile().toPath();
                artifactPaths.add(path2);
                logger.debug("classpathElement [%s]", path2);
            }
            if ((artifactSet = this.mavenProject.getDependencyArtifacts()) != null) {
                for (Artifact a : artifactSet) {
                    Path path3 = a.getFile().toPath();
                    artifactPaths.add(path3);
                    logger.debug("classpathElement [%s]", path3);
                }
            }
            if ((artifactList = this.mavenProject.getAttachedArtifacts()) != null) {
                for (Artifact a : artifactList) {
                    Path path2 = a.getFile().toPath();
                    artifactPaths.add(path2);
                    logger.debug("classpathElement [%s]", path2);
                }
            }
            LinkedHashMap<String, URL> urls = new LinkedHashMap<String, URL>();
            for (Path path3 : artifactPaths) {
                URL url = path3.toUri().toURL();
                urls.putIfAbsent(url.getPath(), url);
            }
            System.setProperty("java.class.path", AntuBLUETestEngineMavenPlugin.buildClasspath(urls.values()));
            URLClassLoader classLoader = new URLClassLoader(urls.values().toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
            SummaryEngineExecutionListener summaryEngineExecutionListener = new SummaryEngineExecutionListener();
            String summaryMessage = null;
            DelegatingEngineExecutionListener delegatingEngineExecutionListener = DelegatingEngineExecutionListener.of(summaryEngineExecutionListener, new StatusEngineExecutionListener());
            LauncherConfig launcherConfig = LauncherConfig.builder().build();
            LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClasspathRoots(artifactPaths)).filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])new String[]{".*"})}).configurationParameters(Collections.emptyMap()).build();
            AntuBLUETestEngine engine = new AntuBLUETestEngine();
            TestDescriptor testDescriptor = null;
            try {
                summaryEngineExecutionListener.begin();
                testDescriptor = engine.discover((EngineDiscoveryRequest)launcherDiscoveryRequest, UniqueId.forEngine((String)"antublue-test-engine"));
            }
            catch (Throwable t) {
                summaryMessage = AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap((Object)"EXCEPTION DURING DISCOVERY");
                t.printStackTrace(System.err);
                System.err.flush();
            }
            if (testDescriptor != null) {
                try {
                    ExecutionRequest executionRequest = new ExecutionRequest(testDescriptor, (EngineExecutionListener)delegatingEngineExecutionListener, (ConfigurationParameters)Configuration.getInstance());
                    engine.execute(executionRequest);
                    summaryMessage = summaryEngineExecutionListener.hasTests() ? (summaryEngineExecutionListener.hasFailures() ? AnsiColor.TEXT_RED_BOLD.wrap((Object)"FAIL") : AnsiColor.TEXT_GREEN_BOLD.wrap((Object)"PASS")) : AnsiColor.TEXT_RED_BOLD.wrap((Object)"FAIL / NO TESTS EXECUTED");
                }
                catch (Throwable t) {
                    summaryMessage = AnsiColor.TEXT_RED_BOLD.wrap((Object)"FAIL / EXCEPTION DURING EXECUTION");
                    t.printStackTrace(System.err);
                    System.err.flush();
                }
            }
            summaryEngineExecutionListener.end(summaryMessage);
            if (!summaryEngineExecutionListener.hasTests() || summaryEngineExecutionListener.hasFailures()) {
                throw new MojoFailureException("");
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new MojoExecutionException(t);
        }
    }

    private static String buildClasspath(Collection<URL> urls) {
        StringJoiner stringJoiner = new StringJoiner(File.pathSeparator);
        for (URL url : urls) {
            stringJoiner.add(url.getPath());
        }
        return stringJoiner.toString();
    }
}

