/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.maven.plugin.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.reporting.ReportEntry;

public class DelegatingEngineExecutionListener
implements EngineExecutionListener {
    private final List<EngineExecutionListener> engineExecutionListeners = new ArrayList<EngineExecutionListener>();

    private DelegatingEngineExecutionListener() {
    }

    private void addListener(EngineExecutionListener delegatedEngineExecutionListener) {
        this.engineExecutionListeners.add(delegatedEngineExecutionListener);
    }

    public void dynamicTestRegistered(TestDescriptor testDescriptor) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.dynamicTestRegistered(testDescriptor));
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.executionSkipped(testDescriptor, reason));
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.executionStarted(testDescriptor));
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.executionFinished(testDescriptor, testExecutionResult));
    }

    public void reportingEntryPublished(TestDescriptor testDescriptor, ReportEntry entry) {
        this.engineExecutionListeners.forEach(engineExecutionListener -> engineExecutionListener.reportingEntryPublished(testDescriptor, entry));
    }

    public static DelegatingEngineExecutionListener of(EngineExecutionListener ... engineExecutionListeners) {
        DelegatingEngineExecutionListener delegatingEngineExecutionListener = new DelegatingEngineExecutionListener();
        Arrays.stream(engineExecutionListeners).forEach(delegatingEngineExecutionListener::addListener);
        return delegatingEngineExecutionListener;
    }
}

