/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.test.engine.maven.plugin.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antublue.test.engine.AntuBLUETestEngine;
import org.antublue.test.engine.internal.descriptor.ArgumentTestDescriptor;
import org.antublue.test.engine.internal.descriptor.ClassTestDescriptor;
import org.antublue.test.engine.internal.descriptor.TestMethodTestDescriptor;
import org.antublue.test.engine.internal.metadata.Metadata;
import org.antublue.test.engine.internal.metadata.MetadataInformation;
import org.antublue.test.engine.internal.util.AnsiColor;
import org.antublue.test.engine.internal.util.AnsiColorStringBuilder;
import org.antublue.test.engine.internal.util.HumanReadableTimeUtils;
import org.antublue.test.engine.internal.util.StopWatch;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;

public class SummaryEngineExecutionListener
implements EngineExecutionListener {
    private static final String BANNER = new AnsiColorStringBuilder().color(AnsiColor.TEXT_WHITE_BRIGHT).append("Antu").color(AnsiColor.TEXT_BLUE_BOLD_BRIGHT).append("BLUE").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" Test Engine ").append(AntuBLUETestEngine.VERSION).color(AnsiColor.TEXT_RESET).toString();
    private static final String SUMMARY_BANNER = BANNER + AnsiColor.TEXT_WHITE_BRIGHT.wrap((Object)" Summary");
    private static final String SEPARATOR = AnsiColor.TEXT_WHITE_BRIGHT.wrap((Object)"------------------------------------------------------------------------");
    private static final String INFO = new AnsiColorStringBuilder().color(AnsiColor.TEXT_WHITE).append("[").color(AnsiColor.TEXT_BLUE_BOLD).append("INFO").color(AnsiColor.TEXT_WHITE).append("]").color(AnsiColor.TEXT_RESET).append(" ").toString();
    private boolean hasTests;
    private boolean hasFailures;
    private final List<TestDescriptor> testDescriptors = Collections.synchronizedList(new ArrayList());
    private final StopWatch stopWatch = new StopWatch();

    public void begin() {
        this.stopWatch.reset();
        SummaryEngineExecutionListener.println(INFO + SEPARATOR);
        SummaryEngineExecutionListener.println(INFO + BANNER);
        SummaryEngineExecutionListener.println(INFO + SEPARATOR);
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        if (!testDescriptor.isRoot()) {
            this.hasTests = true;
        }
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        this.testDescriptors.add(testDescriptor);
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        this.testDescriptors.add(testDescriptor);
        if (!testDescriptor.isRoot() && testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.hasFailures = true;
        }
    }

    public void end(String message) {
        this.stopWatch.stop();
        long classTestDescriptorFound = 0L;
        long classTestDescriptorSuccess = 0L;
        long classTestDescriptorFailure = 0L;
        long classTestDescriptorSkipped = 0L;
        long argumentTestDescriptorFound = 0L;
        long argumentTestDescriptorSuccess = 0L;
        long argumentTestDescriptorFailure = 0L;
        long argumentTestDescriptorSkipped = 0L;
        long methodTestDescriptorFound = 0L;
        long methodTestDescriptorSuccess = 0L;
        long methodTestDescriptorFailure = 0L;
        long methodTestDescriptorSkipped = 0L;
        for (TestDescriptor testDescriptor : this.testDescriptors) {
            if (!(testDescriptor instanceof Metadata)) continue;
            Metadata metadata = (Metadata)testDescriptor;
            MetadataInformation metadataInformation = metadata.getMetadata();
            String testDescriptorStatus = (String)metadataInformation.get("testDescriptorStatus");
            if (testDescriptor instanceof TestMethodTestDescriptor) {
                ++methodTestDescriptorFound;
                switch (testDescriptorStatus) {
                    case "PASS": {
                        ++methodTestDescriptorSuccess;
                        break;
                    }
                    case "FAIL": {
                        ++methodTestDescriptorFailure;
                        break;
                    }
                    case "SKIP": {
                        ++methodTestDescriptorSkipped;
                        break;
                    }
                }
                continue;
            }
            if (testDescriptor instanceof ClassTestDescriptor) {
                ++classTestDescriptorFound;
                switch (testDescriptorStatus) {
                    case "PASS": {
                        ++classTestDescriptorSuccess;
                        break;
                    }
                    case "FAIL": {
                        ++classTestDescriptorFailure;
                        break;
                    }
                    case "SKIP": {
                        ++classTestDescriptorSkipped;
                        break;
                    }
                }
                continue;
            }
            if (!(testDescriptor instanceof ArgumentTestDescriptor)) continue;
            ++argumentTestDescriptorFound;
            switch (testDescriptorStatus) {
                case "PASS": {
                    ++argumentTestDescriptorSuccess;
                    break;
                }
                case "FAIL": {
                    ++argumentTestDescriptorFailure;
                    break;
                }
                case "SKIP": {
                    ++argumentTestDescriptorSkipped;
                    break;
                }
            }
        }
        int columnWidthFound = SummaryEngineExecutionListener.getColumnWith(classTestDescriptorFound, argumentTestDescriptorFound, methodTestDescriptorFound);
        int columnWidthSuccess = SummaryEngineExecutionListener.getColumnWith(classTestDescriptorSuccess, argumentTestDescriptorSuccess, methodTestDescriptorSuccess);
        int columnWidthFailure = SummaryEngineExecutionListener.getColumnWith(classTestDescriptorFailure, argumentTestDescriptorFailure, methodTestDescriptorFailure);
        int columnWidthSkipped = SummaryEngineExecutionListener.getColumnWith(classTestDescriptorSkipped, argumentTestDescriptorSkipped, methodTestDescriptorSkipped);
        if (this.hasTests) {
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            SummaryEngineExecutionListener.println(INFO + SUMMARY_BANNER);
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            SummaryEngineExecutionListener.println(new AnsiColorStringBuilder().append(INFO).color(AnsiColor.TEXT_WHITE_BRIGHT).append("Test Classes   : ").append(SummaryEngineExecutionListener.pad(classTestDescriptorFound, columnWidthFound)).append(", ").color(AnsiColor.TEXT_GREEN_BRIGHT).append("PASSED").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" : ").append(SummaryEngineExecutionListener.pad(classTestDescriptorSuccess, columnWidthSuccess)).append(", ").color(AnsiColor.TEXT_RED_BRIGHT).append("FAILED").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" : ").append(SummaryEngineExecutionListener.pad(classTestDescriptorFailure, columnWidthFailure)).append(", ").color(AnsiColor.TEXT_YELLOW_BRIGHT).append("SKIPPED").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" : ").append(SummaryEngineExecutionListener.pad(classTestDescriptorSkipped, columnWidthSkipped)).append((Object)AnsiColor.TEXT_RESET));
            if (argumentTestDescriptorFound > 0L) {
                SummaryEngineExecutionListener.println(new AnsiColorStringBuilder().append(INFO).color(AnsiColor.TEXT_WHITE_BRIGHT).append("Test Arguments : ").append(SummaryEngineExecutionListener.pad(argumentTestDescriptorFound, columnWidthFound)).append(", ").color(AnsiColor.TEXT_GREEN_BRIGHT).append("PASSED").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" : ").append(SummaryEngineExecutionListener.pad(argumentTestDescriptorSuccess, columnWidthSuccess)).append(", ").color(AnsiColor.TEXT_RED_BRIGHT).append("FAILED").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" : ").append(SummaryEngineExecutionListener.pad(argumentTestDescriptorFailure, columnWidthFailure)).append(", ").color(AnsiColor.TEXT_YELLOW_BRIGHT).append("SKIPPED").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" : ").append(SummaryEngineExecutionListener.pad(argumentTestDescriptorSkipped, columnWidthSkipped)).append((Object)AnsiColor.TEXT_RESET));
            }
            SummaryEngineExecutionListener.println(new AnsiColorStringBuilder().append(INFO).color(AnsiColor.TEXT_WHITE_BRIGHT).append("Test Methods   : ").append(SummaryEngineExecutionListener.pad(methodTestDescriptorFound, columnWidthFound)).append(", ").color(AnsiColor.TEXT_GREEN_BRIGHT).append("PASSED").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" : ").append(SummaryEngineExecutionListener.pad(methodTestDescriptorSuccess, columnWidthSuccess)).append(", ").color(AnsiColor.TEXT_RED_BRIGHT).append("FAILED").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" : ").append(SummaryEngineExecutionListener.pad(methodTestDescriptorFailure, columnWidthFailure)).append(", ").color(AnsiColor.TEXT_YELLOW_BRIGHT).append("SKIPPED").color(AnsiColor.TEXT_WHITE_BRIGHT).append(" : ").append(SummaryEngineExecutionListener.pad(methodTestDescriptorSkipped, columnWidthSkipped)).append((Object)AnsiColor.TEXT_RESET));
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
        }
        SummaryEngineExecutionListener.println(INFO + message);
        SummaryEngineExecutionListener.println(INFO + SEPARATOR);
        long elapsedTime = this.stopWatch.elapsedNanoseconds();
        SummaryEngineExecutionListener.println(new AnsiColorStringBuilder().append(INFO).color(AnsiColor.TEXT_WHITE_BRIGHT).append("Total Test Time : ").append(HumanReadableTimeUtils.toHumanReadable((long)elapsedTime, (boolean)false)).append(" (").append((double)elapsedTime / 1000000.0).append(" ms)").color(AnsiColor.TEXT_RESET));
        SummaryEngineExecutionListener.println(new AnsiColorStringBuilder().append(INFO).color(AnsiColor.TEXT_WHITE_BRIGHT).append("Finished At     : ").append(HumanReadableTimeUtils.now()).color(AnsiColor.TEXT_RESET));
        if (!this.hasFailures) {
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
        }
    }

    public boolean hasTests() {
        return this.hasTests;
    }

    public boolean hasFailures() {
        return this.hasFailures;
    }

    private static void println(Object object) {
        System.out.println(object);
        System.out.flush();
    }

    private static int getColumnWith(long ... values) {
        int width = 0;
        for (long value : values) {
            width = Math.max(String.valueOf(value).length(), width);
        }
        return width;
    }

    private static String pad(long value, long width) {
        String stringValue = String.valueOf(value);
        StringBuilder paddingStringBuilder = new StringBuilder();
        while ((long)(paddingStringBuilder.length() + stringValue.length()) < width) {
            paddingStringBuilder.append(" ");
        }
        return paddingStringBuilder.append(stringValue).toString();
    }
}

