/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.redback.users;

import java.util.ArrayList;
import java.util.List;
import org.apache.archiva.redback.users.User;
import org.apache.archiva.redback.users.UserManager;
import org.apache.archiva.redback.users.UserManagerException;
import org.apache.archiva.redback.users.UserManagerListener;
import org.apache.archiva.redback.users.UserNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUserManager
implements UserManager {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private List<UserManagerListener> listeners = new ArrayList<UserManagerListener>();

    @Override
    public void addUserManagerListener(UserManagerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeUserManagerListener(UserManagerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireUserManagerInit(boolean freshDatabase) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerInit(freshDatabase);
            }
            catch (Exception e) {}
        }
    }

    protected void fireUserManagerUserAdded(User addedUser) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerUserAdded(addedUser);
            }
            catch (Exception e) {}
        }
    }

    protected void fireUserManagerUserRemoved(User removedUser) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerUserRemoved(removedUser);
            }
            catch (Exception e) {}
        }
    }

    protected void fireUserManagerUserUpdated(User updatedUser) {
        for (UserManagerListener listener : this.listeners) {
            try {
                listener.userManagerUserUpdated(updatedUser);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public User getGuestUser() throws UserNotFoundException, UserManagerException {
        return this.findUser("guest");
    }

    @Override
    public User createGuestUser() throws UserManagerException {
        try {
            User u = this.getGuestUser();
            if (u != null) {
                return u;
            }
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        User user = this.createUser("guest", "Guest", "");
        user.setPermanent(true);
        user.setPasswordChangeRequired(false);
        user = this.addUser(user);
        return user;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isFinalImplementation() {
        return false;
    }

    protected List<UserManagerListener> getListeners() {
        return this.listeners;
    }
}

