/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.file;

import org.apache.arrow.dataset.file.FileFormat;
import org.apache.arrow.dataset.file.JniWrapper;
import org.apache.arrow.dataset.jni.NativeDatasetFactory;
import org.apache.arrow.dataset.jni.NativeMemoryPool;
import org.apache.arrow.memory.BufferAllocator;

public class FileSystemDatasetFactory
extends NativeDatasetFactory {
    public FileSystemDatasetFactory(BufferAllocator allocator, NativeMemoryPool memoryPool, FileFormat format, String uri) {
        super(allocator, memoryPool, FileSystemDatasetFactory.createNative(format, uri));
    }

    public FileSystemDatasetFactory(BufferAllocator allocator, NativeMemoryPool memoryPool, FileFormat format, String[] uris) {
        super(allocator, memoryPool, FileSystemDatasetFactory.createNative(format, uris));
    }

    private static long createNative(FileFormat format, String uri) {
        return JniWrapper.get().makeFileSystemDatasetFactory(uri, format.id());
    }

    private static long createNative(FileFormat format, String[] uris) {
        return JniWrapper.get().makeFileSystemDatasetFactory(uris, format.id());
    }
}

