/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.clustering.context.ContextClusteringCommand;
import org.apache.axis2.clustering.context.commands.ContextClusteringCommandCollection;
import org.apache.axis2.clustering.context.commands.DeleteServiceGroupContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateConfigurationContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateServiceContextCommand;
import org.apache.axis2.clustering.context.commands.UpdateServiceGroupContextCommand;
import org.apache.axis2.clustering.tribes.AckManager;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.PropertyDifference;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ContextClusteringCommandFactory {
    private static final Log log = LogFactory.getLog((Class)ContextClusteringCommandFactory.class);

    public static ContextClusteringCommandCollection getCommandCollection(AbstractContext[] contexts, Map excludedReplicationPatterns) {
        ArrayList<ContextClusteringCommand> commands = new ArrayList<ContextClusteringCommand>(contexts.length);
        ContextClusteringCommandCollection collection = new ContextClusteringCommandCollection(commands);
        for (int i = 0; i < contexts.length; ++i) {
            ContextClusteringCommand cmd = ContextClusteringCommandFactory.getUpdateCommand(contexts[i], excludedReplicationPatterns, false);
            if (cmd == null) continue;
            commands.add(cmd);
        }
        collection.setUniqueId(UUIDGenerator.getUUID());
        AckManager.addInitialAcknowledgement(collection);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextClusteringCommand getUpdateCommand(AbstractContext context, Map excludedPropertyPatterns, boolean includeAllProperties) {
        UpdateContextCommand cmd = null;
        if (context instanceof ConfigurationContext) {
            cmd = new UpdateConfigurationContextCommand();
        } else if (context instanceof ServiceGroupContext) {
            ServiceGroupContext sgCtx = (ServiceGroupContext)context;
            cmd = new UpdateServiceGroupContextCommand();
            UpdateServiceGroupContextCommand updateSgCmd = (UpdateServiceGroupContextCommand)cmd;
            updateSgCmd.setServiceGroupName(sgCtx.getDescription().getServiceGroupName());
            updateSgCmd.setServiceGroupContextId(sgCtx.getId());
        } else if (context instanceof ServiceContext) {
            ServiceContext serviceCtx = (ServiceContext)context;
            cmd = new UpdateServiceContextCommand();
            UpdateServiceContextCommand updateServiceCmd = (UpdateServiceContextCommand)cmd;
            String sgName = serviceCtx.getServiceGroupContext().getDescription().getServiceGroupName();
            updateServiceCmd.setServiceGroupName(sgName);
            updateServiceCmd.setServiceGroupContextId(serviceCtx.getServiceGroupContext().getId());
            updateServiceCmd.setServiceName(serviceCtx.getAxisService().getName());
        }
        if (cmd != null) {
            cmd.setUniqueId(UUIDGenerator.getUUID());
            ContextClusteringCommandFactory.fillProperties(cmd, context, excludedPropertyPatterns, includeAllProperties);
            if (cmd.isPropertiesEmpty()) {
                cmd = null;
            } else {
                AckManager.addInitialAcknowledgement(cmd);
            }
        }
        AbstractContext abstractContext = context;
        synchronized (abstractContext) {
            context.clearPropertyDifferences();
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillProperties(UpdateContextCommand updateCmd, AbstractContext context, Map excludedPropertyPatterns, boolean includeAllProperties) {
        if (!includeAllProperties) {
            AbstractContext abstractContext = context;
            synchronized (abstractContext) {
                Map diffs = context.getPropertyDifferences();
                Iterator iter = diffs.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object prop = context.getPropertyNonReplicable(key);
                    if (!(prop instanceof Serializable) || ContextClusteringCommandFactory.isExcluded(key, context.getClass().getName(), excludedPropertyPatterns)) continue;
                    log.debug((Object)("sending property =" + key + "-" + prop));
                    PropertyDifference diff = (PropertyDifference)diffs.get(key);
                    diff.setValue(prop);
                    updateCmd.addProperty(diff);
                }
            }
        }
        AbstractContext abstractContext = context;
        synchronized (abstractContext) {
            Iterator iter = context.getPropertyNames();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object prop = context.getPropertyNonReplicable(key);
                if (!(prop instanceof Serializable) || ContextClusteringCommandFactory.isExcluded(key, context.getClass().getName(), excludedPropertyPatterns)) continue;
                log.debug((Object)("sending property =" + key + "-" + prop));
                PropertyDifference diff = new PropertyDifference(key, prop, false);
                updateCmd.addProperty(diff);
            }
        }
    }

    private static boolean isExcluded(String propertyName, String ctxClassName, Map excludedPropertyPatterns) {
        List defaultExcludes = (List)excludedPropertyPatterns.get("defaults");
        if (defaultExcludes == null) {
            return false;
        }
        if (ContextClusteringCommandFactory.isExcluded(defaultExcludes, propertyName)) {
            return true;
        }
        List specificExcludes = (List)excludedPropertyPatterns.get(ctxClassName);
        return ContextClusteringCommandFactory.isExcluded(specificExcludes, propertyName);
    }

    private static boolean isExcluded(List list, String propertyName) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String pattern = (String)iter.next();
            if (!(pattern.startsWith("*") ? propertyName.endsWith(pattern = pattern.replaceAll("\\*", "")) : (pattern.endsWith("*") ? propertyName.startsWith(pattern = pattern.replaceAll("\\*", "")) : pattern.equals(propertyName)))) continue;
            return true;
        }
        return false;
    }

    public static ContextClusteringCommand getRemoveCommand(AbstractContext abstractContext) {
        if (abstractContext instanceof ServiceGroupContext) {
            ServiceGroupContext sgCtx = (ServiceGroupContext)abstractContext;
            DeleteServiceGroupContextCommand cmd = new DeleteServiceGroupContextCommand();
            cmd.setUniqueId(UUIDGenerator.getUUID());
            cmd.setServiceGroupContextId(sgCtx.getId());
            return cmd;
        }
        return null;
    }
}

