/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.control;

import java.io.FileNotFoundException;
import java.util.Iterator;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringUtils;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.engine.AxisConfiguration;

public class GetConfigurationResponseCommand
extends ControlCommand {
    private String[] serviceGroups;

    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        if (configContext.getPropertyNonReplicable("local_cluster.initialized") == null && this.serviceGroups != null) {
            String serviceGroup;
            for (int i = 0; i < this.serviceGroups.length; ++i) {
                serviceGroup = this.serviceGroups[i];
                if (axisConfig.getServiceGroup(serviceGroup) != null) continue;
                try {
                    ClusteringUtils.loadServiceGroup(serviceGroup, configContext, System.getProperty("axis2.work.dir"));
                    continue;
                }
                catch (FileNotFoundException ignored) {
                    continue;
                }
                catch (Exception e) {
                    throw new ClusteringFault(e);
                }
            }
            Iterator iter = axisConfig.getServiceGroups();
            while (iter.hasNext()) {
                serviceGroup = (AxisServiceGroup)iter.next();
                boolean foundServiceGroup = false;
                for (int i = 0; i < this.serviceGroups.length; ++i) {
                    String serviceGroupName = this.serviceGroups[i];
                    if (!serviceGroup.getServiceGroupName().equals(serviceGroupName)) continue;
                    foundServiceGroup = true;
                    break;
                }
                if (foundServiceGroup) continue;
                boolean mustUnloadServiceGroup = true;
                Iterator serviceIter = serviceGroup.getServices();
                while (serviceIter.hasNext()) {
                    AxisService service = (AxisService)serviceIter.next();
                    if (!service.isClientSide() && service.getParameter("moduleService") == null) continue;
                    mustUnloadServiceGroup = false;
                    break;
                }
                if (!mustUnloadServiceGroup) continue;
                try {
                    axisConfig.removeServiceGroup(serviceGroup.getServiceGroupName());
                }
                catch (Exception e) {
                    throw new ClusteringFault(e);
                }
            }
        }
    }

    public void setServiceGroups(String[] serviceGroups) {
        this.serviceGroups = serviceGroups;
    }

    public String toString() {
        return "GetConfigurationResponseCommand";
    }
}

