/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TribesUtil {
    private static Log log = LogFactory.getLog((Class)TribesUtil.class);

    public static void printMembers(MembershipManager membershipManager) {
        Member[] members = membershipManager.getMembers();
        if (members != null) {
            int length = members.length;
            if (length > 0) {
                log.info((Object)"Members of current cluster");
                for (int i = 0; i < length; ++i) {
                    log.info((Object)("Member" + (i + 1) + " " + TribesUtil.getHost(members[i])));
                }
            } else {
                log.info((Object)"No members in current cluster");
            }
        }
    }

    public static String getHost(Member member) {
        byte[] hostBytes = member.getHost();
        StringBuffer host = new StringBuffer();
        if (hostBytes != null) {
            for (int i = 0; i < hostBytes.length; ++i) {
                int hostByte = hostBytes[i] >= 0 ? hostBytes[i] : hostBytes[i] + 256;
                host.append(hostByte).append(".");
            }
        }
        return host.append(":").append(member.getPort()).toString();
    }

    public static String getLocalHost(Channel channel) {
        return TribesUtil.getHost(channel.getLocalMember(true));
    }
}

