/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tools.idea;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.axis2.tools.bean.CodegenBean;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.axis2.tools.idea.PackageNameTableModel;
import org.apache.axis2.util.URLProcessor;

public class SecondPanel
extends WizardPanel {
    private JComboBox cmbCodeGenOption;
    private JComboBox cmbLan;
    private JComboBox cmbServiceName;
    private JComboBox cmbPortName;
    private JTextField txtPacakgeName;
    private JComboBox cmbdbtype;
    private JCheckBox chkTestCase;
    private JRadioButton clientSide;
    private JRadioButton rdBoth;
    private JRadioButton rdsyn;
    private JRadioButton rdasync;
    private JRadioButton serverSide;
    private JCheckBox serviceXML;
    private JCheckBox serverSideInterface;
    private JRadioButton all;
    private JTable table;
    private JScrollPane spTable;
    private List serviceNameList;
    private PackageNameTableModel model;
    private CodegenBean codegenBean;

    public SecondPanel(WizardComponents wizardComponents, CodegenBean codegenBean) {
        super(wizardComponents, "Axis2 Idea Plugin WSDL2Java Wizards");
        this.codegenBean = codegenBean;
        this.setPanelTopTitle("Options");
        this.setPanelBottomTitle("Set the options for the code generator. If you wish to edit the codegen options, Select custom");
        this.init();
    }

    private void init() {
        this.cmbLan = new JComboBox();
        this.cmbLan.addItem("java");
        this.cmbLan.setToolTipText("Select the language of the generated code");
        this.cmbServiceName = new JComboBox();
        this.add(this.cmbServiceName);
        this.cmbServiceName.setToolTipText("Select the name of the service that the code should be generated for");
        this.cmbPortName = new JComboBox();
        this.cmbPortName.setToolTipText("Select the port name that the code should be generated for");
        this.txtPacakgeName = new JTextField("org.axis2");
        this.txtPacakgeName.setToolTipText("Set the package name of the generated code");
        this.cmbdbtype = new JComboBox();
        this.cmbdbtype.addItem("adb");
        this.cmbdbtype.addItem("xmlbeans");
        this.cmbdbtype.addItem("none");
        this.cmbdbtype.setToolTipText("Select the databinding framework to be used in the generation process");
        this.chkTestCase = new JCheckBox("Generate Test Case", false);
        this.chkTestCase.setVisible(true);
        this.chkTestCase.setToolTipText("A test case will be generated if this is checked");
        ButtonGroup generationType = new ButtonGroup();
        this.clientSide = new JRadioButton("Generate Client Side", true);
        generationType.add(this.clientSide);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rdBoth = new JRadioButton("Generate both sync and async", true);
        buttonGroup.add(this.rdBoth);
        this.rdsyn = new JRadioButton("Generate sync only", false);
        buttonGroup.add(this.rdsyn);
        this.rdasync = new JRadioButton("Generate async only", false);
        buttonGroup.add(this.rdasync);
        this.serverSide = new JRadioButton("Generate Server Side");
        generationType.add(this.serverSide);
        this.serviceXML = new JCheckBox("Generate default service.xml", false);
        this.serverSideInterface = new JCheckBox("Generate an interface for skeleton", false);
        this.all = new JRadioButton("Generate All");
        generationType.add(this.all);
        this.model = new PackageNameTableModel(new Object[1][2]);
        this.table = new JTable(this.model);
        this.spTable = new JScrollPane(this.table);
        this.cmbCodeGenOption = new JComboBox();
        this.cmbCodeGenOption.addItem("default");
        this.cmbCodeGenOption.addItem("custom");
        this.cmbCodeGenOption.setToolTipText("Select the Codegen option");
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Cogen Option"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)this.cmbCodeGenOption, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 5, 0, 10), 0, 0));
        this.cmbCodeGenOption.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SecondPanel.this.setEnabledForCodegenType();
                    SecondPanel.this.update();
                }
            }
        });
        this.add((Component)new JLabel("Out put lang"), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)this.cmbLan, new GridBagConstraints(1, 1, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 5, 0, 10), 0, 0));
        this.add((Component)new JLabel("Service name"), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)this.cmbServiceName, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 5, 0, 10), 0, 0));
        this.add((Component)new JLabel("port Name"), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)this.cmbPortName, new GridBagConstraints(1, 3, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 5, 0, 10), 0, 0));
        this.add((Component)new JLabel("DataBinding"), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)this.cmbdbtype, new GridBagConstraints(1, 4, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 5, 0, 10), 0, 0));
        this.add((Component)new JLabel("Custom Packege"), new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)this.txtPacakgeName, new GridBagConstraints(1, 5, 0, 1, 1.0, 0.0, 17, 2, new Insets(1, 5, 0, 10), 0, 0));
        this.add((Component)this.chkTestCase, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 7, 0, 1, 0.0, 0.0, 17, 1, new Insets(1, 10, 1, 1), 0, 0));
        this.add((Component)this.clientSide, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 10, 0, 10), 0, 0));
        this.clientSide.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SecondPanel.this.setEnabledForCustom();
                    SecondPanel.this.update();
                }
            }
        });
        this.add((Component)this.rdBoth, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)this.rdsyn, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 5, 0, 10), 0, 0));
        this.add((Component)this.rdasync, new GridBagConstraints(2, 9, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 5, 0, 10), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 10, 0, 1, 0.0, 0.0, 17, 1, new Insets(1, 10, 1, 1), 0, 0));
        this.add((Component)this.serverSide, new GridBagConstraints(0, 11, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 10, 0, 10), 0, 0));
        this.serverSide.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SecondPanel.this.setEnabledForCustom();
                    SecondPanel.this.update();
                }
            }
        });
        this.add((Component)this.serviceXML, new GridBagConstraints(0, 12, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)this.serverSideInterface, new GridBagConstraints(1, 12, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 5, 0, 10), 0, 0));
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 13, 0, 1, 0.0, 0.0, 17, 1, new Insets(1, 10, 1, 1), 0, 0));
        this.add((Component)this.all, new GridBagConstraints(0, 14, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 10, 0, 10), 0, 0));
        this.all.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SecondPanel.this.setEnabledForCustom();
                    SecondPanel.this.update();
                }
            }
        });
        this.add((Component)new JSeparator(), new GridBagConstraints(0, 15, 0, 1, 0.0, 0.0, 17, 1, new Insets(1, 10, 1, 1), 0, 0));
        this.add((Component)new JLabel("Namespace to Package Mapping"), new GridBagConstraints(0, 16, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 10, 0, 10), 0, 0));
        this.add((Component)this.spTable, new GridBagConstraints(0, 17, 0, 1, 1.0, 1.0, 18, 1, new Insets(1, 10, 20, 10), 0, 0));
        this.setNextButtonEnabled(false);
        this.setEnabledForCodegenType();
    }

    public void next() {
        this.switchPanel(5);
    }

    public void back() {
        this.switchPanel(1);
    }

    public void update() {
        this.checkPageComlete();
        this.populateParamsFromWSDL();
    }

    private void loadNamespaces(Collection namespaceMap) {
        Iterator namespaces = namespaceMap.iterator();
        Object[][] tableData = new Object[namespaceMap.size()][2];
        int i = 0;
        while (namespaces.hasNext()) {
            String namespace = (String)namespaces.next();
            tableData[i][0] = namespace;
            tableData[i][1] = this.getPackageFromNamespace(namespace);
            ++i;
        }
        this.model.setTableData(tableData);
    }

    private void setEnabledForCodegenType() {
        if (this.cmbCodeGenOption.getSelectedItem().equals("default")) {
            this.cmbdbtype.setEnabled(false);
            this.cmbLan.setEnabled(false);
            this.cmbPortName.setEnabled(false);
            this.cmbServiceName.setEnabled(false);
            this.txtPacakgeName.setEnabled(false);
            this.cmbdbtype.setEnabled(false);
            if (this.chkTestCase.isSelected()) {
                this.chkTestCase.setEnabled(false);
                this.chkTestCase.setSelected(false);
            } else {
                this.chkTestCase.setEnabled(false);
            }
            this.clientSide.setEnabled(false);
            this.rdBoth.setEnabled(false);
            this.rdsyn.setEnabled(false);
            this.rdasync.setEnabled(false);
            this.serverSide.setEnabled(false);
            this.table.setEnabled(false);
            this.spTable.setEnabled(false);
            this.serviceXML.setEnabled(false);
            this.serverSideInterface.setEnabled(false);
            this.all.setEnabled(false);
        } else {
            this.cmbdbtype.setEnabled(true);
            this.cmbLan.setEnabled(true);
            this.cmbPortName.setEnabled(true);
            this.cmbServiceName.setEnabled(true);
            this.txtPacakgeName.setEnabled(true);
            this.cmbdbtype.setEnabled(true);
            if (!this.clientSide.isSelected()) {
                this.clientSide.setEnabled(true);
                this.clientSide.setSelected(true);
            } else {
                this.clientSide.setEnabled(true);
            }
            this.serverSide.setEnabled(true);
            this.table.setEnabled(true);
            this.spTable.setEnabled(true);
            this.all.setEnabled(true);
            this.setEnabledForCustom();
        }
    }

    private void setEnabledForCustom() {
        if (this.clientSide.isSelected()) {
            if (this.serviceXML.isSelected() || this.serverSideInterface.isSelected()) {
                this.serverSide.setSelected(false);
                this.serverSideInterface.setSelected(false);
                this.serviceXML.setEnabled(false);
                this.serverSideInterface.setEnabled(false);
            } else {
                this.serviceXML.setEnabled(false);
                this.serverSideInterface.setEnabled(false);
            }
            if (this.rdasync.isSelected()) {
                this.rdasync.setEnabled(true);
                this.rdasync.setSelected(false);
            } else {
                this.rdasync.setEnabled(true);
            }
            if (!this.rdBoth.isSelected()) {
                this.rdBoth.setEnabled(true);
                this.rdBoth.setSelected(true);
            } else {
                this.rdBoth.setEnabled(true);
            }
            if (this.rdsyn.isSelected()) {
                this.rdsyn.setEnabled(true);
                this.rdsyn.setSelected(false);
            } else {
                this.rdsyn.setEnabled(true);
            }
            this.chkTestCase.setEnabled(true);
        } else if (this.serverSide.isSelected()) {
            if (this.serviceXML.isSelected() || this.serverSideInterface.isSelected()) {
                this.serverSide.setSelected(false);
                this.serverSideInterface.setSelected(false);
                this.serviceXML.setEnabled(true);
                this.serverSideInterface.setEnabled(true);
            } else {
                this.serviceXML.setEnabled(true);
                this.serverSideInterface.setEnabled(true);
            }
            if (this.rdasync.isSelected() || this.rdBoth.isSelected() || this.rdsyn.isSelected()) {
                this.rdasync.setSelected(false);
                this.rdBoth.setSelected(false);
                this.rdsyn.setSelected(false);
                this.rdasync.setEnabled(false);
                this.rdBoth.setEnabled(false);
                this.rdsyn.setEnabled(false);
            } else {
                this.rdasync.setEnabled(false);
                this.rdBoth.setEnabled(false);
                this.rdsyn.setEnabled(false);
            }
            if (this.chkTestCase.isSelected()) {
                this.chkTestCase.setEnabled(false);
                this.chkTestCase.setSelected(false);
            } else {
                this.chkTestCase.setEnabled(false);
            }
        } else if (this.all.isSelected()) {
            this.chkTestCase.setEnabled(true);
            if (this.serviceXML.isSelected() || this.serverSideInterface.isSelected()) {
                this.serverSide.setSelected(false);
                this.serverSideInterface.setSelected(false);
                this.serviceXML.setEnabled(false);
                this.serverSideInterface.setEnabled(false);
            } else {
                this.serviceXML.setEnabled(false);
                this.serverSideInterface.setEnabled(false);
            }
            if (this.rdasync.isSelected() || this.rdBoth.isSelected() || this.rdsyn.isSelected()) {
                this.rdasync.setSelected(false);
                this.rdBoth.setSelected(false);
                this.rdsyn.setSelected(false);
                this.rdasync.setEnabled(false);
                this.rdBoth.setEnabled(false);
                this.rdsyn.setEnabled(false);
            } else {
                this.rdasync.setEnabled(false);
                this.rdBoth.setEnabled(false);
                this.rdsyn.setEnabled(false);
            }
        }
    }

    public String getPackageFromNamespace(String namespace) {
        return URLProcessor.makePackageName((String)namespace);
    }

    public int getPageType() {
        return 1;
    }

    private void checkPageComlete() {
        if (this.cmbCodeGenOption.getSelectedItem().equals("default")) {
            this.setPageComplete(true);
            this.setNextButtonEnabled(true);
        } else if (this.txtPacakgeName.getText().equals("")) {
            this.setPageComplete(false);
            this.setNextButtonEnabled(false);
        } else {
            this.setPageComplete(true);
            this.setNextButtonEnabled(true);
        }
    }

    public void populateParamsFromWSDL() {
        try {
            String lname = this.codegenBean.getWSDLFileName();
            if (!"".equals(lname.trim())) {
                this.codegenBean.readWSDL();
                this.serviceNameList = this.codegenBean.getServiceList();
                if (!this.serviceNameList.isEmpty()) {
                    this.cmbServiceName.removeAll();
                    for (int i = 0; i < this.serviceNameList.size(); ++i) {
                        this.cmbServiceName.addItem(((QName)this.serviceNameList.get(i)).getLocalPart());
                    }
                    this.cmbServiceName.setSelectedIndex(0);
                    this.loadPortNames();
                } else {
                    if (this.cmbServiceName != null) {
                        this.cmbServiceName.removeAll();
                    }
                    if (this.cmbPortName != null) {
                        this.cmbPortName.removeAll();
                    }
                }
                this.populatePackageName();
                this.loadNamespaces(this.codegenBean.getDefinitionNamespaceMap());
            }
        }
        catch (WSDLException e) {
            this.setComboBoxEnable(false);
        }
        catch (Exception e) {
            this.setComboBoxEnable(false);
        }
    }

    private void populatePackageName() {
        this.txtPacakgeName.setText(this.codegenBean.packageFromTargetNamespace());
    }

    private void setComboBoxEnable(boolean b) {
        if (this.cmbServiceName != null) {
            this.cmbServiceName.setEnabled(b);
            this.cmbPortName.setEnabled(b);
        }
    }

    private void loadPortNames() {
        List ports;
        int selectionIndex = this.cmbServiceName.getSelectedIndex();
        if (selectionIndex != -1 && !(ports = this.codegenBean.getPortNameList((QName)this.serviceNameList.get(selectionIndex))).isEmpty()) {
            this.cmbPortName.removeAll();
            for (int i = 0; i < ports.size(); ++i) {
                this.cmbPortName.addItem(ports.get(i).toString());
            }
            this.cmbPortName.setSelectedIndex(0);
        }
    }

    public void populateOptions() {
        this.populateParamsFromWSDL();
    }

    private void dialogChanged() {
        String fileName = this.getPackageName();
        if (fileName.length() == 0) {
            this.setError("File name should be specified", true);
            this.setPageComplete(false);
            return;
        }
        this.setPageComplete(true);
    }

    public String getSelectedLanguage() {
        return this.cmbLan.getSelectedItem().toString();
    }

    public boolean isAsyncOnlyOn() {
        return this.rdasync.isSelected();
    }

    public boolean isSyncOnlyOn() {
        return this.rdsyn.isSelected();
    }

    public String getPackageName() {
        if ("".equals(this.txtPacakgeName.getText().trim())) {
            return "org.apache.axis2";
        }
        return this.txtPacakgeName.getText();
    }

    public boolean isServerside() {
        return this.serverSide.isSelected();
    }

    public boolean isServerXML() {
        if (this.serviceXML.isEnabled()) {
            return this.serviceXML.isSelected();
        }
        return false;
    }

    public boolean isGenerateTestCase() {
        return this.chkTestCase.isSelected();
    }

    public String getPortName() {
        int selectionIndex = this.cmbPortName.getSelectedIndex();
        if (selectionIndex != -1) {
            String text = this.cmbPortName.getSelectedItem().toString();
            if (text == null || text.trim().equals("")) {
                return null;
            }
            return text;
        }
        return null;
    }

    public String getServiceName() {
        int selectionIndex = this.cmbServiceName.getSelectedIndex();
        if (selectionIndex != -1) {
            String text = this.cmbServiceName.getSelectedItem().toString();
            if (text == null || text.trim().equals("")) {
                return null;
            }
            return text;
        }
        return null;
    }

    public String getDatabinderName() {
        return this.cmbdbtype.getSelectedItem().toString();
    }

    public boolean getGenerateServerSideInterface() {
        return this.serverSideInterface.isSelected();
    }

    public boolean getGenerateAll() {
        return this.all.isSelected();
    }

    public String getNs2PkgMapping() {
        String returnList = "";
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            String packageValue = this.table.getValueAt(i, 1).toString();
            if (packageValue == null || "".equals(packageValue)) continue;
            returnList = returnList + ("".equals(returnList) ? "" : ",") + this.table.getValueAt(i, 0).toString() + "=" + packageValue;
        }
        return "".equals(returnList) ? null : returnList;
    }

    private void handleCustomPackageNameModifyEvent() {
        String text = this.txtPacakgeName.getText();
        if (text == null || text.trim().equals("") || text.endsWith(".") || text.startsWith(".")) {
            return;
        }
    }
}

