/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ideaplugin.frames;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.axis2.tools.component.WizardComponents;
import org.apache.axis2.tools.component.WizardPanel;
import org.apache.ideaplugin.bean.ArchiveBean;
import org.apache.ideaplugin.bean.ParameterObj;
import org.apache.ideaplugin.bean.ValidateXMLFile;
import org.apache.ideaplugin.frames.ParameterDialog;

public class ServiceXMLEditPage
extends WizardPanel {
    protected JTextArea desArea;
    protected JButton addpara;
    protected JButton addModuleRef;
    protected JButton validateXML;
    private JButton reGenerate;
    protected JScrollPane sp;
    private JLabel lblerror;
    private ArchiveBean archiveBean;

    public ServiceXMLEditPage(WizardComponents wizardComponents, ArchiveBean archiveBean) {
        super(wizardComponents, "Axis2 Idea Plugin Service Archiver Creator Wizards");
        this.setPanelTopTitle("Service Archiver");
        this.setPanelBottomTitle("Edit the generated service.xml");
        this.archiveBean = archiveBean;
        this.init();
    }

    public void init() {
        ParameterDialog.initialize(this.addpara, "Parameter Dialog");
        this.addpara = new JButton("+Parameter ");
        this.addpara.setEnabled(false);
        this.addModuleRef = new JButton("+ModuleRef ");
        this.addModuleRef.setEnabled(false);
        this.validateXML = new JButton("Validate XML");
        this.reGenerate = new JButton("ReGenerate XML");
        this.lblerror = new JLabel();
        this.desArea = new JTextArea("");
        this.sp = new JScrollPane(this.desArea);
        this.sp.setAutoscrolls(true);
        this.setLayout(new GridBagLayout());
        this.setDefaultEnabled();
        this.add((Component)this.addpara, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 1, 0, 10), 0, 0));
        this.addpara.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParameterObj selectedName = ParameterDialog.showDialog("Parameter Dialog");
                ServiceXMLEditPage.this.setParameter(selectedName);
                ServiceXMLEditPage.this.setEnabledToNotValidate();
                ServiceXMLEditPage.this.update();
            }
        });
        this.add((Component)this.addModuleRef, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 1, 10), 0, 0));
        this.addModuleRef.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String moduleName = JOptionPane.showInputDialog(ServiceXMLEditPage.this.addModuleRef, "Module Name", "Module Dialog", -1);
                ServiceXMLEditPage.this.setModule(moduleName);
                ServiceXMLEditPage.this.setEnabledToNotValidate();
                ServiceXMLEditPage.this.update();
            }
        });
        this.add((Component)this.validateXML, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 1, 10), 0, 0));
        this.validateXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (new ValidateXMLFile().Validate("<?xml version=\"1.0\"?>\n" + ServiceXMLEditPage.this.desArea.getText())) {
                    ServiceXMLEditPage.this.setEnabledToValidate();
                    ServiceXMLEditPage.this.lblerror.setText("Service XML file validation successfully");
                } else {
                    ServiceXMLEditPage.this.setEnabledToNotValidate();
                    ServiceXMLEditPage.this.lblerror.setText("Error! Service XML file validation Error");
                }
                ServiceXMLEditPage.this.update();
            }
        });
        this.add((Component)this.reGenerate, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 10, 1, 10), 0, 0));
        this.reGenerate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ServiceXMLEditPage.this.desArea.setText("");
                ServiceXMLEditPage.this.desArea.setText(ServiceXMLEditPage.this.archiveBean.getServiceXML());
                ServiceXMLEditPage.this.update();
            }
        });
        this.add((Component)this.sp, new GridBagConstraints(0, 1, 0, 1, 1.0, 1.0, 17, 1, new Insets(5, 10, 10, 10), 0, 0));
        this.desArea.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                ServiceXMLEditPage.this.addpara.setEnabled(true);
                ServiceXMLEditPage.this.addModuleRef.setEnabled(true);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        this.add((Component)this.lblerror, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 17, 0, new Insets(5, 20, 10, 10), 0, 0));
    }

    public void next() {
        if (!this.archiveBean.getServiceXML().equals("")) {
            this.archiveBean.setServiceXML(this.desArea.getText());
        }
        this.switchPanel(13);
    }

    public void back() {
        this.switchPanel(11);
    }

    public void update() {
    }

    public int getPageType() {
        return 3;
    }

    public void setDescription(String descrip) {
        this.desArea.setText(descrip);
        this.update();
    }

    private void setEnabledToValidate() {
        this.setNextButtonEnabled(true);
        this.reGenerate.setEnabled(false);
        this.addpara.setEnabled(false);
        this.addModuleRef.setEnabled(false);
        this.setPageComplete(true);
    }

    private void setEnabledToNotValidate() {
        this.reGenerate.setEnabled(true);
        this.setNextButtonEnabled(false);
        this.setPageComplete(false);
        this.addpara.setEnabled(false);
        this.addModuleRef.setEnabled(false);
    }

    public void setDefaultEnabled() {
        this.lblerror.setText("");
        this.addpara.setEnabled(false);
        this.addModuleRef.setEnabled(false);
        this.validateXML.setEnabled(true);
        this.reGenerate.setEnabled(false);
        this.setNextButtonEnabled(false);
    }

    private void setParameter(ParameterObj obj) {
        int position = this.desArea.getCaretPosition();
        System.out.println(this.desArea.getLineCount());
        System.out.println(this.desArea.getCaretPosition());
        String str = "      <parameter name=\"" + obj.getName() + "\" locked=\"false\">" + obj.getValue() + "</parameter>\n";
        this.desArea.insert(str, position + 1);
    }

    private void setModule(String module) {
        int position = this.desArea.getCaretPosition();
        String str = "      <module ref=\"" + module + "\" />\n";
        this.desArea.insert(str, position + 1);
    }
}

