/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.File;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.management.NodeManager;
import org.apache.axis2.clustering.state.StateManager;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.ContextListener;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DependencyManager;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.axis2.util.threadpool.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationContext
extends AbstractContext {
    private static final Log log = LogFactory.getLog(ConfigurationContext.class);
    private final ConcurrentHashMap operationContextMap = new ConcurrentHashMap();
    private Hashtable serviceGroupContextMap = new Hashtable();
    private Hashtable applicationSessionServiceGroupContexts = new Hashtable();
    private AxisConfiguration axisConfiguration;
    private ThreadFactory threadPool;
    private ListenerManager listenerManager;
    private long serviceGroupContextTimoutInterval = 30000L;
    private String contextRoot;
    private String servicePath;
    private String cachedServicePath = null;
    protected List contextListeners;

    public ConfigurationContext(AxisConfiguration axisConfiguration) {
        super(null);
        this.axisConfiguration = axisConfiguration;
        this.initConfigContextTimeout(axisConfiguration);
    }

    private void initConfigContextTimeout(AxisConfiguration axisConfiguration) {
        Object value;
        Parameter parameter = axisConfiguration.getParameter("ConfigContextTimeoutInterval");
        if (parameter != null && (value = parameter.getValue()) != null && value instanceof String) {
            this.serviceGroupContextTimoutInterval = Integer.parseInt((String)value);
        }
    }

    public void initCluster() throws AxisFault {
        ClusteringAgent clusteringAgent = this.axisConfiguration.getClusteringAgent();
        if (clusteringAgent != null) {
            NodeManager configManager;
            StateManager stateManager = clusteringAgent.getStateManager();
            if (stateManager != null) {
                stateManager.setConfigurationContext(this);
            }
            if ((configManager = clusteringAgent.getNodeManager()) != null) {
                configManager.setConfigurationContext(this);
            }
            if (ConfigurationContext.shouldClusterBeInitiated(clusteringAgent)) {
                clusteringAgent.setConfigurationContext(this);
                clusteringAgent.init();
            }
        }
    }

    private static boolean shouldClusterBeInitiated(ClusteringAgent clusteringAgent) {
        Parameter param = clusteringAgent.getParameter("AvoidInitiation");
        return param == null || !JavaUtils.isTrueExplicitly(param.getValue());
    }

    void contextCreated(AbstractContext context) {
        if (this.contextListeners == null) {
            return;
        }
        for (ContextListener listener : this.contextListeners) {
            listener.contextCreated(context);
        }
    }

    void contextRemoved(AbstractContext context) {
        if (this.contextListeners == null) {
            return;
        }
        for (ContextListener listener : this.contextListeners) {
            listener.contextRemoved(context);
        }
    }

    public void addContextListener(ContextListener contextListener) {
        if (this.contextListeners == null) {
            this.contextListeners = new ArrayList();
        }
        this.contextListeners.add(contextListener);
    }

    public void removeContextListener(ContextListener contextListener) {
        if (this.contextListeners != null) {
            this.contextListeners.remove(contextListener);
        }
    }

    public void fillServiceContextAndServiceGroupContext(MessageContext messageContext) throws AxisFault {
        ServiceContext serviceContext = messageContext.getServiceContext();
        AxisService axisService = messageContext.getAxisService();
        if (serviceContext == null) {
            String scope = axisService.getScope();
            if ("application".equals(scope)) {
                String serviceGroupName = axisService.getAxisServiceGroup().getServiceGroupName();
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.applicationSessionServiceGroupContexts.get(serviceGroupName);
                if (serviceGroupContext == null) {
                    AxisServiceGroup axisServiceGroup = messageContext.getAxisServiceGroup();
                    if (axisServiceGroup == null) {
                        axisServiceGroup = axisService.getAxisServiceGroup();
                        messageContext.setAxisServiceGroup(axisServiceGroup);
                    }
                    ConfigurationContext cfgCtx = messageContext.getConfigurationContext();
                    serviceGroupContext = cfgCtx.createServiceGroupContext(axisServiceGroup);
                    this.applicationSessionServiceGroupContexts.put(serviceGroupName, serviceGroupContext);
                }
                messageContext.setServiceGroupContext(serviceGroupContext);
                messageContext.setServiceContext(serviceGroupContext.getServiceContext(axisService));
            } else if ("soapsession".equals(scope)) {
                ServiceGroupContext serviceGroupContext;
                this.cleanupServiceGroupContexts();
                String serviceGroupContextId = messageContext.getServiceGroupContextId();
                if (serviceGroupContextId != null) {
                    serviceGroupContext = this.getServiceGroupContextFromSoapSessionTable(serviceGroupContextId, messageContext);
                    if (serviceGroupContext == null) {
                        serviceGroupContext = new ServiceGroupContext(this, axisService.getAxisServiceGroup());
                        serviceGroupContext.setId(serviceGroupContextId);
                        this.addServiceGroupContextIntoSoapSessionTable(serviceGroupContext);
                    }
                } else {
                    AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
                    serviceGroupContext = this.createServiceGroupContext(axisServiceGroup);
                    serviceContext = serviceGroupContext.getServiceContext(axisService);
                    serviceGroupContextId = UUIDGenerator.getUUID();
                    serviceGroupContext.setId(serviceGroupContextId);
                    messageContext.setServiceGroupContextId(serviceGroupContextId);
                    this.addServiceGroupContextIntoSoapSessionTable(serviceGroupContext);
                }
                messageContext.setServiceGroupContext(serviceGroupContext);
                messageContext.setServiceContext(serviceGroupContext.getServiceContext(axisService));
            } else if ("request".equals(scope)) {
                AxisServiceGroup axisServiceGroup = axisService.getAxisServiceGroup();
                ServiceGroupContext serviceGroupContext = this.createServiceGroupContext(axisServiceGroup);
                messageContext.setServiceGroupContext(serviceGroupContext);
                serviceContext = serviceGroupContext.getServiceContext(axisService);
                messageContext.setServiceContext(serviceContext);
            }
        }
        if (messageContext.getOperationContext() != null) {
            messageContext.getOperationContext().setParent(serviceContext);
        }
    }

    public boolean registerOperationContext(String messageID, OperationContext mepContext) {
        return this.registerOperationContext(messageID, mepContext, false);
    }

    public boolean registerOperationContext(String messageID, OperationContext mepContext, boolean override) {
        if (messageID == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"messageID is null. Returning false");
            }
            return false;
        }
        boolean alreadyInMap = false;
        mepContext.setKey(messageID);
        if (override) {
            this.operationContextMap.put((Object)messageID, (Object)mepContext);
        } else {
            Object previous = this.operationContextMap.putIfAbsent((Object)messageID, (Object)mepContext);
            boolean bl = alreadyInMap = previous != null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("registerOperationContext (" + override + "): " + mepContext + " with key: " + messageID));
            HashMap msgContextMap = mepContext.getMessageContexts();
            for (MessageContext msgContext : msgContextMap.values()) {
                log.debug((Object)("msgContext: " + msgContext + " action: " + msgContext.getWSAAction()));
            }
        }
        return !alreadyInMap || override;
    }

    public void unregisterOperationContext(String key) {
        if (key == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"key is null.");
            }
        } else {
            OperationContext opCtx = (OperationContext)this.operationContextMap.remove((Object)key);
            this.contextRemoved(opCtx);
        }
    }

    public boolean isAnyOperationContextRegistered() {
        return !this.operationContextMap.isEmpty();
    }

    public void addServiceGroupContextIntoSoapSessionTable(ServiceGroupContext serviceGroupContext) {
        String id = serviceGroupContext.getId();
        this.serviceGroupContextMap.put(id, serviceGroupContext);
        serviceGroupContext.touch();
        serviceGroupContext.setParent(this);
        this.cleanupServiceGroupContexts();
    }

    public void addServiceGroupContextIntoApplicationScopeTable(ServiceGroupContext serviceGroupContext) {
        if (this.applicationSessionServiceGroupContexts == null) {
            this.applicationSessionServiceGroupContexts = new Hashtable();
        }
        this.applicationSessionServiceGroupContexts.put(serviceGroupContext.getDescription().getServiceGroupName(), serviceGroupContext);
    }

    public void deployService(AxisService service) throws AxisFault {
        this.axisConfiguration.addService(service);
        if ("application".equals(service.getScope())) {
            ServiceGroupContext sgc = this.createServiceGroupContext(service.getAxisServiceGroup());
            DependencyManager.initService(sgc);
        }
    }

    public AxisConfiguration getAxisConfiguration() {
        return this.axisConfiguration;
    }

    public OperationContext getOperationContext(String id) {
        OperationContext opCtx = (OperationContext)this.operationContextMap.get((Object)id);
        return opCtx;
    }

    public OperationContext findOperationContext(String operationName, String serviceName, String serviceGroupName) {
        if (operationName == null) {
            return null;
        }
        if (serviceName == null) {
            return null;
        }
        for (OperationContext value : this.operationContextMap.values()) {
            if (value == null) continue;
            String valueOperationName = value.getOperationName();
            String valueServiceName = value.getServiceName();
            String valueServiceGroupName = value.getServiceGroupName();
            if (valueOperationName == null || !valueOperationName.equals(operationName) || valueServiceName == null || !valueServiceName.equals(serviceName)) continue;
            if (valueServiceGroupName != null && serviceGroupName != null && valueServiceGroupName.equals(serviceGroupName)) {
                return value;
            }
            if (valueServiceGroupName != null || serviceGroupName != null) continue;
            return value;
        }
        return null;
    }

    public MessageContext createMessageContext() {
        MessageContext msgCtx = new MessageContext(this);
        this.contextCreated(msgCtx);
        return msgCtx;
    }

    public ServiceGroupContext createServiceGroupContext(AxisServiceGroup serviceGroup) {
        ServiceGroupContext sgCtx = new ServiceGroupContext(this, serviceGroup);
        this.contextCreated(sgCtx);
        return sgCtx;
    }

    public File getRealPath(String path) {
        URL repository = this.axisConfiguration.getRepository();
        if (repository != null) {
            File repo = new File(repository.getFile());
            return new File(repo, path);
        }
        return null;
    }

    public ServiceGroupContext getServiceGroupContextFromSoapSessionTable(String serviceGroupContextId, MessageContext msgContext) throws AxisFault {
        ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupContextId);
        if (serviceGroupContext != null) {
            serviceGroupContext.touch();
            return serviceGroupContext;
        }
        throw new AxisFault("Unable to find corresponding context for the serviceGroupId: " + serviceGroupContextId);
    }

    public ServiceGroupContext getServiceGroupContext(String serviceGroupCtxId) {
        if (serviceGroupCtxId == null) {
            return null;
        }
        ServiceGroupContext serviceGroupContext = null;
        if (this.serviceGroupContextMap != null) {
            serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupCtxId);
            if (serviceGroupContext != null) {
                serviceGroupContext.touch();
            } else {
                serviceGroupContext = (ServiceGroupContext)this.applicationSessionServiceGroupContexts.get(serviceGroupCtxId);
                if (serviceGroupContext != null) {
                    serviceGroupContext.touch();
                }
            }
        }
        return serviceGroupContext;
    }

    public String[] getServiceGroupContextIDs() {
        String[] ids = new String[this.serviceGroupContextMap.size() + this.applicationSessionServiceGroupContexts.size()];
        int index = 0;
        Iterator iter = this.serviceGroupContextMap.keySet().iterator();
        while (iter.hasNext()) {
            ids[index] = (String)iter.next();
            ++index;
        }
        iter = this.applicationSessionServiceGroupContexts.keySet().iterator();
        while (iter.hasNext()) {
            ids[index] = (String)iter.next();
            ++index;
        }
        return ids;
    }

    public Hashtable getServiceGroupContexts() {
        return this.serviceGroupContextMap;
    }

    public ThreadFactory getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = new ThreadPool();
        }
        return this.threadPool;
    }

    public void setAxisConfiguration(AxisConfiguration configuration) {
        this.axisConfiguration = configuration;
    }

    public void setThreadPool(ThreadFactory pool) throws AxisFault {
        if (this.threadPool != null) {
            throw new AxisFault(Messages.getMessage("threadpoolset"));
        }
        this.threadPool = pool;
    }

    public void removeServiceGroupContext(String serviceGroupContextId) {
        if (this.serviceGroupContextMap == null) {
            return;
        }
        ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(serviceGroupContextId);
        this.serviceGroupContextMap.remove(serviceGroupContextId);
        this.cleanupServiceContexts(serviceGroupContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupServiceGroupContexts() {
        if (this.serviceGroupContextMap == null) {
            return;
        }
        long currentTime = new Date().getTime();
        Hashtable hashtable = this.serviceGroupContextMap;
        synchronized (hashtable) {
            Iterator sgCtxtMapKeyIter = this.serviceGroupContextMap.keySet().iterator();
            while (sgCtxtMapKeyIter.hasNext()) {
                String sgCtxtId = (String)sgCtxtMapKeyIter.next();
                ServiceGroupContext serviceGroupContext = (ServiceGroupContext)this.serviceGroupContextMap.get(sgCtxtId);
                if (currentTime - serviceGroupContext.getLastTouchedTime() <= this.getServiceGroupContextTimoutInterval()) continue;
                sgCtxtMapKeyIter.remove();
                this.cleanupServiceContexts(serviceGroupContext);
                this.contextRemoved(serviceGroupContext);
            }
        }
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void setTransportManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    private void cleanupServiceContexts(ServiceGroupContext serviceGroupContext) {
        if (serviceGroupContext == null) {
            return;
        }
        Iterator serviceContextIter = serviceGroupContext.getServiceContexts();
        if (serviceContextIter == null) {
            return;
        }
        while (serviceContextIter.hasNext()) {
            ServiceContext serviceContext = (ServiceContext)serviceContextIter.next();
            DependencyManager.destroyServiceObject(serviceContext);
        }
    }

    public void cleanupContexts() {
        if (this.applicationSessionServiceGroupContexts != null && this.applicationSessionServiceGroupContexts.size() > 0) {
            for (ServiceGroupContext serviceGroupContext : this.applicationSessionServiceGroupContexts.values()) {
                this.cleanupServiceContexts(serviceGroupContext);
            }
            this.applicationSessionServiceGroupContexts.clear();
        }
        if (this.serviceGroupContextMap != null && this.serviceGroupContextMap.size() > 0) {
            for (ServiceGroupContext serviceGroupContext : this.serviceGroupContextMap.values()) {
                this.cleanupServiceContexts(serviceGroupContext);
            }
            this.serviceGroupContextMap.clear();
        }
    }

    public void terminate() throws AxisFault {
        if (this.listenerManager != null) {
            this.listenerManager.stop();
        }
        this.axisConfiguration.cleanup();
        this.cleanupTemp();
    }

    private void cleanupTemp() {
        File tempFile = (File)this.axisConfiguration.getParameterValue("artifactsDIR");
        if (tempFile == null) {
            String property = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("java.io.tmpdir");
                }
            });
            tempFile = new File(property, "_axis2");
        }
        this.deleteTempFiles(tempFile);
    }

    private void deleteTempFiles(final File dir) {
        Boolean isDir = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(dir.isDirectory());
            }
        });
        if (isDir.booleanValue()) {
            String[] children = (String[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return dir.list();
                }
            });
            for (int i = 0; children != null && i < children.length; ++i) {
                this.deleteTempFiles(new File(dir, children[i]));
            }
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                dir.delete();
                return null;
            }
        });
    }

    public String getServiceContextPath() {
        if (this.cachedServicePath == null) {
            this.cachedServicePath = this.internalGetServiceContextPath();
        }
        return this.cachedServicePath;
    }

    private String internalGetServiceContextPath() {
        String ctxRoot = this.getContextRoot();
        String path = "/";
        if (ctxRoot != null) {
            if (!ctxRoot.equals("/")) {
                path = ctxRoot + "/";
            }
            if (this.servicePath == null || this.servicePath.trim().length() == 0) {
                throw new IllegalArgumentException("service path cannot be null or empty");
            }
            path = path + this.servicePath.trim();
        }
        return path;
    }

    public String getServicePath() {
        if (this.servicePath == null || this.servicePath.trim().length() == 0) {
            throw new IllegalArgumentException("service path cannot be null or empty");
        }
        return this.servicePath.trim();
    }

    public void setServicePath(String servicePath) {
        this.servicePath = servicePath;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        if (contextRoot != null) {
            this.contextRoot = contextRoot.trim();
            this.cachedServicePath = this.internalGetServiceContextPath();
        }
    }

    public long getServiceGroupContextTimoutInterval() {
        Integer serviceGroupContextTimoutIntervalParam = (Integer)this.getProperty("ConfigContextTimeoutInterval");
        if (serviceGroupContextTimoutIntervalParam != null) {
            this.serviceGroupContextTimoutInterval = serviceGroupContextTimoutIntervalParam.intValue();
        }
        return this.serviceGroupContextTimoutInterval;
    }

    public void removeServiceGroupContext(AxisServiceGroup serviceGroup) {
        if (serviceGroup != null) {
            Object obj = this.applicationSessionServiceGroupContexts.get(serviceGroup.getServiceGroupName());
            if (obj == null) {
                ArrayList<String> toBeRemovedList = new ArrayList<String>();
                for (ServiceGroupContext serviceGroupContext : this.serviceGroupContextMap.values()) {
                    if (!serviceGroupContext.getDescription().equals(serviceGroup)) continue;
                    toBeRemovedList.add(serviceGroupContext.getId());
                }
                for (int i = 0; i < toBeRemovedList.size(); ++i) {
                    String s = (String)toBeRemovedList.get(i);
                    this.serviceGroupContextMap.remove(s);
                }
            } else {
                this.applicationSessionServiceGroupContexts.remove(serviceGroup.getServiceGroupName());
            }
        }
    }

    public ConfigurationContext getRootContext() {
        return this;
    }
}

