/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dataretrieval;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.dataretrieval.BaseAxisDataLocator;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.dataretrieval.ServiceData;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;

public class SchemaDataLocator
extends BaseAxisDataLocator
implements AxisDataLocator {
    private String requestIdentifier = null;
    private String serviceEPR = null;
    private static final Log LOG = LogFactory.getLog((String)SchemaDataLocator.class.getClass().getName());

    protected SchemaDataLocator() {
    }

    protected SchemaDataLocator(ServiceData[] data) {
        this.dataList = data;
    }

    public Data[] getData(DataRetrievalRequest request, MessageContext msgContext) throws DataRetrievalException {
        this.requestIdentifier = request.getIdentifier();
        this.serviceEPR = msgContext.getTo().getAddress();
        OutputForm outputForm = request.getOutputForm();
        if (outputForm == null) {
            outputForm = OutputForm.INLINE_FORM;
        }
        Data[] data = outputForm == OutputForm.INLINE_FORM ? this.outputInlineForm(msgContext, this.dataList) : (outputForm == OutputForm.LOCATION_FORM ? this.outputLocationForm(this.dataList) : this.outputReferenceForm(msgContext, this.dataList));
        return data;
    }

    protected Data[] outputInlineForm(MessageContext msgContext, ServiceData[] serviceData) throws DataRetrievalException {
        Data[] data = super.outputInlineForm(msgContext, serviceData);
        if (data.length != 0) {
            return data;
        }
        AxisService axisService = msgContext.getAxisService();
        ArrayList schemaList = axisService.getSchema();
        ArrayList<Data> results = new ArrayList<Data>();
        for (XmlSchema schema : schemaList) {
            if (this.requestIdentifier != null) {
                if (!this.requestIdentifier.equals(schema.getTargetNamespace())) continue;
                results.add(new Data(this.convertToOM(schema), this.requestIdentifier));
                continue;
            }
            results.add(new Data(this.convertToOM(schema), null));
        }
        return results.toArray(new Data[results.size()]);
    }

    protected Data[] outputLocationForm(ServiceData[] serviceData) throws DataRetrievalException {
        Data[] data = super.outputLocationForm(serviceData);
        if (data != null && data.length != 0) {
            return data;
        }
        return new Data[]{new Data(this.serviceEPR + "?xsd", this.requestIdentifier)};
    }

    private OMNode convertToOM(XmlSchema schema) throws DataRetrievalException {
        StringWriter writer = new StringWriter();
        schema.write((Writer)writer);
        StringReader reader = new StringReader(writer.toString());
        try {
            return XMLUtils.toOM(reader);
        }
        catch (XMLStreamException e) {
            throw new DataRetrievalException("Can't convert XmlSchema object to an OMElement", e);
        }
    }
}

