/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.i18n.Messages;

public abstract class TwoChannelAxisOperation
extends AxisOperation {
    protected AxisMessage inFaultMessage;
    protected AxisMessage outFaultMessage;
    protected AxisMessage inMessage;
    protected AxisMessage outMessage;

    public TwoChannelAxisOperation() {
        QName tmpName = new QName(this.getClass().getName() + "_" + UUIDGenerator.getUUID());
        this.setName(tmpName);
        this.createMessages();
    }

    public TwoChannelAxisOperation(QName name) {
        super(name);
        this.createMessages();
    }

    private void createMessages() {
        this.inMessage = new AxisMessage();
        this.inMessage.setDirection("in");
        this.inMessage.setParent(this);
        this.addChild("inMessage", this.inMessage);
        this.inFaultMessage = new AxisMessage();
        this.inFaultMessage.setParent(this);
        this.outFaultMessage = new AxisMessage();
        this.outFaultMessage.setParent(this);
        this.outMessage = new AxisMessage();
        this.outMessage.setDirection("out");
        this.outMessage.setParent(this);
        this.addChild("outMessage", this.outMessage);
    }

    public void addMessage(AxisMessage message, String label) {
        if ("Out".equals(label)) {
            this.addChild("outMessage", message);
        } else if ("In".equals(label)) {
            this.addChild("inMessage", message);
        } else if ("Fault".equals(label)) {
            this.addChild("faultMessage", message);
        } else {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    public AxisMessage getMessage(String label) {
        if ("Out".equals(label)) {
            return (AxisMessage)this.getChild("outMessage");
        }
        if ("In".equals(label)) {
            return (AxisMessage)this.getChild("inMessage");
        }
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void addFaultMessageContext(MessageContext msgContext, OperationContext opContext) throws AxisFault {
        HashMap mep = opContext.getMessageContexts();
        MessageContext faultMessageCtxt = (MessageContext)mep.get("Fault");
        if (faultMessageCtxt != null) {
            throw new AxisFault(Messages.getMessage("mepcompleted"));
        }
        mep.put("Fault", msgContext);
        opContext.setComplete(true);
        opContext.cleanup();
    }

    public ArrayList getPhasesInFaultFlow() {
        return this.inFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFaultFlow() {
        return this.outFaultMessage.getMessageFlow();
    }

    public ArrayList getPhasesOutFlow() {
        return this.outMessage.getMessageFlow();
    }

    public ArrayList getRemainingPhasesInFlow() {
        return this.inMessage.getMessageFlow();
    }

    public void setPhasesInFaultFlow(ArrayList list) {
        this.inFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFaultFlow(ArrayList list) {
        this.outFaultMessage.setMessageFlow(list);
    }

    public void setPhasesOutFlow(ArrayList list) {
        this.outMessage.setMessageFlow(list);
    }

    public void setRemainingPhasesInFlow(ArrayList list) {
        this.inMessage.setMessageFlow(list);
    }
}

