/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description.java2wsdl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.deployment.util.BeanExcludeInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.java2wsdl.DefaultNamespaceGenerator;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.description.java2wsdl.Java2WSDLUtils;
import org.apache.axis2.description.java2wsdl.NamespaceGenerator;
import org.apache.axis2.description.java2wsdl.SchemaGenerator;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.description.java2wsdl.bytecode.MethodTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JComment;
import org.codehaus.jam.JField;
import org.codehaus.jam.JMethod;
import org.codehaus.jam.JPackage;
import org.codehaus.jam.JParameter;
import org.codehaus.jam.JProperty;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;
import org.w3c.dom.Document;

public class DefaultSchemaGenerator
implements Java2WSDLConstants,
SchemaGenerator {
    private static final Log log = LogFactory.getLog(DefaultSchemaGenerator.class);
    public static final String NAME_SPACE_PREFIX = "ax2";
    private static int prefixCount = 1;
    protected Map targetNamespacePrefixMap = new Hashtable();
    protected Map schemaMap = new Hashtable();
    protected XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
    protected ClassLoader classLoader;
    protected String className;
    protected TypeTable typeTable = new TypeTable();
    protected JMethod[] methods;
    protected MethodTable methodTable;
    protected String schemaTargetNameSpace;
    protected String schema_namespace_prefix;
    protected String attrFormDefault = null;
    protected String elementFormDefault = null;
    protected ArrayList excludeMethods = new ArrayList();
    protected ArrayList extraClasses = null;
    protected boolean useWSDLTypesNamespace = false;
    protected Map pkg2nsmap = null;
    protected NamespaceGenerator nsGen = null;
    protected String targetNamespace = null;
    protected ArrayList nonRpcMethods = new ArrayList();
    protected Class serviceClass = null;
    protected AxisService service;
    protected String customSchemaLocation;
    protected String mappingFileLocation;
    protected boolean generateBaseException;

    public NamespaceGenerator getNsGen() throws Exception {
        if (this.nsGen == null) {
            this.nsGen = new DefaultNamespaceGenerator();
        }
        return this.nsGen;
    }

    public void setNsGen(NamespaceGenerator nsGen) {
        this.nsGen = nsGen;
    }

    public DefaultSchemaGenerator(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix, AxisService service) throws Exception {
        this.classLoader = loader;
        this.className = className;
        this.service = service;
        this.serviceClass = Class.forName(className, true, loader);
        this.methodTable = new MethodTable(this.serviceClass);
        this.targetNamespace = Java2WSDLUtils.targetNamespaceFromClassName(className, loader, this.getNsGen()).toString();
        this.schemaTargetNameSpace = schematargetNamespace != null && schematargetNamespace.trim().length() != 0 ? schematargetNamespace : Java2WSDLUtils.schemaNamespaceFromClassName(className, loader, this.getNsGen()).toString();
        this.schema_namespace_prefix = schematargetNamespacePrefix != null && schematargetNamespacePrefix.trim().length() != 0 ? schematargetNamespacePrefix : "ns";
    }

    private void loadCustomSchemaFile() {
        if (this.customSchemaLocation != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                Document doc = documentBuilderFactory.newDocumentBuilder().parse(new File(this.customSchemaLocation));
                XmlSchema schema = this.xmlSchemaCollection.read(doc, null);
                this.schemaMap.put(schema.getTargetNamespace(), schema);
            }
            catch (Exception e) {
                log.info((Object)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadMappingFile() {
        block13: {
            if (this.mappingFileLocation != null) {
                String line;
                File file = new File(this.mappingFileLocation);
                BufferedReader input = null;
                input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                while ((line = input.readLine()) != null) {
                    String[] values;
                    if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#' || (values = line.split("\\|")) == null || values.length <= 2) continue;
                    this.typeTable.addComplexSchema(values[0], new QName(values[1], values[2]));
                }
                Object var6_6 = null;
                try {
                    if (input != null) {
                        input.close();
                    }
                    break block13;
                }
                catch (IOException ex2) {
                    ex2.printStackTrace();
                }
                break block13;
                {
                    catch (IOException ex) {
                        ex.printStackTrace();
                        Object var6_7 = null;
                        try {
                            if (input != null) {
                                input.close();
                            }
                            break block13;
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException ex2) {
                        ex2.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
    }

    public Collection generateSchema() throws Exception {
        this.loadCustomSchemaFile();
        this.loadMappingFile();
        JamServiceFactory factory = JamServiceFactory.getInstance();
        JamServiceParams jam_service_parms = factory.createServiceParams();
        jam_service_parms.addClassLoader(this.classLoader);
        jam_service_parms.includeClass(this.className);
        for (int count = 0; count < this.getExtraClasses().size(); ++count) {
            jam_service_parms.includeClass((String)this.getExtraClasses().get(count));
        }
        JamService jamService = factory.createService(jam_service_parms);
        JamClassIterator jClassIter = jamService.getClasses();
        while (jClassIter.hasNext()) {
            JClass jclass = (JClass)jClassIter.next();
            if (this.getActualQualifiedName(jclass).equals(this.className)) {
                JAnnotation annotation = jclass.getAnnotation("javax.jws.WebService");
                JComment comment = jclass.getComment();
                if (comment != null) {
                    System.out.println(comment.getText());
                }
                if (annotation != null) {
                    String tns = annotation.getValue("targetNamespace").asString();
                    if (tns != null && !"".equals(tns)) {
                        this.targetNamespace = tns;
                        this.schemaTargetNameSpace = tns;
                    }
                    this.service.setName(Utils.getAnnotatedServiceName(this.serviceClass, annotation));
                }
                this.methods = this.processMethods(jclass.getDeclaredMethods());
                continue;
            }
            QName extraSchemaTypeName = this.typeTable.getSimpleSchemaTypeName(this.getQualifiedName(jclass));
            if (extraSchemaTypeName != null) continue;
            this.generateSchema(jclass);
        }
        return this.schemaMap.values();
    }

    protected JMethod[] processMethods(JMethod[] declaredMethods) throws Exception {
        ArrayList<JMethod> list = new ArrayList<JMethod>();
        Arrays.sort(declaredMethods);
        HashMap<String, JMethod> uniqueMethods = new HashMap<String, JMethod>();
        XmlSchemaSequence sequence = null;
        for (int i = 0; i < declaredMethods.length; ++i) {
            JClass returnType;
            XmlSchemaComplexType methodSchemaType;
            String methodName;
            JMethod jMethod = declaredMethods[i];
            JAnnotation methodAnnon = jMethod.getAnnotation("javax.jws.WebMethod");
            if (methodAnnon != null && methodAnnon.getValue("exclude").asBoolean() || this.excludeMethods.contains(methodName = this.getSimpleName(jMethod))) continue;
            if (uniqueMethods.get(methodName) != null) {
                log.warn((Object)("We don't support method overloading. Ignoring [" + jMethod.getQualifiedName() + "]"));
                continue;
            }
            if (!jMethod.isPublic()) continue;
            boolean addToService = false;
            AxisOperation axisOperation = this.service.getOperation(new QName(methodName));
            if (axisOperation == null) {
                axisOperation = Utils.getAxisOperationForJmethod(jMethod);
                addToService = true;
            }
            list.add(jMethod);
            this.processException(jMethod, axisOperation);
            uniqueMethods.put(methodName, jMethod);
            JParameter[] paras = jMethod.getParameters();
            String[] parameterNames = null;
            AxisMessage inMessage = axisOperation.getMessage("In");
            if (inMessage != null) {
                inMessage.setName(methodName + "Request");
            }
            if (paras.length > 0) {
                parameterNames = this.methodTable.getParameterNames(methodName);
                this.service.addParameter(methodName, parameterNames);
                sequence = new XmlSchemaSequence();
                methodSchemaType = this.createSchemaTypeForMethodPart(methodName);
                methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                inMessage.setElementQName(this.typeTable.getQNamefortheType(methodName));
                this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
            }
            for (int j = 0; j < paras.length; ++j) {
                JParameter methodParameter = paras[j];
                String parameterName = null;
                JAnnotation paramterAnnon = methodParameter.getAnnotation("javax.jws.WebParam");
                if (paramterAnnon != null) {
                    parameterName = paramterAnnon.getValue("name").asString();
                }
                if (parameterName == null || "".equals(parameterName)) {
                    parameterName = parameterNames != null && parameterNames[j] != null ? parameterNames[j] : this.getSimpleName(methodParameter);
                }
                JClass paraType = methodParameter.getType();
                if (this.nonRpcMethods.contains(this.getSimpleName(jMethod))) {
                    this.generateSchemaForType(sequence, null, this.getSimpleName(jMethod));
                    break;
                }
                this.generateSchemaForType(sequence, paraType, parameterName);
            }
            if (!(returnType = jMethod.getReturnType()).isVoidType()) {
                String partQname = methodName + "Response";
                methodSchemaType = this.createSchemaTypeForMethodPart(partQname);
                sequence = new XmlSchemaSequence();
                methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                JAnnotation returnAnnon = jMethod.getAnnotation("javax.jws.WebResult");
                String returnName = "return";
                if (returnAnnon != null && (returnName = returnAnnon.getValue("name").asString()) != null && !"".equals(returnName)) {
                    returnName = "return";
                }
                if (this.nonRpcMethods.contains(this.getSimpleName(jMethod))) {
                    this.generateSchemaForType(sequence, null, returnName);
                } else {
                    this.generateSchemaForType(sequence, returnType, returnName);
                }
                AxisMessage outMessage = axisOperation.getMessage("Out");
                outMessage.setElementQName(this.typeTable.getQNamefortheType(partQname));
                outMessage.setName(partQname);
                this.service.addMessageElementQNameToOperationMapping(methodSchemaType.getQName(), axisOperation);
            }
            if (!addToService) continue;
            this.service.addOperation(axisOperation);
        }
        return list.toArray(new JMethod[list.size()]);
    }

    protected void processException(JMethod jMethod, AxisOperation axisOperation) throws Exception {
        if (jMethod.getExceptionTypes().length > 0) {
            XmlSchemaSequence sequence;
            if (!this.generateBaseException) {
                if (this.typeTable.getComplexSchemaType(Exception.class.getName()) == null) {
                    sequence = new XmlSchemaSequence();
                    XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
                    QName elementName = new QName(this.schemaTargetNameSpace, "Exception", this.schema_namespace_prefix);
                    XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
                    complexType.setName("Exception");
                    xmlSchema.getItems().add((XmlSchemaObject)complexType);
                    xmlSchema.getElements().add(elementName, (XmlSchemaObject)complexType);
                    this.typeTable.addComplexSchema(Exception.class.getName(), elementName);
                    QName schemaTypeName = TypeTable.ANY_TYPE;
                    this.addContentToMethodSchemaType(sequence, schemaTypeName, "Exception", false);
                    complexType.setParticle((XmlSchemaParticle)sequence);
                }
                this.generateBaseException = true;
            }
            JClass[] extypes = jMethod.getExceptionTypes();
            for (int j = 0; j < extypes.length; ++j) {
                JClass extype = extypes[j];
                if (AxisFault.class.getName().equals(extype.getQualifiedName())) continue;
                String partQname = extype.getSimpleName();
                XmlSchemaComplexType methodSchemaType = this.createSchemaTypeForFault(partQname);
                QName elementName = new QName(this.schemaTargetNameSpace, partQname, this.schema_namespace_prefix);
                sequence = new XmlSchemaSequence();
                if (Exception.class.getName().equals(extype.getQualifiedName())) {
                    QName schemaTypeName = this.typeTable.getComplexSchemaType(Exception.class.getName());
                    this.addContentToMethodSchemaType(sequence, schemaTypeName, partQname, false);
                    methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                    this.typeTable.addComplexSchema(Exception.class.getPackage().getName(), methodSchemaType.getQName());
                    String schemaNamespace = this.resolveSchemaNamespace(Exception.class.getPackage().getName());
                    this.addImport(this.getXmlSchema(this.schemaTargetNameSpace), schemaTypeName);
                } else {
                    this.generateSchemaForType(sequence, extype, extype.getSimpleName());
                    methodSchemaType.setParticle((XmlSchemaParticle)sequence);
                }
                this.typeTable.addComplexSchema(partQname, elementName);
                if (AxisFault.class.getName().equals(extype.getQualifiedName())) continue;
                AxisMessage faultMessage = new AxisMessage();
                faultMessage.setName(extype.getSimpleName());
                faultMessage.setElementQName(this.typeTable.getQNamefortheType(partQname));
                axisOperation.setFaultMessages(faultMessage);
            }
        }
    }

    public static String getCorrectName(String wrongName) {
        if (wrongName.length() > 1) {
            return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH) + wrongName.substring(1, wrongName.length());
        }
        return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH);
    }

    private QName generateSchema(JClass javaType) throws Exception {
        String name = this.getQualifiedName(javaType);
        QName schemaTypeName = this.typeTable.getComplexSchemaType(name);
        if (schemaTypeName == null) {
            int i;
            String simpleName = this.getSimpleName(javaType);
            String packageName = this.getQualifiedName(javaType.getContainingPackage());
            String targetNameSpace = this.resolveSchemaNamespace(packageName);
            XmlSchema xmlSchema = this.getXmlSchema(targetNameSpace);
            String targetNamespacePrefix = (String)this.targetNamespacePrefixMap.get(targetNameSpace);
            if (targetNamespacePrefix == null) {
                targetNamespacePrefix = this.generatePrefix();
                this.targetNamespacePrefixMap.put(targetNameSpace, targetNamespacePrefix);
            }
            XmlSchemaComplexType complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaSequence sequence = new XmlSchemaSequence();
            XmlSchemaComplexContentExtension complexExtension = new XmlSchemaComplexContentExtension();
            XmlSchemaElement eltOuter = new XmlSchemaElement();
            schemaTypeName = new QName(targetNameSpace, simpleName, targetNamespacePrefix);
            eltOuter.setName(simpleName);
            eltOuter.setQName(schemaTypeName);
            JClass sup = javaType.getSuperclass();
            if (sup != null && "java.lang.Object".compareTo(sup.getQualifiedName()) != 0 && "org.apache.axis2".compareTo(sup.getContainingPackage().getQualifiedName()) != 0 && "java.util".compareTo(sup.getContainingPackage().getQualifiedName()) != 0) {
                String tgtNamespacepfx;
                String tgtNamespace;
                String superClassName = sup.getQualifiedName();
                String superclassname = this.getSimpleName(sup);
                QName qName = this.typeTable.getSimpleSchemaTypeName(superClassName);
                if (qName != null) {
                    tgtNamespace = qName.getNamespaceURI();
                    tgtNamespacepfx = qName.getPrefix();
                } else {
                    tgtNamespace = this.resolveSchemaNamespace(sup.getContainingPackage().getQualifiedName());
                    tgtNamespacepfx = (String)this.targetNamespacePrefixMap.get(tgtNamespace);
                    QName superClassQname = this.generateSchema(sup);
                    if (superClassQname != null) {
                        tgtNamespacepfx = superClassQname.getPrefix();
                        tgtNamespace = superClassQname.getNamespaceURI();
                    }
                }
                if (tgtNamespacepfx == null) {
                    tgtNamespacepfx = this.generatePrefix();
                    this.targetNamespacePrefixMap.put(tgtNamespace, tgtNamespacepfx);
                }
                if (!((NamespaceMap)xmlSchema.getNamespaceContext()).values().contains(tgtNamespace)) {
                    XmlSchemaImport importElement = new XmlSchemaImport();
                    importElement.setNamespace(tgtNamespace);
                    xmlSchema.getItems().add((XmlSchemaObject)importElement);
                    ((NamespaceMap)xmlSchema.getNamespaceContext()).put((Object)this.generatePrefix(), (Object)tgtNamespace);
                }
                QName basetype = new QName(tgtNamespace, superclassname, tgtNamespacepfx);
                complexExtension.setBaseTypeName(basetype);
                complexExtension.setParticle((XmlSchemaParticle)sequence);
                XmlSchemaComplexContent contentModel = new XmlSchemaComplexContent();
                contentModel.setContent((XmlSchemaContent)complexExtension);
                complexType.setContentModel((XmlSchemaContentModel)contentModel);
            } else {
                complexType.setParticle((XmlSchemaParticle)sequence);
            }
            complexType.setName(simpleName);
            xmlSchema.getElements().add(schemaTypeName, (XmlSchemaObject)eltOuter);
            eltOuter.setSchemaTypeName(complexType.getQName());
            xmlSchema.getItems().add((XmlSchemaObject)complexType);
            xmlSchema.getSchemaTypes().add(schemaTypeName, (XmlSchemaObject)complexType);
            this.typeTable.addComplexSchema(name, eltOuter.getQName());
            this.typeTable.addComplexSchema(javaType.getContainingPackage().getQualifiedName(), eltOuter.getQName());
            HashSet<JProperty> propertiesSet = new HashSet<JProperty>();
            HashSet<String> propertiesNames = new HashSet<String>();
            JProperty[] tempProperties = javaType.getDeclaredProperties();
            BeanExcludeInfo beanExcludeInfo = null;
            if (this.service.getExcludeInfo() != null) {
                beanExcludeInfo = this.service.getExcludeInfo().getBeanExcludeInfoForClass(javaType.getQualifiedName());
            }
            for (int i2 = 0; i2 < tempProperties.length; ++i2) {
                JProperty tempProperty = tempProperties[i2];
                String propertyName = DefaultSchemaGenerator.getCorrectName(tempProperty.getSimpleName());
                if (beanExcludeInfo != null && beanExcludeInfo.isExcludedProperty(propertyName)) continue;
                propertiesSet.add(tempProperty);
            }
            Object[] properties = propertiesSet.toArray(new JProperty[0]);
            Arrays.sort(properties);
            for (int i3 = 0; i3 < properties.length; ++i3) {
                Object property = properties[i3];
                boolean isArryType = property.getType().isArrayType();
                String propname = DefaultSchemaGenerator.getCorrectName(property.getSimpleName());
                propertiesNames.add(propname);
                this.generateSchemaforFieldsandProperties(xmlSchema, sequence, property.getType(), propname, isArryType);
            }
            JField[] tempFields = javaType.getDeclaredFields();
            HashMap<String, JField> FieldMap = new HashMap<String, JField>();
            for (int i4 = 0; i4 < tempFields.length; ++i4) {
                if (!tempFields[i4].isPublic() || tempFields[i4].isStatic()) continue;
                String propertyName = DefaultSchemaGenerator.getCorrectName(tempFields[i4].getSimpleName());
                if (beanExcludeInfo != null && beanExcludeInfo.isExcludedProperty(propertyName) || propertiesNames.contains(tempFields[i4].getSimpleName())) continue;
                FieldMap.put(tempFields[i4].getSimpleName(), tempFields[i4]);
            }
            for (JClass supr = javaType.getSuperclass(); supr != null && supr.getQualifiedName().compareTo("java.lang.Object") != 0; supr = supr.getSuperclass()) {
                JField[] suprFields = supr.getFields();
                for (i = 0; i < suprFields.length; ++i) {
                    FieldMap.remove(suprFields[i].getSimpleName());
                }
            }
            Object[] froperties = FieldMap.values().toArray(new JField[0]);
            Arrays.sort(froperties);
            for (i = 0; i < froperties.length; ++i) {
                Object field = froperties[i];
                boolean isArryType = field.getType().isArrayType();
                this.generateSchemaforFieldsandProperties(xmlSchema, sequence, field.getType(), field.getSimpleName(), isArryType);
            }
        }
        return schemaTypeName;
    }

    protected void generateSchemaforFieldsandProperties(XmlSchema xmlSchema, XmlSchemaSequence sequence, JClass type, String name, boolean isArryType) throws Exception {
        String propertyName = isArryType ? this.getQualifiedName(type.getArrayComponentType()) : this.getQualifiedName(type);
        if (isArryType && "byte".equals(propertyName)) {
            propertyName = "base64Binary";
        }
        if (this.isDataHandler(type)) {
            propertyName = "base64Binary";
        }
        if (this.typeTable.isSimpleType(propertyName)) {
            XmlSchemaElement elt1 = new XmlSchemaElement();
            elt1.setName(name);
            elt1.setSchemaTypeName(this.typeTable.getSimpleSchemaTypeName(propertyName));
            sequence.getItems().add((XmlSchemaObject)elt1);
            if (isArryType && !propertyName.equals("base64Binary")) {
                elt1.setMaxOccurs(Long.MAX_VALUE);
            }
            elt1.setMinOccurs(0L);
            if (!type.isPrimitiveType()) {
                elt1.setNillable(true);
            }
        } else {
            if (isArryType) {
                this.generateSchema(type.getArrayComponentType());
            } else {
                this.generateSchema(type);
            }
            XmlSchemaElement elt1 = new XmlSchemaElement();
            elt1.setName(name);
            elt1.setSchemaTypeName(this.typeTable.getComplexSchemaType(propertyName));
            sequence.getItems().add((XmlSchemaObject)elt1);
            if (isArryType) {
                elt1.setMaxOccurs(Long.MAX_VALUE);
            }
            elt1.setMinOccurs(0L);
            elt1.setNillable(true);
            if (!((NamespaceMap)xmlSchema.getNamespaceContext()).values().contains(this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI())) {
                XmlSchemaImport importElement = new XmlSchemaImport();
                importElement.setNamespace(this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI());
                xmlSchema.getItems().add((XmlSchemaObject)importElement);
                ((NamespaceMap)xmlSchema.getNamespaceContext()).put((Object)this.generatePrefix(), (Object)this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI());
            }
        }
    }

    private QName generateSchemaForType(XmlSchemaSequence sequence, JClass type, String partName) throws Exception {
        QName schemaTypeName;
        boolean isArrayType = false;
        if (type != null) {
            isArrayType = type.isArrayType();
        }
        if (isArrayType) {
            type = type.getArrayComponentType();
        }
        if (AxisFault.class.getName().equals(type)) {
            return null;
        }
        String classTypeName = type == null ? "java.lang.Object" : this.getQualifiedName(type);
        if (isArrayType && "byte".equals(classTypeName)) {
            classTypeName = "base64Binary";
            isArrayType = false;
        }
        if (this.isDataHandler(type)) {
            classTypeName = "base64Binary";
        }
        if ((schemaTypeName = this.typeTable.getSimpleSchemaTypeName(classTypeName)) == null) {
            schemaTypeName = this.generateSchema(type);
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
            String schemaNamespace = this.resolveSchemaNamespace(this.getQualifiedName(type.getContainingPackage()));
            this.addImport(this.getXmlSchema(schemaNamespace), schemaTypeName);
        } else {
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
        }
        this.addImport(this.getXmlSchema(this.schemaTargetNameSpace), schemaTypeName);
        return schemaTypeName;
    }

    protected boolean isDataHandler(JClass clazz) {
        if (clazz == null) {
            return false;
        }
        String classType = clazz.getQualifiedName();
        if ("java.lang.Object".equals(classType)) {
            return false;
        }
        if ("javax.activation.DataHandler".equals(classType)) {
            return true;
        }
        JClass supuerClass = clazz.getSuperclass();
        if (supuerClass != null) {
            return this.isDataHandler(supuerClass);
        }
        return false;
    }

    protected void addContentToMethodSchemaType(XmlSchemaSequence sequence, QName schemaTypeName, String paraName, boolean isArray) {
        XmlSchemaElement elt1 = new XmlSchemaElement();
        elt1.setName(paraName);
        elt1.setSchemaTypeName(schemaTypeName);
        if (sequence != null) {
            sequence.getItems().add((XmlSchemaObject)elt1);
        }
        if (isArray) {
            elt1.setMaxOccurs(Long.MAX_VALUE);
        }
        elt1.setMinOccurs(0L);
        if (!("int".equals(schemaTypeName.getLocalPart()) || "double".equals(schemaTypeName.getLocalPart()) || "long".equals(schemaTypeName.getLocalPart()) || "boolean".equals(schemaTypeName.getLocalPart()) || "short".equals(schemaTypeName.getLocalPart()) || "float".equals(schemaTypeName.getLocalPart()))) {
            elt1.setNillable(true);
        }
    }

    private XmlSchemaComplexType createSchemaTypeForMethodPart(String localPartName) {
        QName elementName;
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaComplexType complexType = this.getComplexTypeForElement(xmlSchema, elementName = new QName(this.schemaTargetNameSpace, localPartName, this.schema_namespace_prefix));
        if (complexType == null) {
            complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaElement globalElement = new XmlSchemaElement();
            globalElement.setSchemaType((XmlSchemaType)complexType);
            globalElement.setName(localPartName);
            globalElement.setQName(elementName);
            xmlSchema.getItems().add((XmlSchemaObject)globalElement);
            xmlSchema.getElements().add(elementName, (XmlSchemaObject)globalElement);
        }
        this.typeTable.addComplexSchema(localPartName, elementName);
        return complexType;
    }

    private XmlSchemaComplexType createSchemaTypeForFault(String localPartName) {
        QName elementName;
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        XmlSchemaComplexType complexType = this.getComplexTypeForElement(xmlSchema, elementName = new QName(this.schemaTargetNameSpace, localPartName, this.schema_namespace_prefix));
        if (complexType == null) {
            complexType = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaElement globalElement = new XmlSchemaElement();
            globalElement.setSchemaType((XmlSchemaType)complexType);
            globalElement.setName(localPartName);
            globalElement.setQName(elementName);
            xmlSchema.getItems().add((XmlSchemaObject)globalElement);
            xmlSchema.getElements().add(elementName, (XmlSchemaObject)globalElement);
        }
        return complexType;
    }

    protected XmlSchemaComplexType getComplexTypeForElement(XmlSchema xmlSchema, QName name) {
        Iterator iterator = xmlSchema.getItems().getIterator();
        while (iterator.hasNext()) {
            XmlSchemaObject object = (XmlSchemaObject)iterator.next();
            if (!(object instanceof XmlSchemaElement) || !((XmlSchemaElement)object).getQName().equals(name)) continue;
            return (XmlSchemaComplexType)((XmlSchemaElement)object).getSchemaType();
        }
        return null;
    }

    protected XmlSchema getXmlSchema(String targetNamespace) {
        XmlSchema xmlSchema = (XmlSchema)this.schemaMap.get(targetNamespace);
        if (xmlSchema == null) {
            String targetNamespacePrefix = targetNamespace.equals(this.schemaTargetNameSpace) && this.schema_namespace_prefix != null ? this.schema_namespace_prefix : this.generatePrefix();
            xmlSchema = new XmlSchema(targetNamespace, this.xmlSchemaCollection);
            xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
            xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
            this.targetNamespacePrefixMap.put(targetNamespace, targetNamespacePrefix);
            this.schemaMap.put(targetNamespace, xmlSchema);
            NamespaceMap prefixmap = new NamespaceMap();
            prefixmap.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
            prefixmap.put((Object)targetNamespacePrefix, (Object)targetNamespace);
            xmlSchema.setNamespaceContext((NamespacePrefixList)prefixmap);
        }
        return xmlSchema;
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    public JMethod[] getMethods() {
        return this.methods;
    }

    protected String generatePrefix() {
        return NAME_SPACE_PREFIX + prefixCount++;
    }

    public void setExcludeMethods(ArrayList excludeMethods) {
        if (excludeMethods == null) {
            excludeMethods = new ArrayList();
        }
        this.excludeMethods = excludeMethods;
    }

    public String getSchemaTargetNameSpace() {
        return this.schemaTargetNameSpace;
    }

    protected void addImport(XmlSchema xmlSchema, QName schemaTypeName) {
        NamespacePrefixList map = xmlSchema.getNamespaceContext();
        if (map == null || map instanceof NamespaceMap && ((NamespaceMap)map).values() == null || schemaTypeName == null) {
            return;
        }
        if (map instanceof NamespaceMap && !((NamespaceMap)map).values().contains(schemaTypeName.getNamespaceURI())) {
            XmlSchemaImport importElement = new XmlSchemaImport();
            importElement.setNamespace(schemaTypeName.getNamespaceURI());
            xmlSchema.getItems().add((XmlSchemaObject)importElement);
            ((NamespaceMap)xmlSchema.getNamespaceContext()).put((Object)this.generatePrefix(), (Object)schemaTypeName.getNamespaceURI());
        }
    }

    public String getAttrFormDefault() {
        return this.attrFormDefault;
    }

    public void setAttrFormDefault(String attrFormDefault) {
        this.attrFormDefault = attrFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    protected XmlSchemaForm getAttrFormDefaultSetting() {
        if ("unqualified".equals(this.getAttrFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    protected XmlSchemaForm getElementFormDefaultSetting() {
        if ("unqualified".equals(this.getElementFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    public ArrayList getExtraClasses() {
        if (this.extraClasses == null) {
            this.extraClasses = new ArrayList();
        }
        return this.extraClasses;
    }

    public void setExtraClasses(ArrayList extraClasses) {
        this.extraClasses = extraClasses;
    }

    protected String resolveSchemaNamespace(String packageName) throws Exception {
        if (this.useWSDLTypesNamespace) {
            return (String)this.pkg2nsmap.get("all");
        }
        if (this.pkg2nsmap != null && !this.pkg2nsmap.isEmpty()) {
            if (this.pkg2nsmap.get(packageName) != null) {
                return (String)this.pkg2nsmap.get(packageName);
            }
            return this.getNsGen().schemaNamespaceFromPackageName(packageName).toString();
        }
        return this.getNsGen().schemaNamespaceFromPackageName(packageName).toString();
    }

    public boolean isUseWSDLTypesNamespace() {
        return this.useWSDLTypesNamespace;
    }

    public void setUseWSDLTypesNamespace(boolean useWSDLTypesNamespace) {
        this.useWSDLTypesNamespace = useWSDLTypesNamespace;
    }

    public Map getPkg2nsmap() {
        return this.pkg2nsmap;
    }

    public void setPkg2nsmap(Map pkg2nsmap) {
        this.pkg2nsmap = pkg2nsmap;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    protected String getSimpleName(JMethod method) {
        return Utils.getSimpleName(method);
    }

    protected String getSimpleName(JClass type) {
        String name = type.getSimpleName();
        if (name.indexOf("$") > 0) {
            name = name.replace('$', '_');
        }
        return name;
    }

    protected String getSimpleName(JProperty peroperty) {
        return peroperty.getSimpleName();
    }

    protected String getSimpleName(JParameter parameter) {
        return parameter.getSimpleName();
    }

    protected String getQualifiedName(JMethod method) {
        return method.getQualifiedName();
    }

    protected String getActualQualifiedName(JClass type) {
        return type.getQualifiedName();
    }

    protected String getQualifiedName(JClass type) {
        String name = type.getQualifiedName();
        if (name.indexOf("$") > 0) {
            name = name.replace('$', '_');
        }
        return name;
    }

    protected String getQualifiedName(JProperty peroperty) {
        return peroperty.getQualifiedName();
    }

    protected String getQualifiedName(JParameter parameter) {
        return parameter.getQualifiedName();
    }

    protected String getQualifiedName(JPackage packagez) {
        return packagez.getQualifiedName();
    }

    public void setNonRpcMethods(ArrayList nonRpcMethods) {
        if (nonRpcMethods != null) {
            this.nonRpcMethods = nonRpcMethods;
        }
    }

    public void setAxisService(AxisService service) {
        this.service = service;
    }

    public String getCustomSchemaLocation() {
        return this.customSchemaLocation;
    }

    public void setCustomSchemaLocation(String customSchemaLocation) {
        this.customSchemaLocation = customSchemaLocation;
    }

    public String getMappingFileLocation() {
        return this.mappingFileLocation;
    }

    public void setMappingFileLocation(String mappingFileLocation) {
        this.mappingFileLocation = mappingFileLocation;
    }
}

