/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.dispatchers;

import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.dispatchers.AbstractServiceDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestURIBasedServiceDispatcher
extends AbstractServiceDispatcher {
    public static final String NAME = "RequestURIBasedServiceDispatcher";
    private static final Log log = LogFactory.getLog(RequestURIBasedServiceDispatcher.class);

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        EndpointReference toEPR = messageContext.getTo();
        if (toEPR != null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " Checking for Service using target endpoint address : " + toEPR.getAddress()));
            }
            String filePart = toEPR.getAddress();
            ConfigurationContext configurationContext = messageContext.getConfigurationContext();
            String[] values = Utils.parseRequestURLForServiceAndOperation(filePart, messageContext.getConfigurationContext().getServiceContextPath());
            if (values.length >= 1 && values[0] != null) {
                Map endpoints;
                AxisConfiguration registry = configurationContext.getAxisConfiguration();
                AxisService axisService = registry.getService(values[0]);
                if (axisService != null && (endpoints = axisService.getEndpoints()) != null) {
                    if (endpoints.size() == 1) {
                        messageContext.setProperty("endpoint", endpoints.get(axisService.getEndpointName()));
                    } else {
                        String endpointName = values[0].substring(values[0].indexOf(".") + 1);
                        AxisEndpoint endpoint = (AxisEndpoint)endpoints.get(endpointName);
                        if (endpoint != null) {
                            messageContext.setProperty("endpoint", endpoint);
                        } else {
                            this.inferEndpoint(messageContext, axisService);
                        }
                    }
                }
                return axisService;
            }
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Service using target endpoint URI, but the service fragment was missing"));
            }
            return null;
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)(messageContext.getLogIDString() + " Attempted to check for Service using null target endpoint URI"));
        }
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    private void inferEndpoint(MessageContext msgCtx, AxisService service) {
        if (!msgCtx.isServerSide()) {
            return;
        }
        String transport = null;
        TransportInDescription transportIn = msgCtx.getTransportIn();
        if (transportIn != null && (transport = transportIn.getName()) == null) {
            return;
        }
        AxisEndpoint endpoint = null;
        HashMap endpointMapping = service.getEpMap();
        if (msgCtx.isDoingREST()) {
            endpoint = (AxisEndpoint)endpointMapping.get(transport + ":http");
        } else {
            SOAPEnvelope envelope = msgCtx.getEnvelope();
            String namespaceURI = envelope.getNamespace().getNamespaceURI();
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) {
                endpoint = (AxisEndpoint)endpointMapping.get(transport + ":soap11");
            } else if ("http://www.w3.org/2003/05/soap-envelope".equals(namespaceURI)) {
                endpoint = (AxisEndpoint)endpointMapping.get(transport + ":soap12");
            }
        }
        if (endpoint != null) {
            msgCtx.setProperty("endpoint", endpoint);
        }
    }
}

