/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.AbstractHTTPSender;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPSender;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.transport.http.server.AxisHttpResponseImpl;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsHTTPTransportSender
extends AbstractHandler
implements TransportSender {
    protected static final String PROXY_HOST_NAME = "proxy_host";
    protected static final String PROXY_PORT = "proxy_port";
    int soTimeout = 60000;
    protected TransportOutDescription proxyOutSetting = null;
    private static final Log log = LogFactory.getLog(CommonsHTTPTransportSender.class);
    protected String httpVersion = "HTTP/1.1";
    private boolean chunked = false;
    int connectionTimeout = 60000;

    public void cleanup(MessageContext msgContext) throws AxisFault {
        HttpMethod httpMethod = (HttpMethod)msgContext.getProperty("HTTP_METHOD_OBJECT");
        if (httpMethod != null) {
            httpMethod.releaseConnection();
        }
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
        Parameter version = transportOut.getParameter("PROTOCOL");
        if (version != null) {
            if ("HTTP/1.1".equals(version.getValue())) {
                this.httpVersion = "HTTP/1.1";
                Parameter transferEncoding = transportOut.getParameter(HTTPConstants.HEADER_TRANSFER_ENCODING);
                if (transferEncoding != null && HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equals(transferEncoding.getValue())) {
                    this.chunked = true;
                }
            } else if ("HTTP/1.0".equals(version.getValue())) {
                this.httpVersion = "HTTP/1.0";
            } else {
                throw new AxisFault("Parameter PROTOCOL Can have values only HTTP/1.0 or HTTP/1.1");
            }
        }
        try {
            Parameter tempSoTimeoutParam = transportOut.getParameter("SO_TIMEOUT");
            Parameter tempConnTimeoutParam = transportOut.getParameter("CONNECTION_TIMEOUT");
            if (tempSoTimeoutParam != null) {
                this.soTimeout = Integer.parseInt((String)tempSoTimeoutParam.getValue());
            }
            if (tempConnTimeoutParam != null) {
                this.connectionTimeout = Integer.parseInt((String)tempConnTimeoutParam.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"Invalid timeout value format: not a number", (Throwable)nfe);
        }
    }

    public void stop() {
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        block15: {
            try {
                OMOutputFormat format = new OMOutputFormat();
                msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
                msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
                msgContext.setDoingREST(HTTPTransportUtils.isDoingREST(msgContext));
                format.setSOAP11(msgContext.isSOAP11());
                format.setDoOptimize(msgContext.isDoingMTOM());
                format.setDoingSWA(msgContext.isDoingSwA());
                format.setCharSetEncoding(HTTPTransportUtils.getCharSetEncoding(msgContext));
                Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
                if (mimeBoundaryProperty != null) {
                    format.setMimeBoundary((String)mimeBoundaryProperty);
                }
                TransportOutDescription transportOut = msgContext.getConfigurationContext().getAxisConfiguration().getTransportOut("http");
                Parameter soTimeoutParam = transportOut.getParameter("SO_TIMEOUT");
                Parameter connTimeoutParam = transportOut.getParameter("CONNECTION_TIMEOUT");
                if (soTimeoutParam != null && msgContext.getProperty("SO_TIMEOUT") == null) {
                    msgContext.setProperty("SO_TIMEOUT", new Integer((String)soTimeoutParam.getValue()));
                }
                if (connTimeoutParam != null && msgContext.getProperty("CONNECTION_TIMEOUT") == null) {
                    msgContext.setProperty("CONNECTION_TIMEOUT", new Integer((String)connTimeoutParam.getValue()));
                }
                if (transportOut != null && !msgContext.isSOAP11()) {
                    Object propertyValue;
                    Parameter param = transportOut.getParameter("OmitSOAP12Action");
                    Object parameterValue = null;
                    if (param != null) {
                        parameterValue = param.getValue();
                    }
                    if (parameterValue != null && JavaUtils.isTrueExplicitly(parameterValue) && ((propertyValue = msgContext.getProperty("disableSoapAction")) == null || !JavaUtils.isFalseExplicitly(propertyValue))) {
                        msgContext.setProperty("disableSoapAction", Boolean.TRUE);
                    }
                }
                EndpointReference epr = null;
                String transportURL = (String)msgContext.getProperty("TransportURL");
                if (transportURL != null) {
                    epr = new EndpointReference(transportURL);
                } else if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
                    epr = msgContext.getTo();
                }
                if (epr != null) {
                    if (!epr.hasNoneAddress()) {
                        this.writeMessageWithCommons(msgContext, epr, format);
                    }
                    break block15;
                }
                if (msgContext.getProperty("TRANSPORT_OUT") != null) {
                    this.sendUsingOutputStream(msgContext, format);
                    TransportUtils.setResponseWritten(msgContext, true);
                    break block15;
                }
                throw new AxisFault("Both the TO and MessageContext.TRANSPORT_OUT property are null, so nowhere to send");
            }
            catch (FactoryConfigurationError e) {
                log.debug((Object)e);
                throw AxisFault.makeFault(e);
            }
            catch (IOException e) {
                log.debug((Object)e);
                throw AxisFault.makeFault(e);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void sendUsingOutputStream(MessageContext msgContext, OMOutputFormat format) throws AxisFault {
        block23: {
            Object customHeaders;
            OutputStream out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT");
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            if (transportInfo == null) {
                throw new AxisFault("No transport info in MessageContext");
            }
            ServletBasedOutTransportInfo servletBasedOutTransportInfo = null;
            if (transportInfo instanceof ServletBasedOutTransportInfo) {
                servletBasedOutTransportInfo = (ServletBasedOutTransportInfo)transportInfo;
                if (msgContext.isFault()) {
                    servletBasedOutTransportInfo.setStatus(500);
                }
                if ((customHeaders = msgContext.getProperty("HTTP_HEADERS")) != null) {
                    if (customHeaders instanceof List) {
                        for (Header header : (List)customHeaders) {
                            if (header == null) continue;
                            servletBasedOutTransportInfo.addHeader(header.getName(), header.getValue());
                        }
                    } else if (customHeaders instanceof Map) {
                        for (Map.Entry entry : ((Map)customHeaders).entrySet()) {
                            if (entry == null) continue;
                            servletBasedOutTransportInfo.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
            } else if (transportInfo instanceof AxisHttpResponseImpl && (customHeaders = msgContext.getProperty("HTTP_HEADERS")) != null) {
                if (customHeaders instanceof List) {
                    for (Header header : (List)customHeaders) {
                        if (header == null) continue;
                        ((AxisHttpResponseImpl)transportInfo).addHeader(header.getName(), header.getValue());
                    }
                } else if (customHeaders instanceof Map) {
                    for (Map.Entry entry : ((Map)customHeaders).entrySet()) {
                        if (entry == null) continue;
                        ((AxisHttpResponseImpl)transportInfo).addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
            format.setAutoCloseWriter(true);
            MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(msgContext);
            if (messageFormatter == null) {
                throw new AxisFault("No MessageFormatter in MessageContext");
            }
            try {
                transportInfo.setContentType(messageFormatter.getContentType(msgContext, format, CommonsHTTPTransportSender.findSOAPAction(msgContext)));
                Object gzip = msgContext.getOptions().getProperty("gzipResponse");
                if (gzip != null && JavaUtils.isTrueExplicitly(gzip)) {
                    if (servletBasedOutTransportInfo != null) {
                        servletBasedOutTransportInfo.addHeader("Content-Encoding", "gzip");
                    }
                    try {
                        out = new GZIPOutputStream(out);
                        out.write(messageFormatter.getBytes(msgContext, format));
                        ((GZIPOutputStream)out).finish();
                        out.flush();
                        break block23;
                    }
                    catch (IOException iOException) {
                        throw new AxisFault("Could not compress response");
                    }
                }
                messageFormatter.writeTo(msgContext, format, out, false);
            }
            catch (AxisFault axisFault) {
                log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
                throw axisFault;
            }
        }
    }

    private void writeMessageWithCommons(MessageContext messageContext, EndpointReference toEPR, OMOutputFormat format) throws AxisFault {
        try {
            URL url = new URL(toEPR.getAddress());
            HTTPSender sender = new HTTPSender();
            if (messageContext.getProperty("__CHUNKED__") != null) {
                this.chunked = JavaUtils.isTrueExplicitly(messageContext.getProperty("__CHUNKED__"));
            }
            if (messageContext.getProperty("__HTTP_PROTOCOL_VERSION__") != null) {
                this.httpVersion = (String)messageContext.getProperty("__HTTP_PROTOCOL_VERSION__");
            }
            sender.setChunked(this.chunked);
            sender.setHttpVersion(this.httpVersion);
            sender.setFormat(format);
            ((AbstractHTTPSender)sender).send(messageContext, url, CommonsHTTPTransportSender.findSOAPAction(messageContext));
        }
        catch (MalformedURLException e) {
            log.debug((Object)e);
            throw AxisFault.makeFault(e);
        }
        catch (HttpException e) {
            log.debug((Object)e);
            throw AxisFault.makeFault(e);
        }
        catch (IOException e) {
            log.debug((Object)e);
            throw AxisFault.makeFault(e);
        }
    }

    private static String findSOAPAction(MessageContext messageContext) {
        String soapActionString = null;
        Parameter parameter = messageContext.getTransportOut().getParameter("OmitSOAP12Action");
        if (parameter != null && JavaUtils.isTrueExplicitly(parameter.getValue()) && !messageContext.isSOAP11()) {
            return "\"\"";
        }
        Object disableSoapAction = messageContext.getOptions().getProperty("disableSoapAction");
        if (!(JavaUtils.isTrueExplicitly(disableSoapAction) || (soapActionString = messageContext.getSoapAction()) != null && soapActionString.length() != 0)) {
            soapActionString = messageContext.getWSAAction();
            if (messageContext.getAxisOperation() != null && (soapActionString == null || soapActionString.length() == 0)) {
                soapActionString = messageContext.getAxisOperation().getSoapAction();
            }
        }
        if (soapActionString == null && messageContext.isSOAP11()) {
            soapActionString = "\"\"";
        }
        return soapActionString;
    }
}

