/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Utils;

public class HTTPTransportUtils {
    private static final int VERSION_UNKNOWN = 0;
    private static final int VERSION_SOAP11 = 1;
    private static final int VERSION_SOAP12 = 2;

    public static SOAPEnvelope createEnvelopeFromGetRequest(String requestUrl, Map map, ConfigurationContext configCtx) throws AxisFault {
        String[] values = Utils.parseRequestURLForServiceAndOperation(requestUrl, configCtx.getServiceContextPath());
        if (values == null) {
            return new SOAP11Factory().getDefaultEnvelope();
        }
        if (values[1] != null && values[0] != null) {
            String srvice = values[0];
            AxisService service = configCtx.getAxisConfiguration().getService(srvice);
            if (service == null) {
                throw new AxisFault("service not found: " + srvice);
            }
            String operation = values[1];
            SOAP11Factory soapFactory = new SOAP11Factory();
            SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
            OMNamespace omNs = soapFactory.createOMNamespace(service.getSchemaTargetNamespace(), service.getSchemaTargetNamespacePrefix());
            soapFactory.createOMNamespace(service.getSchemaTargetNamespace(), service.getSchemaTargetNamespacePrefix());
            OMElement opElement = soapFactory.createOMElement(operation, omNs);
            for (String name : map.keySet()) {
                String value = (String)map.get(name);
                OMElement omEle = soapFactory.createOMElement(name, omNs);
                omEle.setText(value);
                opElement.addChild((OMNode)omEle);
            }
            envelope.getBody().addChild((OMNode)opElement);
            return envelope;
        }
        return null;
    }

    public static boolean doWriteMTOM(MessageContext msgContext) {
        boolean enableMTOM;
        Object property;
        Object enableMTOMObject = null;
        Parameter parameter = msgContext.getParameter("enableMTOM");
        if (parameter != null) {
            enableMTOMObject = parameter.getValue();
        }
        if ((property = msgContext.getProperty("enableMTOM")) != null) {
            enableMTOMObject = property;
        }
        if (!(enableMTOM = JavaUtils.isTrueExplicitly(enableMTOMObject)) && msgContext.isDoingMTOM() && enableMTOMObject instanceof String && ((String)enableMTOMObject).equalsIgnoreCase("optional")) {
            enableMTOM = true;
        }
        return enableMTOM;
    }

    public static boolean doWriteSwA(MessageContext msgContext) {
        boolean enableSwA;
        Object property;
        Object enableSwAObject = null;
        Parameter parameter = msgContext.getParameter("enableSwA");
        if (parameter != null) {
            enableSwAObject = parameter.getValue();
        }
        if ((property = msgContext.getProperty("enableSwA")) != null) {
            enableSwAObject = property;
        }
        if (!(enableSwA = JavaUtils.isTrueExplicitly(enableSwAObject)) && msgContext.isDoingSwA() && enableSwAObject instanceof String && ((String)enableSwAObject).equalsIgnoreCase("optional")) {
            enableSwA = true;
        }
        return enableSwA;
    }

    public static String getCharSetEncoding(MessageContext msgContext) {
        String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
        if (charSetEnc == null) {
            OperationContext opctx = msgContext.getOperationContext();
            if (opctx != null) {
                charSetEnc = (String)opctx.getProperty("CHARACTER_SET_ENCODING");
            }
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
        }
        return charSetEnc;
    }

    public static boolean processHTTPGetRequest(MessageContext msgContext, OutputStream out, String soapAction, String requestURI, ConfigurationContext configurationContext, Map requestParameters) throws AxisFault {
        if (soapAction != null && soapAction.startsWith("\"") && soapAction.endsWith("\"")) {
            soapAction = soapAction.substring(1, soapAction.length() - 1);
        }
        msgContext.setSoapAction(soapAction);
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setProperty("TRANSPORT_OUT", out);
        msgContext.setServerSide(true);
        SOAPEnvelope envelope = HTTPTransportUtils.createEnvelopeFromGetRequest(requestURI, requestParameters, configurationContext);
        if (envelope == null) {
            return false;
        }
        msgContext.setDoingREST(true);
        msgContext.setEnvelope(envelope);
        AxisEngine.receive(msgContext);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Handler.InvocationResponse processHTTPPostRequest(MessageContext msgContext, InputStream in, OutputStream out, String contentType, String soapActionHeader, String requestURI) throws AxisFault {
        Handler.InvocationResponse invocationResponse;
        int soapVersion = 0;
        try {
            try {
                soapVersion = HTTPTransportUtils.initializeMessageContext(msgContext, soapActionHeader, requestURI, contentType);
                msgContext.setProperty("TRANSPORT_OUT", out);
                msgContext.setEnvelope(TransportUtils.createSOAPMessage(msgContext, HTTPTransportUtils.handleGZip(msgContext, in), contentType));
                invocationResponse = AxisEngine.receive(msgContext);
                Object var9_14 = null;
                if (msgContext.getEnvelope() != null) return invocationResponse;
                if (soapVersion == 1) return invocationResponse;
            }
            catch (SOAPProcessingException e) {
                throw AxisFault.makeFault(e);
            }
            catch (AxisFault e) {
                throw e;
            }
            catch (IOException e) {
                throw AxisFault.makeFault(e);
            }
            catch (OMException e) {
                throw AxisFault.makeFault(e);
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault(e);
            }
            catch (FactoryConfigurationError e) {
                throw AxisFault.makeFault(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (msgContext.getEnvelope() != null) throw throwable;
            if (soapVersion == 1) throw throwable;
            msgContext.setEnvelope(new SOAP12Factory().getDefaultEnvelope());
            throw throwable;
        }
        msgContext.setEnvelope(new SOAP12Factory().getDefaultEnvelope());
        return invocationResponse;
    }

    public static int initializeMessageContext(MessageContext msgContext, String soapActionHeader, String requestURI, String contentType) {
        int soapVersion = 0;
        if (soapActionHeader != null && soapActionHeader.length() > 0 && soapActionHeader.charAt(0) == '\"' && soapActionHeader.endsWith("\"")) {
            soapActionHeader = soapActionHeader.substring(1, soapActionHeader.length() - 1);
        }
        msgContext.setSoapAction(soapActionHeader);
        msgContext.setTo(new EndpointReference(requestURI));
        msgContext.setServerSide(true);
        String charSetEnc = BuilderUtil.getCharSetEncoding(contentType);
        if (charSetEnc == null) {
            charSetEnc = "UTF-8";
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
        if (contentType != null) {
            if (contentType.indexOf("application/soap+xml") > -1) {
                soapVersion = 2;
                TransportUtils.processContentTypeForAction(contentType, msgContext);
            } else if (contentType.indexOf("text/xml") > -1) {
                soapVersion = 1;
            } else if (HTTPTransportUtils.isRESTRequest(contentType)) {
                soapVersion = 1;
                msgContext.setDoingREST(true);
            }
            if (soapVersion == 1) {
                Parameter enableREST = msgContext.getParameter("enableREST");
                if (soapActionHeader == null && enableREST != null && "true".equals(enableREST.getValue())) {
                    msgContext.setDoingREST(true);
                }
            }
        }
        return soapVersion;
    }

    public static InputStream handleGZip(MessageContext msgContext, InputStream in) throws IOException {
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers != null && ("gzip".equals(headers.get("Content-Encoding")) || "gzip".equals(headers.get(HTTPConstants.HEADER_CONTENT_ENCODING_LOWERCASE)))) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static boolean isDoingREST(MessageContext msgContext) {
        boolean enableREST = false;
        if (msgContext.isDoingREST()) {
            return true;
        }
        Object enableRESTProperty = msgContext.getProperty("enableREST");
        if (enableRESTProperty != null) {
            enableREST = JavaUtils.isTrueExplicitly(enableRESTProperty);
        }
        msgContext.setDoingREST(enableREST);
        return enableREST;
    }

    public static boolean isRESTRequest(String contentType) {
        if (contentType == null) {
            return false;
        }
        return contentType.indexOf("application/xml") > -1 || contentType.indexOf("application/x-www-form-urlencoded") > -1 || contentType.indexOf("multipart/form-data") > -1;
    }
}

