/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.SOAPMessageFormatter;
import org.apache.axis2.transport.jms.AxisJMSException;
import org.apache.axis2.transport.jms.JMSOutTransportInfo;
import org.apache.axis2.transport.jms.JMSUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSSender
extends AbstractHandler
implements TransportSender {
    private static final Log log = LogFactory.getLog(JMSSender.class);
    public static final String TRANSPORT_NAME = "jms";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        boolean waitForResponse;
        log.debug((Object)"JMSSender invoke()");
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        JMSOutTransportInfo transportInfo = null;
        String targetAddress = null;
        targetAddress = (String)msgContext.getProperty("TransportURL");
        if (targetAddress != null) {
            transportInfo = new JMSOutTransportInfo(targetAddress);
        } else if (targetAddress == null && msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            targetAddress = msgContext.getTo().getAddress();
            if (msgContext.getTo().hasNoneAddress()) return Handler.InvocationResponse.CONTINUE;
            transportInfo = new JMSOutTransportInfo(targetAddress);
        } else if (msgContext.isServerSide()) {
            transportInfo = (JMSOutTransportInfo)msgContext.getProperty("OutTransportInfo");
        }
        ConnectionFactory connectionFac = transportInfo.getConnectionFactory();
        Connection con = null;
        String user = transportInfo.getConnectionFactoryUser();
        String password = transportInfo.getConnectionFactoryPassword();
        con = user == null || password == null ? connectionFac.createConnection() : connectionFac.createConnection(user, password);
        Session session = con.createSession(false, 1);
        Message message = this.createJMSMessage(msgContext, session);
        Destination dest = transportInfo.getDestination();
        if (dest == null) {
            if (targetAddress != null) {
                String name = JMSUtils.getDestination(targetAddress);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Creating JMS Destination : " + name));
                }
                try {
                    dest = session.createQueue(name);
                }
                catch (JMSException e) {
                    JMSSender.handleException("Error creating destination Queue : " + name, (Exception)((Object)e));
                }
            } else {
                JMSSender.handleException("Cannot send reply to unknown JMS Destination");
            }
        }
        MessageProducer producer = session.createProducer(dest);
        TemporaryQueue replyDest = null;
        boolean bl = waitForResponse = msgContext.getOperationContext() != null && "http://www.w3.org/ns/wsdl/out-in".equals(msgContext.getOperationContext().getAxisOperation().getMessageExchangePattern());
        if (waitForResponse) {
            String replyToJNDIName = (String)msgContext.getProperty("transport.jms.ReplyDestination");
            if (replyToJNDIName != null && replyToJNDIName.length() > 0) {
                Context context = null;
                final Hashtable props = JMSUtils.getProperties(targetAddress);
                try {
                    try {
                        context = (Context)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws NamingException {
                                return new InitialContext(props);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (NamingException)e.getException();
                    }
                }
                catch (NamingException e) {
                    JMSSender.handleException("Could not get the initial context", e);
                }
                try {
                    replyDest = (Destination)context.lookup(replyToJNDIName);
                }
                catch (NameNotFoundException e) {
                    log.warn((Object)("Cannot get or lookup JMS response destination : " + replyToJNDIName + " : " + e.getMessage() + ". Attempting to create a Queue named : " + replyToJNDIName));
                    replyDest = session.createQueue(replyToJNDIName);
                }
                catch (NamingException e) {
                    JMSSender.handleException("Cannot get JMS response destination : " + replyToJNDIName + " : ", e);
                }
            } else {
                try {
                    replyDest = session.createTemporaryQueue();
                }
                catch (JMSException e) {
                    JMSSender.handleException("Error creating temporary queue for response");
                }
            }
            message.setJMSReplyTo((Destination)replyDest);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Expecting a response to JMS Destination : " + (replyDest instanceof Queue ? ((Queue)replyDest).getQueueName() : ((Topic)replyDest).getTopicName())));
            }
        }
        try {
            log.debug((Object)("[" + (msgContext.isServerSide() ? "Server" : "Client") + "]Sending message to destination : " + dest));
            producer.send(message);
            producer.close();
        }
        catch (JMSException e) {
            JMSSender.handleException("Error sending JMS message to destination : " + dest.toString(), (Exception)((Object)e));
        }
        if (waitForResponse) {
            try {
                MessageConsumer consumer = session.createConsumer((Destination)replyDest);
                long timeout = 30000L;
                Long waitReply = (Long)msgContext.getProperty("JMS_WAIT_REPLY");
                if (waitReply != null) {
                    timeout = waitReply;
                }
                log.debug((Object)("Waiting for a maximum of " + timeout + "ms for a response message to destination : " + replyDest));
                con.start();
                Message reply = consumer.receive(timeout);
                if (reply != null) {
                    msgContext.setProperty("TRANSPORT_IN", JMSUtils.getInputStream(reply));
                } else {
                    log.warn((Object)("Did not receive a JMS response within " + timeout + " ms to destination : " + dest));
                }
            }
            catch (JMSException e) {
                JMSSender.handleException("Error reading response from temporary queue : " + replyDest, (Exception)((Object)e));
            }
        }
        Object var20_29 = null;
        if (con == null) return Handler.InvocationResponse.CONTINUE;
        try {
            con.close();
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (JMSException e2) {}
        return Handler.InvocationResponse.CONTINUE;
        {
            catch (JMSException e) {
                JMSSender.handleException("Error preparing to send message to destination", (Exception)((Object)e));
                Object var20_30 = null;
                if (con == null) return Handler.InvocationResponse.CONTINUE;
                try {
                    con.close();
                    return Handler.InvocationResponse.CONTINUE;
                }
                catch (JMSException e2) {}
                return Handler.InvocationResponse.CONTINUE;
            }
        }
        catch (Throwable throwable) {
            Object var20_31 = null;
            if (con == null) throw throwable;
            try {
                con.close();
                throw throwable;
            }
            catch (JMSException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }

    private Message createJMSMessage(MessageContext msgContext, Session session) throws JMSException {
        TextMessage message = null;
        String msgType = this.getProperty(msgContext, "JMS_MESSAGE_TYPE");
        SOAPEnvelope msgElement = msgContext.getEnvelope();
        if (msgContext.isDoingREST()) {
            msgElement = msgContext.getEnvelope().getBody().getFirstElement();
        }
        if (msgType != null && "JMS_BYTE_MESSAGE".equals(msgType)) {
            message = session.createBytesMessage();
            BytesMessage bytesMsg = (BytesMessage)message;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OMOutputFormat format = new OMOutputFormat();
            format.setSOAP11(msgContext.isSOAP11());
            format.setCharSetEncoding(this.getProperty(msgContext, "CHARACTER_SET_ENCODING"));
            format.setDoOptimize(msgContext.isDoingMTOM());
            try {
                msgElement.serializeAndConsume((OutputStream)baos, format);
                baos.flush();
            }
            catch (XMLStreamException e) {
                JMSSender.handleException("XML serialization error creating BytesMessage", e);
            }
            catch (IOException e) {
                JMSSender.handleException("IO Error while creating BytesMessage", e);
            }
            bytesMsg.writeBytes(baos.toByteArray());
            bytesMsg.setStringProperty("contentType", new SOAPMessageFormatter().getContentType(msgContext, format, null));
        } else {
            TextMessage txtMsg = message = session.createTextMessage();
            txtMsg.setText(msgElement.toString());
        }
        String correlationId = this.getProperty(msgContext, "JMS_COORELATION_ID");
        if (correlationId == null && msgContext.getRelatesTo() != null) {
            correlationId = msgContext.getRelatesTo().getValue();
        }
        if (correlationId != null) {
            message.setJMSCorrelationID(correlationId);
        }
        if (msgContext.isServerSide()) {
            this.setProperty((Message)message, msgContext, "SOAPAction");
            this.setProperty((Message)message, msgContext, "contentType");
        } else {
            String action = msgContext.getOptions().getAction();
            if (action != null) {
                message.setStringProperty("SOAPAction", action);
            }
        }
        return message;
    }

    private void setProperty(Message message, MessageContext msgCtx, String key) {
        String value = this.getProperty(msgCtx, key);
        if (value != null) {
            try {
                message.setStringProperty(key, value);
            }
            catch (JMSException e) {
                log.warn((Object)("Couldn't set message property : " + key + " = " + value), (Throwable)e);
            }
        }
    }

    private String getProperty(MessageContext mc, String key) {
        return (String)mc.getProperty(key);
    }

    private static void handleException(String s) {
        log.error((Object)s);
        throw new AxisJMSException(s);
    }

    private static void handleException(String s, Exception e) {
        log.error((Object)s, (Throwable)e);
        throw new AxisJMSException(s, e);
    }
}

