/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.IOException;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailClient
extends Authenticator {
    public static final int SHOW_MESSAGES = 1;
    public static final int CLEAR_MESSAGES = 2;
    public static final int SHOW_AND_CLEAR = 3;
    private static final Log log = LogFactory.getLog(MailClient.class);
    protected PasswordAuthentication authentication;
    protected String from;
    protected Session session;

    public MailClient(String user, String host) {
        this(user, host, user, false);
    }

    public MailClient(String user, String host, String password) {
        this(user, host, password, false);
    }

    public MailClient(String user, String host, String password, boolean debug) {
        this.from = user + '@' + host;
        this.authentication = new PasswordAuthentication(user, password);
        Properties props = new Properties();
        props.put("mail.user", user);
        props.put("mail.host", host);
        props.put("mail.debug", debug ? "true" : "false");
        props.put("mail.store.protocol", "pop3");
        props.put("mail.transport.protocol", "smtp");
        this.session = Session.getInstance((Properties)props, (Authenticator)this);
    }

    public int checkInbox(int mode) throws MessagingException, IOException {
        int numMessages = 0;
        if (mode == 0) {
            return 0;
        }
        boolean show = (mode & 1) > 0;
        boolean clear = (mode & 2) > 0;
        String action = (show ? "Show" : "") + (show && clear ? " and " : "") + (clear ? "Clear" : "");
        log.info((Object)(action + " INBOX for " + this.from));
        Store store = this.session.getStore();
        store.connect();
        Folder root = store.getDefaultFolder();
        Folder inbox = root.getFolder("inbox");
        inbox.open(2);
        Message[] msgs = inbox.getMessages();
        numMessages = msgs.length;
        if (msgs.length == 0 && show) {
            log.info((Object)"No messages in inbox");
        }
        for (int i = 0; i < msgs.length; ++i) {
            MimeMessage msg = (MimeMessage)msgs[i];
            if (show) {
                log.info((Object)("    From: " + msg.getFrom()[0]));
                log.info((Object)(" Subject: " + msg.getSubject()));
                log.info((Object)(" Content: " + msg.getContent()));
            }
            if (!clear) continue;
            msg.setFlag(Flags.Flag.DELETED, true);
        }
        inbox.close(true);
        store.close();
        return numMessages;
    }

    public void sendMessage(String to, String subject, String content, String soapAction) throws MessagingException {
        log.info((Object)("SENDING message from " + this.from + " to " + to));
        MimeMessage msg = new MimeMessage(this.session);
        msg.setHeader("transport.mail.soapaction", soapAction);
        msg.addRecipients(Message.RecipientType.TO, to);
        msg.setSubject(subject);
        msg.setText(content);
        Transport.send((Message)msg);
    }

    public PasswordAuthentication getPasswordAuthentication() {
        return this.authentication;
    }
}

