/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail.server;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.mail.server.POP3Server;
import org.apache.axis2.transport.mail.server.SMTPServer;
import org.apache.axis2.transport.mail.server.Storage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailServer {
    private static final Log log = LogFactory.getLog(MailServer.class);
    Storage st = null;
    public ConfigurationContext configurationContext = null;
    private POP3Server pop3Server;
    private SMTPServer smtpServer;

    public MailServer(int popPort, int smtpPort) throws AxisFault {
        this.st = new Storage();
        this.smtpServer = new SMTPServer(this.st, smtpPort);
        this.smtpServer.start();
        this.pop3Server = new POP3Server(this.st, popPort);
        this.pop3Server.start();
        try {
            log.info((Object)"Sleeping for a bit to let the mail server start up.");
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    public MailServer(ConfigurationContext configurationContext, int popPort, int smtpPort) throws AxisFault {
        this.configurationContext = configurationContext;
        this.st = new Storage();
        this.smtpServer = new SMTPServer(this.st, configurationContext, smtpPort);
        this.smtpServer.start();
        this.pop3Server = new POP3Server(this.st, popPort);
        this.pop3Server.start();
        try {
            log.info((Object)"Sleeping for a bit to let the mail server start up.");
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            log.error((Object)e1);
        }
    }

    public MailServer(String dir, int popPort, int smtpPort) throws AxisFault {
        try {
            this.configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(dir, null);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            log.info((Object)"Sleeping for a bit to let the engine start up.");
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
        this.st = new Storage();
        this.smtpServer = new SMTPServer(this.st, this.configurationContext, smtpPort);
        this.smtpServer.start();
        this.pop3Server = new POP3Server(this.st, popPort);
        this.pop3Server.start();
        try {
            log.info((Object)"Sleeping for a bit to let the engine start up.");
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    public static void main(String[] args) {
        int smtpPost = 1049;
        int popPort = 1134;
        if (args.length == 2) {
            try {
                smtpPost = Integer.parseInt(args[0]);
                popPort = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e1) {
                log.info((Object)"Error in parsing the custom ports.");
            }
        } else {
            log.info((Object)"Usage MailServer <SMTP_PORT> <POP_PORT>");
            log.info((Object)"Using 1134 as the SMTP port and 1049 as the POP port");
        }
        try {
            new MailServer(popPort, smtpPost);
        }
        catch (AxisFault e) {
            log.info((Object)e.getMessage());
        }
    }

    public void stop() throws AxisFault {
        this.smtpServer.stopServer();
        this.pop3Server.stopServer();
        try {
            log.info((Object)"Giving some time for the sockets to close.");
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            log.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }
}

