/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail.server;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.mail.server.Storage;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailSorter {
    private static final Log log = LogFactory.getLog(MailSorter.class);
    Storage st = null;
    private ArrayList sUsers = new ArrayList();
    private ConfigurationContext configurationContext = null;
    private boolean actAsMailet = false;

    public MailSorter(Storage st, ConfigurationContext configurationContext) {
        this.st = st;
        this.sUsers.add("axis2-server@localhost");
        this.sUsers.add("axis2-server@127.0.0.1");
        if (configurationContext == null) {
            this.actAsMailet = false;
        } else {
            this.configurationContext = configurationContext;
            this.actAsMailet = true;
        }
    }

    public void processMail(ConfigurationContext confContext, MimeMessage mimeMessage) {
        AxisEngine engine = new AxisEngine(confContext);
        MessageContext msgContext = null;
        try {
            String recepainets;
            String replyTo;
            msgContext = confContext.createMessageContext();
            msgContext.setTransportIn(confContext.getAxisConfiguration().getTransportIn("mailto"));
            msgContext.setTransportOut(confContext.getAxisConfiguration().getTransportOut("mailto"));
            msgContext.setServerSide(true);
            msgContext.setProperty("mail.contenttype", mimeMessage.getContentType());
            msgContext.setProperty("CHARACTER_SET_ENCODING", mimeMessage.getEncoding());
            String soapAction = this.getMailHeader("mail.soapaction", mimeMessage);
            if (soapAction == null) {
                soapAction = mimeMessage.getSubject();
            }
            msgContext.setSoapAction(soapAction);
            msgContext.setIncomingTransportName("mailto");
            String serviceURL = mimeMessage.getSubject();
            if (serviceURL == null) {
                serviceURL = "";
            }
            if ((replyTo = ((InternetAddress)mimeMessage.getReplyTo()[0]).getAddress()) != null) {
                msgContext.setReplyTo(new EndpointReference(replyTo));
            }
            if ((recepainets = ((InternetAddress)mimeMessage.getAllRecipients()[0]).getAddress()) != null) {
                msgContext.setTo(new EndpointReference(recepainets + "/" + serviceURL));
            }
            String message = mimeMessage.getContent().toString();
            log.info((Object)("message[" + message + "]"));
            ByteArrayInputStream bais = new ByteArrayInputStream(message.getBytes());
            String soapNamespaceURI = "";
            if (mimeMessage.getContentType().indexOf("application/soap+xml") > -1) {
                soapNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
            } else if (mimeMessage.getContentType().indexOf("text/xml") > -1) {
                soapNamespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
            }
            StAXBuilder builder = BuilderUtil.getSOAPBuilder(bais, soapNamespaceURI);
            SOAPEnvelope envelope = (SOAPEnvelope)builder.getDocumentElement();
            msgContext.setEnvelope(envelope);
            AxisEngine.receive(msgContext);
        }
        catch (Exception e) {
            try {
                if (msgContext != null) {
                    MessageContext faultContext = MessageContextBuilder.createFaultMessageContext(msgContext, e);
                    AxisEngine.sendFault(faultContext);
                }
            }
            catch (Exception e1) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void sort(String user, MimeMessage msg) {
        if (this.actAsMailet) {
            if (this.sUsers.contains(user)) {
                this.processMail(this.configurationContext, msg);
            } else {
                this.st.addMail(user, msg);
            }
        } else {
            this.st.addMail(user, msg);
        }
    }

    private String getMailHeader(String headerName, MimeMessage mimeMessage) throws AxisFault {
        try {
            String[] values = mimeMessage.getHeader(headerName);
            if (values != null) {
                return values[0];
            }
            return null;
        }
        catch (MessagingException e) {
            throw new AxisFault(e.getMessage(), e);
        }
    }
}

