/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.axis2.transport.mail.server.Storage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class POP3Worker
extends Thread {
    private static final Log log = LogFactory.getLog(POP3Worker.class);
    boolean doneProcess = false;
    int numDeleted = 0;
    ArrayList messages = new ArrayList();
    private Socket socket;
    private Storage st;

    public POP3Worker(Socket socket, Storage st) {
        this.socket = socket;
        this.st = st;
    }

    private void processInput(String input, PrintWriter printWriter) {
        block32: {
            byte[] CR_LF_DOT_CR_LF = new byte[]{13, 10, 46, 13, 10};
            String user = "";
            if (input == null) {
                this.doneProcess = true;
            } else {
                ArrayList<String> tokens = new ArrayList<String>();
                StringTokenizer stk = new StringTokenizer(input);
                while (stk.hasMoreTokens()) {
                    tokens.add(stk.nextToken());
                }
                if (tokens.get(0).equals("USER")) {
                    user = (String)tokens.get(1);
                    this.messages = this.st.popUserMails(user);
                    printWriter.println("+OK ");
                } else if (tokens.get(0).equals("PASS")) {
                    printWriter.println("+OK ");
                } else if (input.equals("QUIT")) {
                    printWriter.println("+OK POP3 server signing off");
                    this.doneProcess = true;
                } else if (input.equals("STAT")) {
                    printWriter.println("+OK " + this.messages.size() + " 1");
                } else if (tokens.get(0).equals("LIST")) {
                    if (tokens.size() > 1) {
                        try {
                            int optArg = Integer.parseInt((String)tokens.get(1));
                            int messageArrayIndex = optArg - 1;
                            if (messageArrayIndex < this.messages.size() && messageArrayIndex >= 0) {
                                printWriter.println("+OK " + messageArrayIndex + 1 + " 120");
                                break block32;
                            }
                            printWriter.println("-ERR no such message, only " + (this.messages.size() + 1) + " messages in maildrop");
                        }
                        catch (NumberFormatException e) {
                            log.info((Object)e.getMessage());
                            printWriter.println("-ERR problem passing the index. Index submited was " + tokens.get(1));
                        }
                    } else {
                        printWriter.println("+OK " + this.messages.size());
                        for (int i = 0; i < this.messages.size(); ++i) {
                            int messageIndex = i + 1;
                            printWriter.println(messageIndex + " 120");
                        }
                        printWriter.println(".");
                    }
                } else if (tokens.get(0).equals("RETR")) {
                    String i = (String)tokens.get(1);
                    try {
                        int index = Integer.parseInt(i);
                        printWriter.println("+OK ");
                        MimeMessage m = (MimeMessage)this.messages.get(index - 1);
                        m.writeTo(this.socket.getOutputStream());
                        this.socket.getOutputStream().write(CR_LF_DOT_CR_LF);
                        this.socket.getOutputStream().flush();
                    }
                    catch (NumberFormatException e) {
                        printWriter.println("-ERR ");
                    }
                    catch (IOException e1) {
                        printWriter.println("-ERR ");
                    }
                    catch (MessagingException e2) {
                        printWriter.println("-ERR ");
                    }
                } else if (tokens.get(0).equals("DELE")) {
                    String smIndex = (String)tokens.get(1);
                    try {
                        int mIndex = Integer.parseInt(smIndex) - 1 - this.numDeleted;
                        if (mIndex >= 0 && mIndex < this.messages.size()) {
                            this.messages.remove(mIndex);
                            ++this.numDeleted;
                            printWriter.println("+OK ");
                            break block32;
                        }
                        printWriter.println("-ERR ");
                    }
                    catch (NumberFormatException e) {
                        printWriter.println("-ERR ");
                    }
                } else if (tokens.get(0).equals("NOOP") || tokens.get(0).equals("RSET")) {
                    printWriter.println("+OK ");
                } else {
                    printWriter.println("-ERR ");
                }
            }
        }
    }

    public void run() {
        try {
            InputStream inputStream = this.socket.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            PrintWriter printWriter = new PrintWriter(this.socket.getOutputStream(), true);
            printWriter.println("+OK  POP3 server ready");
            while (!this.doneProcess) {
                String s = bufferedReader.readLine();
                this.processInput(s, printWriter);
            }
            this.socket.close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

