/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class ClientWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(ClientWorker.class);
    private MessageContext responseMsgCtx = null;
    private InputStream in = null;
    private HttpResponse response = null;

    public ClientWorker(ConfigurationContext cfgCtx, InputStream in, HttpResponse response, MessageContext outMsgCtx) {
        this.in = in;
        this.response = response;
        try {
            this.responseMsgCtx = outMsgCtx.getOperationContext().getMessageContext("In");
        }
        catch (AxisFault af) {
            log.error((Object)"Error getting IN message context from the operation context", (Throwable)af);
            return;
        }
        if (this.responseMsgCtx == null && outMsgCtx.getOperationContext().isComplete()) {
            log.debug((Object)"Error getting IN message context from the operation context. Possibly an RM terminate sequence message");
            return;
        }
        if (this.responseMsgCtx == null) {
            this.responseMsgCtx = new MessageContext();
            this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        }
        this.responseMsgCtx.setServerSide(true);
        this.responseMsgCtx.setDoingREST(outMsgCtx.isDoingREST());
        this.responseMsgCtx.setProperty("TRANSPORT_IN", outMsgCtx.getProperty("TRANSPORT_IN"));
        this.responseMsgCtx.setTransportIn(outMsgCtx.getTransportIn());
        this.responseMsgCtx.setTransportOut(outMsgCtx.getTransportOut());
        Header[] headers = response.getAllHeaders();
        if (headers != null && headers.length > 0) {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (int i = 0; i < headers.length; ++i) {
                Header header = headers[i];
                headerMap.put(header.getName(), header.getValue());
            }
            this.responseMsgCtx.setProperty("TRANSPORT_HEADERS", headerMap);
        }
        this.responseMsgCtx.setAxisMessage(outMsgCtx.getOperationContext().getAxisOperation().getMessage("In"));
        this.responseMsgCtx.setOperationContext(outMsgCtx.getOperationContext());
        this.responseMsgCtx.setConfigurationContext(outMsgCtx.getConfigurationContext());
        this.responseMsgCtx.setTo(null);
    }

    public void run() {
        if (this.responseMsgCtx == null) {
            return;
        }
        SOAPEnvelope envelope = null;
        try {
            String contentType = this.response.getFirstHeader("Content-Type").getValue();
            String charSetEnc = BuilderUtil.getCharSetEncoding(contentType);
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            if (contentType.indexOf("; charset=") > 0) {
                this.responseMsgCtx.setProperty("CHARACTER_SET_ENCODING", charSetEnc);
            } else {
                this.responseMsgCtx.setProperty("CHARACTER_SET_ENCODING", "UTF-8");
            }
            this.responseMsgCtx.setServerSide(false);
            envelope = TransportUtils.createSOAPMessage(this.responseMsgCtx, this.in, contentType);
            this.responseMsgCtx.setServerSide(true);
            this.responseMsgCtx.setEnvelope(envelope);
        }
        catch (AxisFault af) {
            log.error((Object)"Fault creating response SOAP envelope", (Throwable)af);
            return;
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error creating response SOAP envelope", (Throwable)e);
        }
        try {
            AxisEngine.receive(this.responseMsgCtx);
        }
        catch (AxisFault af) {
            log.error((Object)"Fault processing response message through Axis2", (Throwable)af);
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

