/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.nio.NHttpClientConnection;

public class ConnectionPool {
    private static final Log log = LogFactory.getLog(ConnectionPool.class);
    private static Map connMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NHttpClientConnection getConnection(String host, int port) {
        String key = host + ":" + Integer.toString(port);
        List connections = (List)connMap.get(key);
        if (connections == null || connections.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No connections available for reuse");
            }
            return null;
        }
        NHttpClientConnection conn = null;
        List list = connections;
        synchronized (list) {
            while (!connections.isEmpty()) {
                conn = (NHttpClientConnection)connections.remove(0);
                if (conn.isOpen()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("A connection to host : " + host + " on port : " + port + " is available in the pool, and will be reused"));
                    }
                    return conn;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"closing stale connection");
                }
                try {
                    conn.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(NHttpClientConnection conn) {
        HttpHost host = (HttpHost)conn.getContext().getAttribute("http.target_host");
        String key = host.getHostName() + ":" + Integer.toString(host.getPort());
        List<NHttpClientConnection> connections = (List<NHttpClientConnection>)connMap.get(key);
        if (connections == null) {
            Map map = connMap;
            synchronized (map) {
                connections = (List)connMap.get(key);
                if (connections == null) {
                    connections = Collections.synchronizedList(new LinkedList());
                    connMap.put(key, connections);
                }
            }
        }
        connections.add(conn);
        log.debug((Object)("Released a connection to host: " + host.getHostName() + " on port : " + host.getPort() + " to the connection pool of current size : " + connections.size()));
    }
}

