/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.nhttp.HttpCoreNIOListener;
import org.apache.axis2.transport.nhttp.SSLServerIOEventDispatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.nio.reactor.SSLIOSessionHandler;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.params.HttpParams;

public class HttpCoreNIOSSLListener
extends HttpCoreNIOListener {
    private static final Log log = LogFactory.getLog(HttpCoreNIOSSLListener.class);

    protected IOEventDispatch getEventDispatch(NHttpServiceHandler handler, SSLContext sslContext, SSLIOSessionHandler sslIOSessionHandler, HttpParams params) {
        return new SSLServerIOEventDispatch(handler, sslContext, sslIOSessionHandler, params);
    }

    protected String getServiceEPRPrefix(ConfigurationContext cfgCtx, String host, int port) {
        return "https://" + host + (port == 443 ? "" : ":" + port) + (!cfgCtx.getServiceContextPath().startsWith("/") ? "/" : "") + cfgCtx.getServiceContextPath() + (!cfgCtx.getServiceContextPath().endsWith("/") ? "/" : "");
    }

    protected SSLContext getSSLContext(TransportInDescription transportIn) throws AxisFault {
        String storePassword;
        String type;
        String location;
        KeyManager[] keymanagers = null;
        TrustManager[] trustManagers = null;
        Parameter keyParam = transportIn.getParameter("keystore");
        Parameter trustParam = transportIn.getParameter("truststore");
        if (keyParam != null) {
            OMElement ksEle = keyParam.getParameterElement().getFirstElement();
            location = ksEle.getFirstChildWithName(new QName("Location")).getText();
            type = ksEle.getFirstChildWithName(new QName("Type")).getText();
            storePassword = ksEle.getFirstChildWithName(new QName("Password")).getText();
            String keyPassword = ksEle.getFirstChildWithName(new QName("KeyPassword")).getText();
            try {
                KeyStore keyStore = KeyStore.getInstance(type);
                URL url = this.getClass().getClassLoader().getResource(location);
                log.debug((Object)("Loading Key Store from URL : " + url));
                keyStore.load(url.openStream(), storePassword.toCharArray());
                KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmfactory.init(keyStore, keyPassword.toCharArray());
                keymanagers = kmfactory.getKeyManagers();
            }
            catch (GeneralSecurityException gse) {
                log.error((Object)("Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, gse);
            }
            catch (IOException ioe) {
                log.error((Object)("Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, ioe);
            }
        }
        if (trustParam != null) {
            OMElement tsEle = trustParam.getParameterElement().getFirstElement();
            location = tsEle.getFirstChildWithName(new QName("Location")).getText();
            type = tsEle.getFirstChildWithName(new QName("Type")).getText();
            storePassword = tsEle.getFirstChildWithName(new QName("Password")).getText();
            try {
                KeyStore trustStore = KeyStore.getInstance(type);
                URL url = this.getClass().getClassLoader().getResource(location);
                log.debug((Object)("Loading Trust Key Store from URL : " + url));
                trustStore.load(url.openStream(), storePassword.toCharArray());
                TrustManagerFactory trustManagerfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerfactory.init(trustStore);
                trustManagers = trustManagerfactory.getTrustManagers();
            }
            catch (GeneralSecurityException gse) {
                log.error((Object)("Error loading Key store : " + location), (Throwable)gse);
                throw new AxisFault("Error loading Key store : " + location, gse);
            }
            catch (IOException ioe) {
                log.error((Object)("Error opening Key store : " + location), (Throwable)ioe);
                throw new AxisFault("Error opening Key store : " + location, ioe);
            }
        }
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(keymanagers, trustManagers, null);
            return sslcontext;
        }
        catch (GeneralSecurityException gse) {
            log.error((Object)"Unable to create SSL context with the given configuration", (Throwable)gse);
            throw new AxisFault("Unable to create SSL context with the given configuration", gse);
        }
    }

    protected SSLIOSessionHandler getSSLIOSessionHandler(TransportInDescription transportIn) throws AxisFault {
        final Parameter clientAuth = transportIn.getParameter("SSLVerifyClient");
        return new SSLIOSessionHandler(){

            public void initalize(SSLEngine sslengine, HttpParams params) {
                if (clientAuth != null) {
                    if ("optional".equals(clientAuth.getValue())) {
                        sslengine.setWantClientAuth(true);
                    } else if ("require".equals(clientAuth.getValue())) {
                        sslengine.setNeedClientAuth(true);
                    }
                }
            }

            public void verify(SocketAddress removeAddress, SSLSession session) throws SSLException {
            }
        };
    }
}

