/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp.util;

import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PipeImpl {
    private static final Log log;
    private ReadableByteChannel source;
    private WritableByteChannel sink;
    private PipedOutputStream pipedOut;
    protected static boolean useNative;

    public PipeImpl() throws IOException {
        if (useNative) {
            Pipe pipe = Pipe.open();
            this.source = pipe.source();
            this.sink = pipe.sink();
        } else {
            PipedInputStream pipedIn = new PipedInputStream();
            try {
                this.pipedOut = new PipedOutputStream(pipedIn);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.source = Channels.newChannel(pipedIn);
            this.sink = Channels.newChannel(this.pipedOut);
        }
    }

    public ReadableByteChannel source() {
        return this.source;
    }

    public WritableByteChannel sink() {
        return this.sink;
    }

    static {
        String option;
        log = LogFactory.getLog(PipeImpl.class);
        if ("/".equals(File.separator)) {
            useNative = true;
        }
        if ((option = System.getProperty("native_pipes")) != null) {
            if ("true".equals(option)) {
                useNative = true;
            } else if ("false".equals(option)) {
                useNative = false;
            }
        }
        if (useNative) {
            log.info((Object)"Using native OS Pipes for event-driven to stream IO bridging");
        } else {
            log.info((Object)"Using simulated buffered Pipes for event-driven to stream IO bridging");
        }
    }
}

