/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.xmpp.util.XMPPConnectionFactory;
import org.apache.axis2.transport.xmpp.util.XMPPPacketListener;
import org.apache.axis2.transport.xmpp.util.XMPPServerCredentials;
import org.apache.axis2.util.threadpool.DefaultThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.XMPPConnection;

public class XMPPListener
implements TransportListener {
    private static Log log = LogFactory.getLog(XMPPListener.class);
    private ConfigurationContext configurationContext = null;
    private String replyTo = "";
    private Map connectionFactories = new HashMap();
    private ExecutorService workerPool;
    private static final int WORKERS_MAX_THREADS = 5;
    private static final long WORKER_KEEP_ALIVE = 60L;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private XMPPConnection xmppConnection = null;

    public void init(ConfigurationContext configurationCtx, TransportInDescription transportIn) throws AxisFault {
        log.info((Object)"Initializing XMPPListener...");
        this.configurationContext = configurationCtx;
        this.initializeConnectionFactories(this.configurationContext, transportIn);
        if (this.connectionFactories.isEmpty()) {
            log.warn((Object)"No XMPP connection factories defined.Will not listen for any XMPP messages");
            return;
        }
    }

    private void initializeConnectionFactories(ConfigurationContext configurationContext, TransportInDescription transportIn) throws AxisFault {
        for (Parameter connection : transportIn.getParameters()) {
            log.info((Object)("Trying to establish connection for : " + connection.getName()));
            ParameterIncludeImpl pi = new ParameterIncludeImpl();
            try {
                pi.deserializeParameters((OMElement)connection.getValue());
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error reading parameters");
            }
            Iterator params = pi.getParameters().iterator();
            XMPPServerCredentials serverCredentials = new XMPPServerCredentials();
            while (params.hasNext()) {
                Parameter param = (Parameter)params.next();
                if ("transport.xmpp.ServerUrl".equals(param.getName())) {
                    serverCredentials.setServerUrl((String)param.getValue());
                    continue;
                }
                if ("transport.xmpp.ServerAccountUserName".equals(param.getName())) {
                    serverCredentials.setAccountName((String)param.getValue());
                    continue;
                }
                if ("transport.xmpp.ServerAccountPassword".equals(param.getName())) {
                    serverCredentials.setPassword((String)param.getValue());
                    continue;
                }
                if (!"transport.xmpp.ServerType".equals(param.getName())) continue;
                serverCredentials.setServerType((String)param.getValue());
            }
            XMPPConnectionFactory xmppConnectionFactory = new XMPPConnectionFactory();
            xmppConnectionFactory.connect(serverCredentials);
            this.connectionFactories.put(serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl(), xmppConnectionFactory);
        }
    }

    public void stop() {
        if (!this.workerPool.isShutdown()) {
            this.workerPool.shutdown();
        }
    }

    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        return new EndpointReference[]{new EndpointReference("xmpp://" + this.replyTo + "?" + this.configurationContext.getServiceContextPath() + "/" + serviceName)};
    }

    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public void destroy() {
        if (this.xmppConnection != null && this.xmppConnection.isConnected()) {
            this.xmppConnection.disconnect();
        }
    }

    public void start() throws AxisFault {
        ThreadPoolExecutor workerPool = new ThreadPoolExecutor(1, 5, 60L, TIME_UNIT, (BlockingQueue)new LinkedBlockingQueue(), (ThreadFactory)new DefaultThreadFactory(new ThreadGroup("XMPP Worker thread group"), "XMPPWorker"));
        for (XMPPConnectionFactory connectionFactory : this.connectionFactories.values()) {
            XMPPPacketListener xmppPacketListener = new XMPPPacketListener(connectionFactory, this.configurationContext, (Executor)workerPool);
            connectionFactory.listen(xmppPacketListener);
        }
    }
}

