/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.dataretrieval.AxisDataLocator;
import org.apache.axis2.dataretrieval.AxisDataLocatorImpl;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.dataretrieval.LocatorType;
import org.apache.axis2.dataretrieval.OutputForm;
import org.apache.axis2.dataretrieval.SchemaSupplier;
import org.apache.axis2.dataretrieval.WSDLSupplier;
import org.apache.axis2.deployment.util.ExcludeInfo;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService2WSDL20;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.MessageContextListener;
import org.apache.axis2.description.ModuleConfiguration;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.WSDL11ToAxisServiceBuilder;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.axis2.description.java2wsdl.DocLitBareSchemaGenerator;
import org.apache.axis2.description.java2wsdl.SchemaGenerator;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.DefaultObjectSupplier;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.ObjectSupplier;
import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jsr181.JSR181Helper;
import org.apache.axis2.jsr181.WebMethodAnnotation;
import org.apache.axis2.phaseresolver.PhaseResolver;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.util.IOUtils;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.XMLPrettyPrinter;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AxisService
extends AxisDescription {
    public static final String SUPPORT_SINGLE_OP = "supportSingleOperation";
    public static final String IMPORT_TAG = "import";
    public static final String INCLUDE_TAG = "include";
    public static final String SCHEMA_LOCATION = "schemaLocation";
    private Map<String, AxisEndpoint> endpointMap = new HashMap<String, AxisEndpoint>();
    private Map<QName, AxisOperation> messageElementQNameToOperationMap = new HashMap<QName, AxisOperation>();
    private int nsCount = 0;
    private static final Log log = LogFactory.getLog(AxisService.class);
    private URL fileName;
    private HashMap<String, AxisOperation> httpLocationDispatcherMap = null;
    private HashMap<String, AxisOperation> operationsAliasesMap = null;
    private List<String> invalidOperationsAliases = null;
    private ArrayList<String> moduleRefs = null;
    private long lastupdate;
    private HashMap<String, ModuleConfiguration> moduleConfigmap;
    private String name;
    private ClassLoader serviceClassLoader;
    private ArrayList<XmlSchema> schemaList;
    private boolean wsdlFound = false;
    private String scope = "request";
    private HashMap<String, MessageReceiver> messageReceivers;
    private boolean useDefaultChains = true;
    private boolean active = true;
    private boolean elementFormDefault = true;
    private String targetNamespace = "http://ws.apache.org/axis2";
    private String targetNamespacePrefix = "tns";
    private String schematargetNamespace;
    private String schematargetNamespacePrefix = "ns";
    private boolean enableAllTransports = true;
    private List<String> exposedTransports = new ArrayList<String>();
    private ServiceLifeCycle serviceLifeCycle;
    private boolean schemaLocationsAdjusted = false;
    private boolean wsdlImportLocationAdjusted = false;
    private Map schemaMappingTable = null;
    private int count = 0;
    private String customSchemaNamePrefix = null;
    private String customSchemaNameSuffix = null;
    private NamespaceMap namespaceMap;
    private String soapNsUri;
    private String endpointName;
    private String endpointURL;
    private List importedNamespaces;
    private boolean clientSide = false;
    private ObjectSupplier objectSupplier;
    private Map p2nMap;
    private ExcludeInfo excludeInfo;
    private TypeTable typeTable;
    private HashMap dataLocators;
    private HashMap<String, String> dataLocatorClassNames;
    private AxisDataLocatorImpl defaultDataLocator;
    LocatorType[] availableDataLocatorTypes = new LocatorType[]{LocatorType.SERVICE_DIALECT, LocatorType.SERVICE_LEVEL, LocatorType.GLOBAL_DIALECT, LocatorType.GLOBAL_LEVEL, LocatorType.DEFAULT_AXIS};
    private String bindingName;
    private CopyOnWriteArrayList<MessageContextListener> messageContextListeners = new CopyOnWriteArrayList();
    private List operationsNameList;
    private String[] eprs;
    private boolean customWsdl = false;
    private HashMap policyMap = new HashMap();

    public AxisEndpoint getEndpoint(String key) {
        return this.endpointMap.get(key);
    }

    public void addEndpoint(String key, AxisEndpoint axisEndpoint) {
        this.endpointMap.put(key, axisEndpoint);
    }

    public String getWSAddressingFlag() {
        return AddressingHelper.getAddressingRequirementParemeterValue(this);
    }

    public void setWSAddressingFlag(String ar) {
        AddressingHelper.setAddressingRequirementParemeterValue(this, ar);
    }

    public boolean isSchemaLocationsAdjusted() {
        return this.schemaLocationsAdjusted;
    }

    public void setSchemaLocationsAdjusted(boolean schemaLocationsAdjusted) {
        this.schemaLocationsAdjusted = schemaLocationsAdjusted;
    }

    public Map getSchemaMappingTable() {
        return this.schemaMappingTable;
    }

    public void setSchemaMappingTable(Map schemaMappingTable) {
        this.schemaMappingTable = schemaMappingTable;
    }

    public String getCustomSchemaNamePrefix() {
        return this.customSchemaNamePrefix;
    }

    public void setCustomSchemaNamePrefix(String customSchemaNamePrefix) {
        this.customSchemaNamePrefix = customSchemaNamePrefix;
    }

    public String getCustomSchemaNameSuffix() {
        return this.customSchemaNameSuffix;
    }

    public void setCustomSchemaNameSuffix(String customSchemaNameSuffix) {
        this.customSchemaNameSuffix = customSchemaNameSuffix;
    }

    public AxisService() {
        this.operationsAliasesMap = new HashMap();
        this.invalidOperationsAliases = new ArrayList<String>();
        this.moduleConfigmap = new HashMap();
        this.httpLocationDispatcherMap = new HashMap();
        this.messageReceivers = new HashMap();
        this.moduleRefs = new ArrayList();
        this.schemaList = new ArrayList();
        this.serviceClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.objectSupplier = new DefaultObjectSupplier();
        this.dataLocators = new HashMap();
        this.dataLocatorClassNames = new HashMap();
    }

    public String getPortTypeName() {
        return this.endpointName;
    }

    public void setPortTypeName(String portTypeName) {
        this.endpointName = portTypeName;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getSoapNsUri() {
        return this.soapNsUri;
    }

    public void setSoapNsUri(String soapNsUri) {
        this.soapNsUri = soapNsUri;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(String endpoint) {
        this.endpointName = endpoint;
    }

    public AxisService(String name) {
        this();
        this.name = name;
    }

    public void addMessageReceiver(String mepURI, MessageReceiver messageReceiver) {
        if ("http://www.w3.org/ns/wsdl/in-only".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/in-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/in-only".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/in-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/in-only", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/out-only".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/out-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/out-only".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/out-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/out-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/out-only", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/in-out".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/in-out".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/in-out".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-out", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/in-out", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/in-out", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/in-opt-out".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/in-opt-out".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-opt-out", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/in-opt-out", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/in-opt-out", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/out-in".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/out-in".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/out-in".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/out-in", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/out-in", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/out-in", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/out-opt-in".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/out-opt-in".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/out-opt-in".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/out-opt-in", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/out-opt-in", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/out-opt-in", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/robust-out-only".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/robust-out-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/robust-out-only".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/robust-out-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/robust-out-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/robust-out-only", messageReceiver);
        } else if ("http://www.w3.org/ns/wsdl/robust-in-only".equals(mepURI) || "http://www.w3.org/2006/01/wsdl/robust-in-only".equals(mepURI) || "http://www.w3.org/2004/08/wsdl/robust-in-only".equals(mepURI)) {
            this.messageReceivers.put("http://www.w3.org/ns/wsdl/robust-in-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2006/01/wsdl/robust-in-only", messageReceiver);
            this.messageReceivers.put("http://www.w3.org/2004/08/wsdl/robust-in-only", messageReceiver);
        } else {
            this.messageReceivers.put(mepURI, messageReceiver);
        }
    }

    public MessageReceiver getMessageReceiver(String mepURL) {
        return this.messageReceivers.get(mepURL);
    }

    public void addModuleConfig(ModuleConfiguration moduleConfiguration) {
        this.moduleConfigmap.put(moduleConfiguration.getModuleName(), moduleConfiguration);
    }

    void addModuleOperations(AxisModule module) throws AxisFault {
        HashMap<QName, AxisOperation> map = module.getOperations();
        Collection<AxisOperation> col = map.values();
        PhaseResolver phaseResolver = new PhaseResolver(this.getAxisConfiguration());
        Iterator<AxisOperation> iterator = col.iterator();
        while (iterator.hasNext()) {
            AxisOperation axisOperation = this.copyOperation(iterator.next());
            if (this.getOperation(axisOperation.getName()) != null) continue;
            ArrayList<String> wsamappings = axisOperation.getWSAMappingList();
            if (wsamappings != null) {
                int size = wsamappings.size();
                for (int j = 0; j < size; ++j) {
                    String mapping = wsamappings.get(j);
                    AxisOperation mappedOperation = this.getOperationByAction(mapping);
                    if (mappedOperation != null && axisOperation.isParameterTrue("allowOverride")) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("addModuleOperations: Mapping already exists for action: " + mapping + " to operation: " + axisOperation + " named: " + axisOperation.getName() + " and an override is allowed, so the module mapping for module: " + module.getName() + " is being ignored."));
                        log.debug((Object)JavaUtils.callStackToString());
                        continue;
                    }
                    this.mapActionToOperation(mapping, axisOperation);
                }
            }
            if (axisOperation.isParameterTrue("expose")) {
                axisOperation.setControlOperation(false);
            } else {
                axisOperation.setControlOperation(true);
            }
            phaseResolver.engageModuleToOperation(axisOperation, module);
            this.addOperation(axisOperation);
        }
    }

    public void addModuleref(String moduleref) {
        this.moduleRefs.add(moduleref);
    }

    public void addOperation(AxisOperation axisOperation) {
        ArrayList<String> wsamappings;
        axisOperation.setParent(this);
        if (log.isDebugEnabled() && (axisOperation.getName().equals(ServiceClient.ANON_OUT_ONLY_OP) || axisOperation.getName().equals(ServiceClient.ANON_OUT_ONLY_OP) || axisOperation.getName().equals(ServiceClient.ANON_OUT_ONLY_OP))) {
            log.debug((Object)("Client-defined operation name matches default operation name. this may cause interoperability issues.  Name is: " + axisOperation.getName().toString()));
        }
        for (AxisModule module : this.getEngagedModules()) {
            try {
                axisOperation.engageModule(module);
            }
            catch (AxisFault axisFault) {
                log.info((Object)Messages.getMessage("modulealredyengagetoservice", module.getName()));
            }
        }
        if (axisOperation.getMessageReceiver() == null) {
            axisOperation.setMessageReceiver(this.loadDefaultMessageReceiver(axisOperation.getMessageExchangePattern(), this));
        }
        if (axisOperation.getInputAction() == null) {
            axisOperation.setSoapAction("urn:" + axisOperation.getName().getLocalPart());
        }
        if (axisOperation.getOutputAction() == null) {
            axisOperation.setOutputAction("urn:" + axisOperation.getName().getLocalPart() + "Response");
        }
        this.addChild(axisOperation);
        String operationName = axisOperation.getName().getLocalPart();
        Iterator<? extends AxisDescription> axisMessageIter = axisOperation.getChildren();
        while (axisMessageIter.hasNext()) {
            AxisMessage axisMessage = (AxisMessage)axisMessageIter.next();
            String messageName = axisMessage.getName();
            if (messageName == null || messageName.equals(operationName)) continue;
            this.mapActionToOperation(messageName, axisOperation);
        }
        this.mapActionToOperation(operationName, axisOperation);
        String action = axisOperation.getInputAction();
        if (action.length() > 0) {
            this.mapActionToOperation(action, axisOperation);
        }
        if ((wsamappings = axisOperation.getWSAMappingList()) != null) {
            int size = wsamappings.size();
            for (int j = 0; j < size; ++j) {
                String mapping = wsamappings.get(j);
                this.mapActionToOperation(mapping, axisOperation);
            }
        }
        if (axisOperation.getMessageReceiver() == null) {
            axisOperation.setMessageReceiver(this.loadDefaultMessageReceiver(axisOperation.getMessageExchangePattern(), this));
        }
    }

    private MessageReceiver loadDefaultMessageReceiver(String mepURL, AxisService service) {
        MessageReceiver messageReceiver;
        if (mepURL == null) {
            mepURL = "http://www.w3.org/ns/wsdl/in-out";
        }
        if (service != null && (messageReceiver = service.getMessageReceiver(mepURL)) != null) {
            return messageReceiver;
        }
        if (this.getAxisConfiguration() != null) {
            return this.getAxisConfiguration().getMessageReceiver(mepURL);
        }
        return null;
    }

    private AxisOperation copyOperation(AxisOperation axisOperation) throws AxisFault {
        Policy policy;
        AxisOperation operation = AxisOperationFactory.getOperationDescription(axisOperation.getMessageExchangePattern());
        operation.setMessageReceiver(axisOperation.getMessageReceiver());
        operation.setName(axisOperation.getName());
        for (Parameter parameter : axisOperation.getParameters()) {
            operation.addParameter(parameter);
        }
        PolicyInclude policyInclude = new PolicyInclude(operation);
        PolicyInclude axisOperationPolicyInclude = axisOperation.getPolicyInclude();
        if (axisOperationPolicyInclude != null && (policy = axisOperationPolicyInclude.getPolicy()) != null) {
            policyInclude.setPolicy(axisOperationPolicyInclude.getPolicy());
        }
        operation.setPolicyInclude(policyInclude);
        operation.setWsamappingList(axisOperation.getWSAMappingList());
        operation.setRemainingPhasesInFlow(axisOperation.getRemainingPhasesInFlow());
        operation.setPhasesInFaultFlow(axisOperation.getPhasesInFaultFlow());
        operation.setPhasesOutFaultFlow(axisOperation.getPhasesOutFaultFlow());
        operation.setPhasesOutFlow(axisOperation.getPhasesOutFlow());
        operation.setOutputAction(axisOperation.getOutputAction());
        String[] faultActionNames = axisOperation.getFaultActionNames();
        for (int i = 0; i < faultActionNames.length; ++i) {
            operation.addFaultAction(faultActionNames[i], axisOperation.getFaultAction(faultActionNames[i]));
        }
        return operation;
    }

    @Override
    public void onEngage(AxisModule axisModule, AxisDescription engager) throws AxisFault {
        this.addModuleOperations(axisModule);
        Iterator<AxisOperation> operations = this.getOperations();
        while (operations.hasNext()) {
            AxisOperation axisOperation = operations.next();
            axisOperation.engageModule(axisModule, engager);
        }
    }

    public void mapActionToOperation(String action, AxisOperation axisOperation) {
        AxisOperation mappedOperation;
        if (action == null || "".equals(action)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"mapActionToOperation: A null or empty action cannot be used to map to an operation.");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("mapActionToOperation: Mapping Action to Operation: action: " + action + "; operation: " + axisOperation + "named: " + axisOperation.getName()));
            log.debug((Object)JavaUtils.callStackToString());
        }
        if ((mappedOperation = this.getOperationByAction(action)) != null && axisOperation.isParameterTrue("allowOverride")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addModuleOperations: Mapping already exists for action: " + action + " to operation: " + axisOperation + " named: " + axisOperation.getName() + " and an override is allowed, so the mapping is being ignored."));
                log.debug((Object)JavaUtils.callStackToString());
            }
            return;
        }
        if (this.invalidOperationsAliases.contains(action)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("mapActionToOperation: The action: " + action + " can not be used for operation: " + axisOperation + " with operation name: " + axisOperation.getName() + " because that SOAPAction is not unique for this service."));
            }
            return;
        }
        AxisOperation currentlyMappedOperation = this.getOperationByAction(action);
        if (currentlyMappedOperation != null) {
            if (currentlyMappedOperation == axisOperation) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("mapActionToOperation: This operation is already mapped to this action: " + action + "; AxisOperation: " + currentlyMappedOperation + " named: " + currentlyMappedOperation.getName()));
                }
            } else {
                this.operationsAliasesMap.remove(action);
                this.invalidOperationsAliases.add(action);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("mapActionToOperation: The action is already mapped to a different operation.  The mapping of the action to any operations will be removed.  Action: " + action + "; original operation: " + currentlyMappedOperation + " named " + currentlyMappedOperation.getName() + "; new operation: " + axisOperation + " named " + axisOperation.getName()));
                }
            }
        } else {
            this.operationsAliasesMap.put(action, axisOperation);
        }
    }

    public void addHttpLocationDispatcherString(String string, AxisOperation axisOperation) {
        this.httpLocationDispatcherMap.put(string, axisOperation);
    }

    public void printSchema(OutputStream out) throws AxisFault {
        for (int i = 0; i < this.schemaList.size(); ++i) {
            XmlSchema schema = this.addNameSpaces(i);
            schema.write(out);
        }
    }

    public XmlSchema getSchema(int index) {
        return this.addNameSpaces(index);
    }

    public void releaseSchemaList() {
        if (this.schemaList != null) {
            this.schemaList.clear();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"releaseSchemaList: schema list has been released.");
        }
    }

    private XmlSchema addNameSpaces(int i) {
        XmlSchema schema = this.schemaList.get(i);
        NamespaceMap map = (NamespaceMap)this.namespaceMap.clone();
        NamespacePrefixList namespaceContext = schema.getNamespaceContext();
        String[] prefixes = namespaceContext.getDeclaredPrefixes();
        for (int j = 0; j < prefixes.length; ++j) {
            String prefix = prefixes[j];
            map.add(prefix, namespaceContext.getNamespaceURI(prefix));
        }
        schema.setNamespaceContext((NamespacePrefixList)map);
        return schema;
    }

    public void setEPRs(String[] eprs) {
        this.eprs = eprs;
    }

    public String[] getEPRs() {
        if (this.eprs != null && this.eprs.length != 0) {
            return this.eprs;
        }
        this.eprs = this.calculateEPRs();
        return this.eprs;
    }

    private String[] calculateEPRs() {
        try {
            String requestIP = Utils.getIpAddress(this.getAxisConfiguration());
            return this.calculateEPRs(requestIP);
        }
        catch (SocketException e) {
            log.error((Object)"Cannot get local IP address", (Throwable)e);
            return new String[0];
        }
    }

    private String[] calculateEPRs(String requestIP) {
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        if (axisConfig == null) {
            return null;
        }
        ArrayList<String> eprList = new ArrayList<String>();
        if (this.enableAllTransports) {
            for (TransportInDescription transportIn : axisConfig.getTransportsIn().values()) {
                TransportListener listener = transportIn.getReceiver();
                if (listener == null) continue;
                try {
                    EndpointReference[] eprsForService = listener.getEPRsForService(this.name, requestIP);
                    if (eprsForService == null) continue;
                    for (int i = 0; i < eprsForService.length; ++i) {
                        String address;
                        EndpointReference endpointReference = eprsForService[i];
                        if (endpointReference == null || (address = endpointReference.getAddress()) == null) continue;
                        eprList.add(address);
                    }
                }
                catch (AxisFault axisFault) {
                    log.warn((Object)axisFault.getMessage());
                }
            }
        } else {
            List<String> trs = this.exposedTransports;
            for (int i = 0; i < trs.size(); ++i) {
                TransportListener listener;
                String trsName = trs.get(i);
                TransportInDescription transportIn = axisConfig.getTransportIn(trsName);
                if (transportIn == null || (listener = transportIn.getReceiver()) == null) continue;
                try {
                    EndpointReference[] eprsForService = listener.getEPRsForService(this.name, requestIP);
                    if (eprsForService == null) continue;
                    for (int j = 0; j < eprsForService.length; ++j) {
                        String address;
                        EndpointReference endpointReference = eprsForService[j];
                        if (endpointReference == null || (address = endpointReference.getAddress()) == null) continue;
                        eprList.add(address);
                    }
                    continue;
                }
                catch (AxisFault axisFault) {
                    log.warn((Object)axisFault.getMessage());
                }
            }
        }
        this.eprs = eprList.toArray(new String[eprList.size()]);
        return this.eprs;
    }

    private synchronized void printDefinitionObject(Definition definition, OutputStream out, String requestIP) throws AxisFault, WSDLException {
        if (this.isModifyUserWSDLPortAddress()) {
            this.setPortAddress(definition, requestIP);
        }
        if (!this.wsdlImportLocationAdjusted) {
            this.changeImportAndIncludeLocations(definition);
            this.wsdlImportLocationAdjusted = true;
        }
        WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
        writer.writeWSDL(definition, out);
    }

    public void printUserWSDL(OutputStream out, String wsdlName) throws AxisFault {
        this.printUserWSDL(out, wsdlName, null);
    }

    public void printUserWSDL(OutputStream out, String wsdlName, String ip) throws AxisFault {
        Definition definition = null;
        Parameter wsdlParameter = this.getParameter("wsdl4jDefinition");
        if (wsdlParameter != null) {
            definition = (Definition)wsdlParameter.getValue();
        }
        if (definition != null) {
            try {
                this.printDefinitionObject(this.getWSDLDefinition(definition, wsdlName), out, ip);
            }
            catch (WSDLException e) {
                throw AxisFault.makeFault(e);
            }
        } else {
            this.printWSDLError(out);
        }
    }

    private Definition getWSDLDefinition(Definition parentDefinition, String name) {
        if (name == null) {
            return parentDefinition;
        }
        Definition importedDefinition = null;
        Iterator iter = parentDefinition.getImports().values().iterator();
        Vector values = null;
        Import wsdlImport2 = null;
        while (iter.hasNext()) {
            values = (Vector)iter.next();
            for (Import wsdlImport2 : values) {
                if (wsdlImport2.getLocationURI().endsWith(name)) {
                    importedDefinition = wsdlImport2.getDefinition();
                    break;
                }
                importedDefinition = this.getWSDLDefinition(wsdlImport2.getDefinition(), name);
                if (importedDefinition == null) continue;
            }
            if (importedDefinition == null) continue;
            break;
        }
        return importedDefinition;
    }

    private void changeImportAndIncludeLocations(Definition definition) throws AxisFault {
        Types types = definition.getTypes();
        if (types != null) {
            List extensibilityElements = types.getExtensibilityElements();
            Object extensibilityElement2 = null;
            Schema schema = null;
            for (Object extensibilityElement2 : extensibilityElements) {
                if (!(extensibilityElement2 instanceof Schema)) continue;
                schema = extensibilityElement2;
                this.changeLocations(schema.getElement());
            }
        }
        Iterator iter = definition.getImports().values().iterator();
        Vector values = null;
        Import wsdlImport2 = null;
        String originalImprotString = null;
        while (iter.hasNext()) {
            values = (Vector)iter.next();
            for (Import wsdlImport2 : values) {
                originalImprotString = wsdlImport2.getLocationURI();
                if (originalImprotString.indexOf("://") == -1 && originalImprotString.indexOf("?wsdl=") == -1) {
                    wsdlImport2.setLocationURI(this.getServiceEPR() + "?wsdl=" + originalImprotString);
                }
                this.changeImportAndIncludeLocations(wsdlImport2.getDefinition());
            }
        }
    }

    private void changeLocations(Element element) throws AxisFault {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String tagName = nodeList.item(i).getLocalName();
            if (!IMPORT_TAG.equals(tagName) && !INCLUDE_TAG.equals(tagName)) continue;
            this.processImport(nodeList.item(i));
        }
    }

    private void updateSchemaLocation(XmlSchema schema) throws AxisFault {
        XmlSchemaObjectCollection includes = schema.getIncludes();
        for (int j = 0; j < includes.getCount(); ++j) {
            XmlSchemaObject item = includes.getItem(j);
            if (!(item instanceof XmlSchemaExternal)) continue;
            XmlSchemaExternal xmlSchemaExternal = (XmlSchemaExternal)item;
            XmlSchema s = xmlSchemaExternal.getSchema();
            this.updateSchemaLocation(s, xmlSchemaExternal);
        }
    }

    private void updateSchemaLocation(XmlSchema s, XmlSchemaExternal xmlSchemaExternal) throws AxisFault {
        String schemaLocation;
        if (s != null && (schemaLocation = xmlSchemaExternal.getSchemaLocation()).indexOf("://") == -1 && schemaLocation.indexOf("?xsd=") == -1) {
            String newscheamlocation = this.getServiceEPR() + "?xsd=" + schemaLocation;
            xmlSchemaExternal.setSchemaLocation(newscheamlocation);
        }
    }

    private void processImport(Node importNode) throws AxisFault {
        NamedNodeMap nodeMap = importNode.getAttributes();
        for (int i = 0; i < nodeMap.getLength(); ++i) {
            Node attribute = nodeMap.item(i);
            if (!attribute.getNodeName().equals(SCHEMA_LOCATION)) continue;
            String attributeValue = attribute.getNodeValue();
            if (this.getParameter("customSchemaNamePrefix") != null) {
                String customSchemaNamePrefix = this.getParameter("customSchemaNamePrefix").getValue().toString();
                URL customUrl = null;
                try {
                    URL base = new URL(customSchemaNamePrefix);
                    customUrl = new URL(base, attributeValue);
                }
                catch (MalformedURLException e) {
                    log.error((Object)("Malformed schema URL: " + customUrl), (Throwable)e);
                    throw AxisFault.makeFault(e);
                }
                attribute.setNodeValue(customUrl.toString());
                continue;
            }
            if (attributeValue.indexOf("://") != -1 || attributeValue.indexOf("?xsd=") != -1) continue;
            attribute.setNodeValue(this.getServiceEPR() + "?xsd=" + attributeValue);
        }
    }

    private String getServiceEPR() {
        String serviceEPR = null;
        boolean fromServiceName = false;
        Parameter parameter = this.getParameter("generateAbsoluteLocationURIs");
        if (parameter != null && JavaUtils.isTrueExplicitly(parameter.getValue())) {
            String[] eprs = this.getEPRs();
            for (int i = 0; i < eprs.length; ++i) {
                if (eprs[i] == null || !eprs[i].startsWith("http:")) continue;
                serviceEPR = eprs[i];
                break;
            }
            if (serviceEPR == null) {
                serviceEPR = eprs[0];
            }
        } else {
            serviceEPR = this.name;
            fromServiceName = true;
        }
        if (serviceEPR.endsWith("/")) {
            serviceEPR = serviceEPR.substring(0, serviceEPR.lastIndexOf("/"));
        }
        if (fromServiceName && serviceEPR.indexOf(47) != -1) {
            serviceEPR = serviceEPR.substring(serviceEPR.lastIndexOf(47) + 1);
        }
        return serviceEPR;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int printXSD(OutputStream out, String xsd) throws IOException {
        XmlSchema schema;
        SchemaSupplier supplier = (SchemaSupplier)this.getParameterValue("SchemaSupplier");
        if (supplier != null && (schema = supplier.getSchema(this, xsd)) != null) {
            this.updateSchemaLocation(schema);
            schema.write((Writer)new OutputStreamWriter(out, "UTF8"));
            out.flush();
            return 1;
        }
        this.populateSchemaMappings();
        Map schemaMappingtable = this.getSchemaMappingTable();
        ArrayList<XmlSchema> schemas = this.getSchema();
        if (xsd != null && !"".equals(xsd)) {
            int dotIndex;
            XmlSchema schema2 = (XmlSchema)schemaMappingtable.get(xsd);
            if (schema2 == null && (dotIndex = xsd.indexOf(46)) > 0) {
                String schemaKey = xsd.substring(0, dotIndex);
                schema2 = (XmlSchema)schemaMappingtable.get(schemaKey);
            }
            if (schema2 != null) {
                schema2.write((Writer)new OutputStreamWriter(out, "UTF8"));
                out.flush();
                return 1;
            } else {
                if (!xsd.endsWith(".xsd") || xsd.indexOf("..") != -1) return -1;
                InputStream in = this.getClassLoader().getResourceAsStream("META-INF/" + xsd);
                if (in == null) return -1;
                IOUtils.copy(in, out, true);
            }
            return 1;
        } else {
            if (schemas.size() > 1) {
                return 0;
            }
            ArrayList<XmlSchema> list = this.getSchema();
            if (list.size() > 0) {
                XmlSchema schema3 = this.getSchema(0);
                if (schema3 == null) return 1;
                schema3.write((Writer)new OutputStreamWriter(out, "UTF8"));
                out.flush();
                return 1;
            } else {
                String xsdNotFound = "<error><description>Unable to access schema for this service</description></error>";
                out.write(xsdNotFound.getBytes());
                out.flush();
            }
        }
        return 1;
    }

    public void printWSDL(OutputStream out, String requestIP) throws AxisFault {
        String[] stringArray;
        if (this.isUseUserWSDL()) {
            this.printUserWSDL(out, null, requestIP);
            return;
        }
        WSDLSupplier supplier = (WSDLSupplier)this.getParameterValue("WSDLSupplier");
        if (supplier != null) {
            try {
                Definition definition = supplier.getWSDL(this);
                if (definition != null) {
                    this.changeImportAndIncludeLocations(definition);
                    this.printDefinitionObject(this.getWSDLDefinition(definition, null), out, requestIP);
                }
            }
            catch (Exception e) {
                this.printWSDLError(out, e);
            }
            return;
        }
        if (this.isSetEndpointsToAllUsedBindings()) {
            org.apache.axis2.deployment.util.Utils.setEndpointsToAllUsedBindings(this);
        }
        if (requestIP == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.endpointName;
        } else {
            stringArray = this.calculateEPRs(requestIP);
        }
        String[] eprArray = stringArray;
        this.getWSDL(out, eprArray);
    }

    public boolean isSetEndpointsToAllUsedBindings() {
        String value;
        Parameter parameter = this.getParameter("setEndpointsToAllUsedBindings");
        return parameter != null && "true".equals(value = (String)parameter.getValue());
    }

    public void printWSDL(OutputStream out) throws AxisFault {
        this.printWSDL(out, null);
    }

    private AxisEndpoint getAxisEndpoint(String port) {
        if (this.endpointMap.size() == 1 && this.endpointMap.containsKey(this.getEndpointName())) {
            return null;
        }
        return this.endpointMap.get(port);
    }

    private void setPortAddress(Definition definition, String requestIP) throws AxisFault {
        for (Service serviceElement : definition.getServices().values()) {
            for (Port port : serviceElement.getPorts().values()) {
                AxisEndpoint endpoint = this.getAxisEndpoint(port.getName());
                List list = port.getExtensibilityElements();
                for (int i = 0; i < list.size(); ++i) {
                    UnknownExtensibilityElement unknownExtensibilityElement;
                    Element element;
                    String exsistingAddress;
                    SOAPAddress soapAddress;
                    Object extensibilityEle = list.get(i);
                    if (extensibilityEle instanceof SOAPAddress) {
                        soapAddress = (SOAPAddress)extensibilityEle;
                        String existingAddress = soapAddress.getLocationURI();
                        if (existingAddress == null || existingAddress.equals("REPLACE_WITH_ACTUAL_URL")) {
                            if (endpoint != null) {
                                ((SOAPAddress)extensibilityEle).setLocationURI(endpoint.calculateEndpointURL(requestIP));
                                continue;
                            }
                            ((SOAPAddress)extensibilityEle).setLocationURI(this.getEPRs()[0]);
                            continue;
                        }
                        if (requestIP == null) {
                            if (endpoint != null) {
                                ((SOAPAddress)extensibilityEle).setLocationURI(endpoint.calculateEndpointURL());
                                continue;
                            }
                            ((SOAPAddress)extensibilityEle).setLocationURI(this.getLocationURI(this.getEPRs(), existingAddress));
                            continue;
                        }
                        if (endpoint != null) {
                            ((SOAPAddress)extensibilityEle).setLocationURI(endpoint.calculateEndpointURL(requestIP));
                            continue;
                        }
                        ((SOAPAddress)extensibilityEle).setLocationURI(this.getLocationURI(this.calculateEPRs(requestIP), existingAddress));
                        continue;
                    }
                    if (extensibilityEle instanceof SOAP12Address) {
                        soapAddress = (SOAP12Address)extensibilityEle;
                        exsistingAddress = soapAddress.getLocationURI();
                        if (requestIP == null) {
                            if (endpoint != null) {
                                ((SOAP12Address)extensibilityEle).setLocationURI(endpoint.calculateEndpointURL());
                                continue;
                            }
                            ((SOAP12Address)extensibilityEle).setLocationURI(this.getLocationURI(this.getEPRs(), exsistingAddress));
                            continue;
                        }
                        if (endpoint != null) {
                            ((SOAP12Address)extensibilityEle).setLocationURI(endpoint.calculateEndpointURL(requestIP));
                            continue;
                        }
                        ((SOAP12Address)extensibilityEle).setLocationURI(this.getLocationURI(this.calculateEPRs(requestIP), exsistingAddress));
                        continue;
                    }
                    if (extensibilityEle instanceof HTTPAddress) {
                        HTTPAddress httpAddress = (HTTPAddress)extensibilityEle;
                        exsistingAddress = httpAddress.getLocationURI();
                        if (requestIP == null) {
                            if (endpoint != null) {
                                ((HTTPAddress)extensibilityEle).setLocationURI(endpoint.calculateEndpointURL());
                                continue;
                            }
                            ((HTTPAddress)extensibilityEle).setLocationURI(this.getLocationURI(this.getEPRs(), exsistingAddress));
                            continue;
                        }
                        if (endpoint != null) {
                            ((HTTPAddress)extensibilityEle).setLocationURI(endpoint.calculateEndpointURL(requestIP));
                            continue;
                        }
                        ((HTTPAddress)extensibilityEle).setLocationURI(this.getLocationURI(this.calculateEPRs(requestIP), exsistingAddress));
                        continue;
                    }
                    if (!(extensibilityEle instanceof UnknownExtensibilityElement) || !"EndpointReference".equals((element = (unknownExtensibilityElement = (UnknownExtensibilityElement)extensibilityEle).getElement()).getLocalName())) continue;
                    NodeList nodeList = element.getChildNodes();
                    Node node = null;
                    Element currentElement = null;
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        node = nodeList.item(j);
                        if (!(node instanceof Element) || !"Address".equals((currentElement = (Element)node).getLocalName())) continue;
                        String exsistingAddress2 = currentElement.getTextContent();
                        if (requestIP == null) {
                            if (endpoint != null) {
                                currentElement.setTextContent(endpoint.calculateEndpointURL());
                                continue;
                            }
                            currentElement.setTextContent(this.getLocationURI(this.getEPRs(), exsistingAddress2));
                            continue;
                        }
                        if (endpoint != null) {
                            currentElement.setTextContent(endpoint.calculateEndpointURL(requestIP));
                            continue;
                        }
                        currentElement.setTextContent(this.getLocationURI(this.calculateEPRs(requestIP), exsistingAddress2));
                    }
                }
            }
        }
    }

    private String getLocationURI(String[] eprs, String epr) throws AxisFault {
        String returnIP = null;
        if (epr != null) {
            String existingProtocol = Utils.getURIScheme(epr);
            if (existingProtocol != null) {
                for (int i = 0; i < eprs.length; ++i) {
                    if (!existingProtocol.equals(Utils.getURIScheme(eprs[i]))) continue;
                    returnIP = eprs[i];
                    break;
                }
                if (returnIP != null) {
                    return returnIP;
                }
                throw new AxisFault("Server does not have an epr for the wsdl epr==>" + epr);
            }
            throw new AxisFault("invalid epr is given epr ==> " + epr);
        }
        throw new AxisFault("No epr is given in the wsdl port");
    }

    private void getWSDL(OutputStream out, String[] serviceURL) throws AxisFault {
        DataRetrievalRequest request = new DataRetrievalRequest();
        request.putDialect("http://schemas.xmlsoap.org/wsdl/");
        request.putOutputForm(OutputForm.INLINE_FORM);
        MessageContext context = new MessageContext();
        context.setAxisService(this);
        context.setTo(new EndpointReference(serviceURL[0]));
        Data[] result = this.getData(request, context);
        if (result != null && result.length > 0) {
            OMElement wsdlElement = (OMElement)result[0].getData();
            try {
                XMLPrettyPrinter.prettify(wsdlElement, out);
                out.flush();
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        }
    }

    private void printWSDLError(OutputStream out) throws AxisFault {
        this.printWSDLError(out, null);
    }

    private void printWSDLError(OutputStream out, Exception e) throws AxisFault {
        try {
            String wsdlntfound = "<error><description>Unable to generate WSDL 1.1 for this service</description><reason>If you wish Axis2 to automatically generate the WSDL 1.1, then please set useOriginalwsdl as false in your services.xml</reason>";
            out.write(wsdlntfound.getBytes());
            if (e != null) {
                PrintWriter pw = new PrintWriter(out);
                e.printStackTrace(pw);
                pw.flush();
            }
            out.write("</error>".getBytes());
            out.flush();
        }
        catch (IOException ex) {
            throw AxisFault.makeFault(ex);
        }
    }

    public void printWSDL2(OutputStream out) throws AxisFault {
        this.printWSDL2(out, null);
    }

    public void printWSDL2(OutputStream out, String requestIP) throws AxisFault {
        AxisService2WSDL20 axisService2WSDL2 = new AxisService2WSDL20(this);
        try {
            if (requestIP != null) {
                axisService2WSDL2.setEPRs(this.calculateEPRs(requestIP));
            }
            OMElement wsdlElement = axisService2WSDL2.generateOM();
            wsdlElement.serialize(out);
            out.flush();
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int printWSDL2(OutputStream out, String requestIP, String wsdl) throws IOException, AxisFault {
        if (wsdl != null && !"".equals(wsdl)) {
            if (!wsdl.endsWith(".wsdl") || wsdl.indexOf("..") != -1) return -1;
            InputStream in = this.getClassLoader().getResourceAsStream("META-INF/" + wsdl);
            if (in == null) return -1;
            IOUtils.copy(in, out, true);
            return 1;
        } else {
            this.printWSDL2(out, requestIP);
        }
        return 1;
    }

    public String getServiceDescription() {
        return this.getDocumentation();
    }

    public ClassLoader getClassLoader() {
        return this.serviceClassLoader;
    }

    public ArrayList<AxisOperation> getControlOperations() {
        Iterator<AxisOperation> op_itr = this.getOperations();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = op_itr.next();
            if (!operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public URL getFileName() {
        return this.fileName;
    }

    public long getLastupdate() {
        return this.lastupdate;
    }

    public long getLastUpdate() {
        return this.lastupdate;
    }

    public ModuleConfiguration getModuleConfig(String moduleName) {
        return this.moduleConfigmap.get(moduleName);
    }

    public ArrayList<String> getModules() {
        return this.moduleRefs;
    }

    public String getName() {
        return this.name;
    }

    public AxisOperation getOperation(QName operationName) {
        AxisOperation axisOperation;
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)("Get operation for " + operationName));
        }
        if ((axisOperation = (AxisOperation)this.getChild(operationName)) == null) {
            axisOperation = (AxisOperation)this.getChild(new QName(this.getTargetNamespace(), operationName.getLocalPart()));
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("Target namespace: " + this.getTargetNamespace()));
            }
        }
        if (axisOperation == null) {
            axisOperation = this.operationsAliasesMap.get(operationName.getLocalPart());
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("Operations aliases map: " + this.operationsAliasesMap));
            }
        }
        if (axisOperation == null) {
            List namespaces = this.getImportedNamespaces();
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("Imported namespaces: " + namespaces));
            }
            if (namespaces != null) {
                String namespace;
                Iterator iterator = namespaces.iterator();
                while (iterator.hasNext() && (axisOperation = (AxisOperation)this.getChild(new QName(namespace = (String)iterator.next(), operationName.getLocalPart()))) == null) {
                }
            }
        }
        if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
            log.debug((Object)("Found axis operation:  " + axisOperation));
        }
        return axisOperation;
    }

    public AxisOperation getOperationByAction(String action) {
        return this.operationsAliasesMap.get(action);
    }

    public AxisOperation getOperationBySOAPAction(String soapAction) {
        if (soapAction == null || soapAction.length() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getOperationBySOAPAction: " + soapAction + " is null or ''. Returning null."));
            }
            return null;
        }
        if (this.invalidOperationsAliases.contains(soapAction)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getOperationBySOAPAction: " + soapAction + " is an invalid operation alias. Returning null."));
            }
            return null;
        }
        AxisOperation operation = this.operationsAliasesMap.get(soapAction);
        if (operation != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getOperationBySOAPAction: Operation (" + operation + "," + operation.getName() + ") for soapAction: " + soapAction + " found in action map."));
            }
            return operation;
        }
        Iterator<? extends AxisDescription> children = this.getChildren();
        while (children.hasNext() && operation == null) {
            AxisOperation op = (AxisOperation)children.next();
            if (!op.getName().getLocalPart().equals(soapAction)) continue;
            operation = op;
        }
        if (operation != null && log.isDebugEnabled()) {
            log.debug((Object)("getOperationBySOAPAction: Operation (" + operation + "," + operation.getName() + ") for soapAction: " + soapAction + " found as child."));
        }
        return operation;
    }

    public Iterator<AxisOperation> getOperations() {
        return this.getChildren();
    }

    public ArrayList<AxisOperation> getPublishedOperations() {
        Iterator<AxisOperation> op_itr = this.getOperations();
        ArrayList<AxisOperation> operationList = new ArrayList<AxisOperation>();
        while (op_itr.hasNext()) {
            AxisOperation operation = op_itr.next();
            if (operation.isControlOperation()) continue;
            operationList.add(operation);
        }
        return operationList;
    }

    public void setServiceDescription(String documentation) {
        this.setDocumentation(documentation);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.serviceClassLoader = classLoader;
    }

    public void setFileName(URL fileName) {
        this.fileName = fileName;
    }

    public void setLastupdate() {
        this.lastupdate = new Date().getTime();
    }

    public void setLastUpdate() {
        this.lastupdate = new Date().getTime();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<XmlSchema> getSchema() {
        return this.schemaList;
    }

    public void addSchema(XmlSchema schema) {
        if (schema != null) {
            this.schemaList.add(schema);
            if (schema.getTargetNamespace() != null) {
                this.addSchemaNameSpace(schema);
            }
        }
    }

    public void addSchema(Collection<XmlSchema> schemas) {
        for (XmlSchema schema : schemas) {
            this.schemaList.add(schema);
            this.addSchemaNameSpace(schema);
        }
    }

    public boolean isWsdlFound() {
        return this.wsdlFound;
    }

    public void setWsdlFound(boolean wsdlFound) {
        this.wsdlFound = wsdlFound;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if ("application".equals(scope) || "transportsession".equals(scope) || "soapsession".equals(scope) || "request".equals(scope)) {
            this.scope = scope;
        }
    }

    public boolean isUseDefaultChains() {
        return this.useDefaultChains;
    }

    public void setUseDefaultChains(boolean useDefaultChains) {
        this.useDefaultChains = useDefaultChains;
    }

    @Override
    public Object getKey() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getSchematargetNamespace() {
        return this.schematargetNamespace;
    }

    public String getSchemaTargetNamespace() {
        return this.schematargetNamespace;
    }

    public void setSchemaTargetNamespace(String schematargetNamespace) {
        this.schematargetNamespace = schematargetNamespace;
    }

    public String getSchemaTargetNamespacePrefix() {
        return this.schematargetNamespacePrefix;
    }

    public void setSchematargetNamespacePrefix(String schematargetNamespacePrefix) {
        this.schematargetNamespacePrefix = schematargetNamespacePrefix;
    }

    public void setSchemaTargetNamespacePrefix(String schematargetNamespacePrefix) {
        this.schematargetNamespacePrefix = schematargetNamespacePrefix;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getTargetNamespacePrefix() {
        return this.targetNamespacePrefix;
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public XmlSchemaElement getSchemaElement(QName elementQName) {
        for (int i = 0; i < this.schemaList.size(); ++i) {
            XmlSchemaElement element;
            XmlSchema schema = this.schemaList.get(i);
            if (schema == null || (element = schema.getElementByName(elementQName)) == null) continue;
            return element;
        }
        return null;
    }

    public boolean isEnableAllTransports() {
        return this.enableAllTransports;
    }

    public void setEnableAllTransports(boolean enableAllTransports) {
        this.enableAllTransports = enableAllTransports;
        this.eprs = this.calculateEPRs();
    }

    public List<String> getExposedTransports() {
        return this.exposedTransports;
    }

    public void setExposedTransports(List transports) {
        this.enableAllTransports = false;
        this.exposedTransports = transports;
        this.eprs = null;
    }

    public void addExposedTransport(String transport) {
        this.enableAllTransports = false;
        if (!this.exposedTransports.contains(transport)) {
            this.exposedTransports.add(transport);
            try {
                this.eprs = this.calculateEPRs();
            }
            catch (Exception e) {
                this.eprs = null;
            }
        }
    }

    public void removeExposedTransport(String transport) {
        this.enableAllTransports = false;
        this.exposedTransports.remove(transport);
        try {
            this.eprs = this.calculateEPRs();
        }
        catch (Exception e) {
            this.eprs = null;
        }
    }

    public boolean isExposedTransport(String transport) {
        return this.exposedTransports.contains(transport);
    }

    @Override
    public void onDisengage(AxisModule module) throws AxisFault {
        this.removeModuleOperations(module);
        Iterator<? extends AxisDescription> operations = this.getChildren();
        while (operations.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)operations.next();
            axisOperation.disengageModule(module);
        }
        AxisConfiguration config = this.getAxisConfiguration();
        if (!config.isEngaged(module.getName())) {
            PhaseResolver phaseResolver = new PhaseResolver(config);
            phaseResolver.disengageModuleFromGlobalChains(module);
        }
    }

    private void removeModuleOperations(AxisModule module) {
        HashMap<QName, AxisOperation> moduleOperations = module.getOperations();
        if (moduleOperations != null) {
            for (AxisOperation operation : moduleOperations.values()) {
                this.removeOperation(operation.getName());
            }
        }
    }

    public static AxisService createClientSideAxisService(URL wsdlURL, QName wsdlServiceName, String portName, Options options) throws AxisFault {
        try {
            InputStream in = wsdlURL.openConnection().getInputStream();
            Document doc = XMLUtils.newDocument(in);
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.importDocuments", true);
            Definition wsdlDefinition = reader.readWSDL(AxisService.getBaseURI(wsdlURL.toString()), doc);
            if (wsdlDefinition != null) {
                wsdlDefinition.setDocumentBaseURI(AxisService.getDocumentURI(wsdlURL.toString()));
            }
            return AxisService.createClientSideAxisService(wsdlDefinition, wsdlServiceName, portName, options);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
        catch (WSDLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault(e);
        }
    }

    private static String getBaseURI(String currentURI) {
        try {
            File file = new File(currentURI);
            if (file.exists()) {
                return file.getCanonicalFile().getParentFile().toURI().toString();
            }
            String uriFragment = currentURI.substring(0, currentURI.lastIndexOf("/"));
            return uriFragment + (uriFragment.endsWith("/") ? "" : "/");
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getDocumentURI(String currentURI) {
        try {
            File file = new File(currentURI);
            return file.getCanonicalFile().toURI().toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static AxisService createClientSideAxisService(Definition wsdlDefinition, QName wsdlServiceName, String portName, Options options) throws AxisFault {
        WSDL11ToAxisServiceBuilder serviceBuilder = new WSDL11ToAxisServiceBuilder(wsdlDefinition, wsdlServiceName, portName);
        serviceBuilder.setServerSide(false);
        AxisService axisService = serviceBuilder.populateService();
        AxisEndpoint axisEndpoint = axisService.getEndpoints().get(axisService.getEndpointName());
        if (axisEndpoint != null) {
            options.setTo(new EndpointReference(axisEndpoint.getEndpointURL()));
            options.setSoapVersionURI((String)axisEndpoint.getBinding().getProperty("wsoap:version"));
        }
        return axisService;
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfig) throws AxisFault {
        try {
            HashMap<String, MessageReceiver> messageReciverMap = new HashMap<String, MessageReceiver>();
            Class inOnlyMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
            MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
            messageReciverMap.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
            Class inoutMessageReceiver = Loader.loadClass("org.apache.axis2.rpc.receivers.RPCMessageReceiver");
            MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
            messageReciverMap.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
            messageReciverMap.put("http://www.w3.org/ns/wsdl/robust-in-only", inOutmessageReceiver);
            return AxisService.createService(implClass, axisConfig, messageReciverMap, null, null, axisConfig.getSystemClassLoader());
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    public static AxisService createService(String implClass, AxisConfiguration axisConfiguration, Map messageReceiverClassMap, String targetNamespace, String schemaNamespace, ClassLoader loader) throws AxisFault {
        DefaultSchemaGenerator schemaGenerator;
        int index = implClass.lastIndexOf(".");
        String serviceName = index > 0 ? implClass.substring(index + 1, implClass.length()) : implClass;
        ArrayList<String> excludeOpeartion = new ArrayList<String>();
        AxisService service = new AxisService();
        service.setParent(axisConfiguration);
        service.setName(serviceName);
        try {
            Parameter generateBare = service.getParameter("doclitBare");
            schemaGenerator = generateBare != null && "true".equals(generateBare.getValue()) ? new DocLitBareSchemaGenerator(loader, implClass, schemaNamespace, "ns", service) : new DefaultSchemaGenerator(loader, implClass, schemaNamespace, "ns", service);
            schemaGenerator.setElementFormDefault("unqualified");
            org.apache.axis2.deployment.util.Utils.addExcludeMethods(excludeOpeartion);
            schemaGenerator.setExcludeMethods(excludeOpeartion);
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        return AxisService.createService(implClass, serviceName, axisConfiguration, messageReceiverClassMap, targetNamespace, loader, schemaGenerator, service);
    }

    public static AxisService createService(String implClass, String serviceName, AxisConfiguration axisConfiguration, Map<String, MessageReceiver> messageReceiverClassMap, String targetNamespace, ClassLoader loader, SchemaGenerator schemaGenerator, AxisService axisService) throws AxisFault {
        Parameter parameter = new Parameter("ServiceClass", implClass);
        OMElement paraElement = org.apache.axis2.deployment.util.Utils.getParameter("ServiceClass", implClass, false);
        parameter.setParameterElement(paraElement);
        axisService.setUseDefaultChains(false);
        axisService.addParameter(parameter);
        axisService.setName(serviceName);
        axisService.setClassLoader(loader);
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNamespaceMap(map);
        org.apache.axis2.deployment.util.Utils.processBeanPropertyExclude(axisService);
        axisService.setElementFormDefault(false);
        try {
            axisService.addSchema(schemaGenerator.generateSchema());
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        axisService.setSchemaTargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
        axisService.setTypeTable(schemaGenerator.getTypeTable());
        if (targetNamespace == null) {
            targetNamespace = schemaGenerator.getSchemaTargetNameSpace();
        }
        if (targetNamespace != null && !"".equals(targetNamespace)) {
            axisService.setTargetNamespace(targetNamespace);
        }
        Method[] method = schemaGenerator.getMethods();
        PhasesInfo pinfo = axisConfiguration.getPhasesInfo();
        for (int i = 0; i < method.length; ++i) {
            MessageReceiver mr;
            Method jmethod = method[i];
            String methodName = jmethod.getName();
            WebMethodAnnotation methodAnnon = JSR181Helper.INSTANCE.getWebMethodAnnotation(jmethod);
            if (methodAnnon != null && methodAnnon.getOperationName() != null) {
                methodName = methodAnnon.getOperationName();
            }
            AxisOperation operation = axisService.getOperation(new QName(methodName));
            String mep = operation.getMessageExchangePattern();
            if (messageReceiverClassMap != null) {
                if (messageReceiverClassMap.get(mep) != null) {
                    MessageReceiver obj = messageReceiverClassMap.get(mep);
                    if (obj instanceof MessageReceiver) {
                        mr = obj;
                        operation.setMessageReceiver(mr);
                    } else {
                        log.error((Object)"Object is not an instance of MessageReceiver, thus, default MessageReceiver has been set");
                        mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                        operation.setMessageReceiver(mr);
                    }
                } else {
                    log.error((Object)"Required MessageReceiver couldn't be found, thus, default MessageReceiver has been used");
                    mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                    operation.setMessageReceiver(mr);
                }
            } else {
                log.error((Object)"MessageRecevierClassMap couldn't be found, thus, default MessageReceiver has been used");
                mr = axisConfiguration.getMessageReceiver(operation.getMessageExchangePattern());
                operation.setMessageReceiver(mr);
            }
            pinfo.setOperationPhases(operation);
            axisService.addOperation(operation);
        }
        String endpointName = axisService.getEndpointName();
        if ((endpointName == null || endpointName.length() == 0) && axisService.getAxisConfiguration() != null) {
            org.apache.axis2.deployment.util.Utils.addEndpointsToService(axisService, axisService.getAxisConfiguration());
        }
        return axisService;
    }

    public void removeOperation(QName opName) {
        AxisOperation operation = this.getOperation(opName);
        if (operation != null) {
            this.removeChild(opName);
            ArrayList<String> mappingList = operation.getWSAMappingList();
            if (mappingList != null) {
                for (int i = 0; i < mappingList.size(); ++i) {
                    String actionMapping = mappingList.get(i);
                    this.operationsAliasesMap.remove(actionMapping);
                    this.invalidOperationsAliases.remove(actionMapping);
                }
            }
            this.operationsAliasesMap.remove(operation.getName().getLocalPart());
            this.invalidOperationsAliases.remove(operation.getName().getLocalPart());
        }
    }

    public Map<String, String> getNameSpacesMap() {
        return this.namespaceMap;
    }

    public Map getNamespaceMap() {
        return this.namespaceMap;
    }

    public List getImportedNamespaces() {
        return this.importedNamespaces;
    }

    public void setImportedNamespaces(List importedNamespaces) {
        this.importedNamespaces = importedNamespaces;
    }

    public void setNameSpacesMap(NamespaceMap nameSpacesMap) {
        this.namespaceMap = nameSpacesMap;
    }

    public void setNamespaceMap(NamespaceMap namespaceMap) {
        this.namespaceMap = namespaceMap;
    }

    private void addSchemaNameSpace(XmlSchema schema) {
        String targetNameSpace = schema.getTargetNamespace();
        String prefix = schema.getNamespaceContext().getPrefix(targetNameSpace);
        if (this.namespaceMap == null) {
            this.namespaceMap = new NamespaceMap();
        }
        if (!this.namespaceMap.values().contains(targetNameSpace)) {
            while (prefix == null || this.namespaceMap.keySet().contains(prefix)) {
                prefix = "ns" + this.nsCount++;
            }
            this.namespaceMap.put((Object)prefix, (Object)targetNameSpace);
        }
    }

    public Map populateSchemaMappings() {
        return this.populateSchemaMappings(false);
    }

    public Map populateSchemaMappings(boolean overrideAbsoluteAddress) {
        ArrayList<XmlSchema> schema = this.schemaList;
        Map changedSchemaLocations = null;
        if (!this.schemaLocationsAdjusted) {
            Hashtable nameTable = new Hashtable();
            Hashtable sourceURIToNewLocationMap = new Hashtable();
            this.calculateSchemaNames(schema, nameTable, sourceURIToNewLocationMap, overrideAbsoluteAddress);
            changedSchemaLocations = this.adjustSchemaNames(schema, nameTable, sourceURIToNewLocationMap);
            this.setSchemaMappingTable(this.swapMappingTable(nameTable));
            this.setSchemaLocationsAdjusted(true);
        }
        return changedSchemaLocations;
    }

    private void calculateSchemaNames(List schemas, Hashtable nameTable, Hashtable sourceURIToNewLocationMap, boolean overrideAbsoluteAddress) {
        for (int i = 0; i < schemas.size(); ++i) {
            XmlSchema schema = (XmlSchema)schemas.get(i);
            XmlSchemaObjectCollection includes = schema.getIncludes();
            for (int j = 0; j < includes.getCount(); ++j) {
                XmlSchemaExternal externalSchema;
                XmlSchema s;
                XmlSchemaObject item = includes.getItem(j);
                if (!(item instanceof XmlSchemaExternal) || (s = (externalSchema = (XmlSchemaExternal)item).getSchema()) == null || this.getScheamLocationWithDot(sourceURIToNewLocationMap, s) != null) continue;
                this.insertIntoNameTable(nameTable, s, sourceURIToNewLocationMap, overrideAbsoluteAddress);
                this.calculateSchemaNames(Arrays.asList(s), nameTable, sourceURIToNewLocationMap, overrideAbsoluteAddress);
            }
        }
    }

    private void insertIntoNameTable(Hashtable nameTable, XmlSchema s, Hashtable sourceURIToNewLocationMap, boolean overrideAbsoluteAddress) {
        String sourceURI = s.getSourceURI();
        if (sourceURI.startsWith("http") && !overrideAbsoluteAddress) {
            nameTable.put(s, sourceURI);
            sourceURIToNewLocationMap.put(sourceURI, sourceURI);
        } else {
            String newURI = sourceURI.substring(sourceURI.lastIndexOf(47) + 1);
            newURI = newURI.endsWith(".xsd") ? newURI.substring(0, newURI.lastIndexOf(".")) : "xsd" + this.count++;
            String string = newURI = this.customSchemaNameSuffix != null ? newURI + this.customSchemaNameSuffix : newURI;
            while (nameTable.containsValue(newURI)) {
                newURI = newURI + this.count++;
            }
            nameTable.put(s, newURI);
            sourceURIToNewLocationMap.put(sourceURI, newURI);
        }
    }

    private Map adjustSchemaNames(List schemas, Hashtable nameTable, Hashtable sourceURIToNewLocationMap) {
        Hashtable importedSchemas = new Hashtable();
        for (int i = 0; i < schemas.size(); ++i) {
            this.adjustSchemaName((XmlSchema)schemas.get(i), nameTable, importedSchemas, sourceURIToNewLocationMap);
        }
        Enumeration nameTableKeys = nameTable.keys();
        while (nameTableKeys.hasMoreElements()) {
            this.adjustSchemaName((XmlSchema)nameTableKeys.nextElement(), nameTable, importedSchemas, sourceURIToNewLocationMap);
        }
        return importedSchemas;
    }

    private void adjustSchemaName(XmlSchema parentSchema, Hashtable nameTable, Hashtable importedScheams, Hashtable sourceURIToNewLocationMap) {
        XmlSchemaObjectCollection includes = parentSchema.getIncludes();
        for (int j = 0; j < includes.getCount(); ++j) {
            XmlSchemaObject item = includes.getItem(j);
            if (!(item instanceof XmlSchemaExternal)) continue;
            XmlSchemaExternal xmlSchemaExternal = (XmlSchemaExternal)item;
            XmlSchema s = xmlSchemaExternal.getSchema();
            this.adjustSchemaLocation(s, xmlSchemaExternal, nameTable, importedScheams, sourceURIToNewLocationMap);
        }
    }

    private void adjustSchemaLocation(XmlSchema s, XmlSchemaExternal xmlSchemaExternal, Hashtable nameTable, Hashtable importedScheams, Hashtable sourceURIToNewLocationMap) {
        if (s != null) {
            String schemaLocation = xmlSchemaExternal.getSchemaLocation();
            String newscheamlocation = this.customSchemaNamePrefix == null ? this.getServiceEPR() + "?xsd=" + this.getScheamLocationWithDot(sourceURIToNewLocationMap, s) : this.customSchemaNamePrefix + this.getScheamLocationWithDot(sourceURIToNewLocationMap, s);
            xmlSchemaExternal.setSchemaLocation(newscheamlocation);
            importedScheams.put(schemaLocation, newscheamlocation);
        }
    }

    private Object getScheamLocationWithDot(Hashtable sourceURIToNewLocationMap, XmlSchema s) {
        String o = (String)sourceURIToNewLocationMap.get(s.getSourceURI());
        if (o != null && o.indexOf(".") < 0) {
            return o + ".xsd";
        }
        return o;
    }

    private Map swapMappingTable(Map originalTable) {
        HashMap swappedTable = new HashMap(originalTable.size());
        for (Object key : originalTable.keySet()) {
            swappedTable.put(originalTable.get(key), key);
        }
        return swappedTable;
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public void setClientSide(boolean clientSide) {
        this.clientSide = clientSide;
    }

    public boolean isElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(boolean elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public boolean isUseUserWSDL() {
        String value;
        Parameter parameter = this.getParameter("useOriginalwsdl");
        return parameter != null && "true".equals(value = (String)parameter.getValue());
    }

    public boolean isModifyUserWSDLPortAddress() {
        String value;
        Parameter parameter = this.getParameter("modifyUserWSDLPortAddress");
        return parameter == null || !"false".equals(value = (String)parameter.getValue());
    }

    public ServiceLifeCycle getServiceLifeCycle() {
        return this.serviceLifeCycle;
    }

    public void setServiceLifeCycle(ServiceLifeCycle serviceLifeCycle) {
        this.serviceLifeCycle = serviceLifeCycle;
    }

    public Map getP2nMap() {
        return this.p2nMap;
    }

    public void setP2nMap(Map p2nMap) {
        this.p2nMap = p2nMap;
    }

    public ObjectSupplier getObjectSupplier() {
        return this.objectSupplier;
    }

    public void setObjectSupplier(ObjectSupplier objectSupplier) {
        this.objectSupplier = objectSupplier;
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    public void setTypeTable(TypeTable typeTable) {
        this.typeTable = typeTable;
    }

    public Data[] getData(DataRetrievalRequest request, MessageContext msgContext) throws AxisFault {
        String dialect = request.getDialect();
        AxisDataLocator dataLocator = null;
        int nextDataLocatorIndex = 0;
        int totalLocators = this.availableDataLocatorTypes.length;
        for (int i = 0; i < totalLocators; ++i) {
            dataLocator = this.getDataLocator(this.availableDataLocatorTypes[i], dialect);
            if (dataLocator == null) continue;
            nextDataLocatorIndex = i + 1;
            break;
        }
        if (dataLocator == null) {
            return null;
        }
        Data[] data = dataLocator.getData(request, msgContext);
        if (data == null && nextDataLocatorIndex < totalLocators) {
            data = this.bubbleupDataLocators(nextDataLocatorIndex, request, msgContext);
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Data[] bubbleupDataLocators(int nextIndex, DataRetrievalRequest request, MessageContext msgContext) throws AxisFault {
        Data[] data = null;
        if (nextIndex >= this.availableDataLocatorTypes.length) return data;
        AxisDataLocator dataLocator = this.getDataLocator(this.availableDataLocatorTypes[nextIndex], request.getDialect());
        if (dataLocator == null) return this.bubbleupDataLocators(nextIndex, request, msgContext);
        data = dataLocator.getData(request, msgContext);
        if (data != null) return data;
        return this.bubbleupDataLocators(++nextIndex, request, msgContext);
    }

    public void addDataLocatorClassNames(String dialect, String dataLocatorClassName) {
        this.dataLocatorClassNames.put(dialect, dataLocatorClassName);
    }

    public AxisDataLocator getDataLocator(LocatorType locatorType, String dialect) throws AxisFault {
        AxisDataLocator locator = locatorType == LocatorType.SERVICE_DIALECT ? this.getServiceDataLocator(dialect) : (locatorType == LocatorType.SERVICE_LEVEL ? this.getServiceDataLocator("ServiceLevel") : (locatorType == LocatorType.GLOBAL_DIALECT ? this.getGlobalDataLocator(dialect) : (locatorType == LocatorType.GLOBAL_LEVEL ? this.getGlobalDataLocator("GlobalLevel") : (locatorType == LocatorType.DEFAULT_AXIS ? this.getDefaultDataLocator() : this.getDefaultDataLocator()))));
        return locator;
    }

    private AxisDataLocator getDefaultDataLocator() throws DataRetrievalException {
        if (this.defaultDataLocator == null) {
            this.defaultDataLocator = new AxisDataLocatorImpl(this);
        }
        this.defaultDataLocator.loadServiceData();
        return this.defaultDataLocator;
    }

    private AxisDataLocator getServiceDataLocator(String dialect) throws AxisFault {
        String className;
        AxisDataLocator locator = (AxisDataLocator)this.dataLocators.get(dialect);
        if (locator == null && (className = this.dataLocatorClassNames.get(dialect)) != null) {
            locator = this.loadDataLocator(className);
            this.dataLocators.put(dialect, locator);
        }
        return locator;
    }

    public AxisDataLocator getGlobalDataLocator(String dialect) throws AxisFault {
        String className;
        AxisConfiguration axisConfig = this.getAxisConfiguration();
        AxisDataLocator locator = null;
        if (axisConfig != null && (locator = axisConfig.getDataLocator(dialect)) == null && (className = axisConfig.getDataLocatorClassName(dialect)) != null) {
            locator = this.loadDataLocator(className);
            axisConfig.addDataLocator(dialect, locator);
        }
        return locator;
    }

    protected AxisDataLocator loadDataLocator(String className) throws AxisFault {
        AxisDataLocator locator;
        try {
            Class<?> dataLocator = Class.forName(className, true, this.serviceClassLoader);
            locator = (AxisDataLocator)dataLocator.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw AxisFault.makeFault(e);
        }
        catch (IllegalAccessException e) {
            throw AxisFault.makeFault(e);
        }
        catch (InstantiationException e) {
            throw AxisFault.makeFault(e);
        }
        return locator;
    }

    public void setMessageElementQNameToOperationMap(Map messageElementQNameToOperationMap) {
        this.messageElementQNameToOperationMap = messageElementQNameToOperationMap;
    }

    public AxisOperation getOperationByMessageElementQName(QName messageElementQName) {
        return this.messageElementQNameToOperationMap.get(messageElementQName);
    }

    public void addMessageElementQNameToOperationMapping(QName messageElementQName, AxisOperation operation) {
        if (this.messageElementQNameToOperationMap.containsKey(messageElementQName) && this.messageElementQNameToOperationMap.get(messageElementQName) != operation) {
            this.messageElementQNameToOperationMap.put(messageElementQName, null);
        } else {
            this.messageElementQNameToOperationMap.put(messageElementQName, operation);
        }
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String endpointURL) {
        this.endpointURL = endpointURL;
    }

    public Map<String, AxisEndpoint> getEndpoints() {
        return this.endpointMap;
    }

    public boolean isCustomWsdl() {
        return this.customWsdl;
    }

    public void setCustomWsdl(boolean customWsdl) {
        this.customWsdl = customWsdl;
    }

    public List getOperationsNameList() {
        return this.operationsNameList;
    }

    public void setOperationsNameList(List operationsNameList) {
        this.operationsNameList = operationsNameList;
    }

    public AxisServiceGroup getAxisServiceGroup() {
        return (AxisServiceGroup)this.parent;
    }

    public void setParent(AxisServiceGroup parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.getName();
    }

    public ExcludeInfo getExcludeInfo() {
        return this.excludeInfo;
    }

    public void setExcludeInfo(ExcludeInfo excludeInfo) {
        this.excludeInfo = excludeInfo;
    }

    public void registerPolicy(String key, Policy policy) {
        this.policyMap.put(key, policy);
    }

    public Policy lookupPolicy(String key) {
        return (Policy)this.policyMap.get(key);
    }

    public void addMessageContextListener(MessageContextListener scl) {
        this.messageContextListeners.add(scl);
    }

    public void removeMessageContextListener(MessageContextListener scl) {
        this.messageContextListeners.remove(scl);
    }

    public boolean hasMessageContextListener(Class cls) {
        for (int i = 0; i < this.messageContextListeners.size(); ++i) {
            if (this.messageContextListeners.get(i).getClass() != cls) continue;
            return true;
        }
        return false;
    }

    public void attachServiceContextEvent(ServiceContext sc, MessageContext mc) {
        for (int i = 0; i < this.messageContextListeners.size(); ++i) {
            this.messageContextListeners.get(i).attachServiceContextEvent(sc, mc);
        }
    }

    public void attachEnvelopeEvent(MessageContext mc) {
        for (int i = 0; i < this.messageContextListeners.size(); ++i) {
            this.messageContextListeners.get(i).attachEnvelopeEvent(mc);
        }
    }
}

