/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.client.async.Callback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.CallbackReceiver;
import org.apache.axis2.util.LoggingControl;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AxisEngine {
    private static final Log log = LogFactory.getLog(AxisEngine.class);
    private static boolean RESUMING_EXECUTION = true;
    private static boolean NOT_RESUMING_EXECUTION = false;

    private static void checkMustUnderstand(MessageContext msgContext) throws AxisFault {
        ArrayList<QName> unprocessed = null;
        SOAPEnvelope envelope = msgContext.getEnvelope();
        if (envelope.getHeader() == null) {
            return;
        }
        Iterator headerBlocks = envelope.getHeader().getHeadersToProcess((RolePlayer)msgContext.getConfigurationContext().getAxisConfiguration().getParameterValue("rolePlayer"));
        while (headerBlocks.hasNext()) {
            SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)headerBlocks.next();
            QName headerName = headerBlock.getQName();
            if (headerBlock.isProcessed() || !headerBlock.getMustUnderstand() || AxisEngine.clientHandlerUnderstandsHeader(headerBlock, msgContext)) continue;
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug((Object)("MustUnderstand header not processed or registered as understood" + headerName));
            }
            if (AxisEngine.isReceiverMustUnderstandProcessor(msgContext)) {
                if (unprocessed == null) {
                    unprocessed = new ArrayList<QName>();
                }
                if (unprocessed.contains(headerName)) continue;
                unprocessed.add(headerName);
                continue;
            }
            QName faultQName = headerBlock.getVersion().getMustUnderstandFaultCode();
            throw new AxisFault(Messages.getMessage("mustunderstandfailed", headerBlock.getNamespace().getNamespaceURI(), headerBlock.getLocalName()), faultQName);
        }
        if (unprocessed != null && unprocessed.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Adding Unprocessed headers to MessageContext.");
            }
            msgContext.setProperty("unprocessedHeaderQNames", unprocessed);
        }
    }

    private static boolean isReceiverMustUnderstandProcessor(MessageContext msgContext) {
        MessageReceiver receiver = null;
        if (msgContext.isServerSide()) {
            receiver = msgContext.getAxisOperation().getMessageReceiver();
        }
        return receiver != null && receiver.getClass().getName().endsWith("JAXWSMessageReceiver");
    }

    public static MessageContext createFaultMessageContext(MessageContext processingContext, Throwable e) throws AxisFault {
        return MessageContextBuilder.createFaultMessageContext(processingContext, e);
    }

    public static Handler.InvocationResponse receive(MessageContext msgContext) throws AxisFault {
        List<Phase> preCalculatedPhases;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(msgContext.getLogIDString() + " receive:" + msgContext.getMessageID()));
        }
        ConfigurationContext confContext = msgContext.getConfigurationContext();
        if (msgContext.isFault() || msgContext.isProcessingFault()) {
            preCalculatedPhases = confContext.getAxisConfiguration().getInFaultFlowPhases();
            msgContext.setFLOW(3);
        } else {
            preCalculatedPhases = confContext.getAxisConfiguration().getInFlowPhases();
            msgContext.setFLOW(1);
        }
        ArrayList<Handler> executionChain = new ArrayList<Handler>();
        executionChain.addAll(preCalculatedPhases);
        msgContext.setExecutionChain(executionChain);
        try {
            Handler.InvocationResponse pi = AxisEngine.invoke(msgContext, NOT_RESUMING_EXECUTION);
            if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
                AxisEngine.checkMustUnderstand(msgContext);
                if (msgContext.isServerSide()) {
                    MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
                    if (receiver == null) {
                        throw new AxisFault(Messages.getMessage("nomessagereciever", msgContext.getAxisOperation().getName().toString()));
                    }
                    receiver.receive(msgContext);
                }
            } else {
                if (pi.equals(Handler.InvocationResponse.SUSPEND)) {
                    return pi;
                }
                if (pi.equals(Handler.InvocationResponse.ABORT)) {
                    AxisOperation axisOp;
                    AxisEngine.flowComplete(msgContext);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"InvocationResponse is aborted.  The incoming MessageContext is removed, and the OperationContext is marked as incomplete");
                    }
                    if ((axisOp = msgContext.getAxisOperation()) != null) {
                        OperationContext opCtx;
                        String mepURI = axisOp.getMessageExchangePattern();
                        if ("http://www.w3.org/ns/wsdl/out-in".equals(mepURI) && (opCtx = msgContext.getOperationContext()) != null) {
                            opCtx.removeMessageContext("In");
                        }
                    } else {
                        log.debug((Object)("Could not clean up op ctx for " + msgContext));
                    }
                    return pi;
                }
                String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.receive()";
                log.error((Object)(msgContext.getLogIDString() + " " + errorMsg));
                throw new AxisFault(errorMsg);
            }
            AxisEngine.flowComplete(msgContext);
        }
        catch (AxisFault e) {
            if (e.getFaultType() != 1) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            msgContext.setFailureReason(e);
            AxisEngine.flowComplete(msgContext);
            throw e;
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private static Handler.InvocationResponse invoke(MessageContext msgContext, boolean resuming) throws AxisFault {
        if (msgContext.getCurrentHandlerIndex() == -1) {
            msgContext.setCurrentHandlerIndex(0);
        }
        Handler.InvocationResponse pi = Handler.InvocationResponse.CONTINUE;
        while (msgContext.getCurrentHandlerIndex() < msgContext.getExecutionChain().size()) {
            Handler currentHandler = msgContext.getExecutionChain().get(msgContext.getCurrentHandlerIndex());
            try {
                if (!resuming) {
                    msgContext.addExecutedPhase(currentHandler);
                } else {
                    resuming = false;
                }
                pi = currentHandler.invoke(msgContext);
            }
            catch (AxisFault e) {
                if (msgContext.getCurrentPhaseIndex() == 0) {
                    msgContext.removeFirstExecutedPhase();
                }
                throw e;
            }
            if (pi.equals(Handler.InvocationResponse.SUSPEND) || pi.equals(Handler.InvocationResponse.ABORT)) break;
            msgContext.setCurrentHandlerIndex(msgContext.getCurrentHandlerIndex() + 1);
        }
        return pi;
    }

    private static void flowComplete(MessageContext msgContext) {
        Iterator<Handler> invokedPhaseIterator = msgContext.getExecutedPhases();
        while (invokedPhaseIterator.hasNext()) {
            Handler currentHandler = invokedPhaseIterator.next();
            currentHandler.flowComplete(msgContext);
        }
        msgContext.resetExecutedPhases();
    }

    public static Handler.InvocationResponse resumeReceive(MessageContext msgContext) throws AxisFault {
        Handler.InvocationResponse pi;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(msgContext.getLogIDString() + " resumeReceive:" + msgContext.getMessageID()));
        }
        if ((pi = AxisEngine.invoke(msgContext, RESUMING_EXECUTION)).equals(Handler.InvocationResponse.CONTINUE)) {
            AxisEngine.checkMustUnderstand(msgContext);
            if (msgContext.isServerSide()) {
                MessageReceiver receiver = msgContext.getAxisOperation().getMessageReceiver();
                if (receiver == null) {
                    throw new AxisFault(Messages.getMessage("nomessagereciever", msgContext.getAxisOperation().getName().toString()));
                }
                receiver.receive(msgContext);
            }
            AxisEngine.flowComplete(msgContext);
        }
        return pi;
    }

    public static Handler.InvocationResponse resumeSend(MessageContext msgContext) throws AxisFault {
        Handler.InvocationResponse pi;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(msgContext.getLogIDString() + " resumeSend:" + msgContext.getMessageID()));
        }
        if ((pi = AxisEngine.invoke(msgContext, RESUMING_EXECUTION)).equals(Handler.InvocationResponse.CONTINUE)) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            TransportSender sender = transportOut.getSender();
            sender.invoke(msgContext);
            AxisEngine.flowComplete(msgContext);
        }
        return pi;
    }

    public static Handler.InvocationResponse resume(MessageContext msgctx) throws AxisFault {
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(msgctx.getLogIDString() + " resume:" + msgctx.getMessageID()));
        }
        msgctx.setPaused(false);
        if (msgctx.getFLOW() == 1) {
            return AxisEngine.resumeReceive(msgctx);
        }
        return AxisEngine.resumeSend(msgctx);
    }

    public static void send(MessageContext msgContext) throws AxisFault {
        block8: {
            if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
                log.trace((Object)(msgContext.getLogIDString() + " send:" + msgContext.getMessageID()));
            }
            OperationContext operationContext = msgContext.getOperationContext();
            ArrayList executionChain = operationContext.getAxisOperation().getPhasesOutFlow();
            ArrayList<Handler> outPhases = new ArrayList<Handler>();
            outPhases.addAll(executionChain);
            outPhases.addAll(msgContext.getConfigurationContext().getAxisConfiguration().getOutFlowPhases());
            msgContext.setExecutionChain(outPhases);
            msgContext.setFLOW(2);
            try {
                Handler.InvocationResponse pi = AxisEngine.invoke(msgContext, NOT_RESUMING_EXECUTION);
                if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
                    TransportOutDescription transportOut = msgContext.getTransportOut();
                    if (transportOut == null) {
                        throw new AxisFault("Transport out has not been set");
                    }
                    TransportSender sender = transportOut.getSender();
                    if (Utils.isClientThreadNonBlockingPropertySet(msgContext)) {
                        msgContext.getConfigurationContext().getThreadPool().execute(new TransportNonBlockingInvocationWorker(msgContext, sender));
                    } else {
                        sender.invoke(msgContext);
                    }
                    AxisEngine.flowComplete(msgContext);
                    break block8;
                }
                if (pi.equals(Handler.InvocationResponse.SUSPEND)) break block8;
                if (pi.equals(Handler.InvocationResponse.ABORT)) {
                    AxisEngine.flowComplete(msgContext);
                    break block8;
                }
                String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.send()";
                log.error((Object)(msgContext.getLogIDString() + " " + errorMsg));
                throw new AxisFault(errorMsg);
            }
            catch (AxisFault e) {
                msgContext.setFailureReason(e);
                AxisEngine.flowComplete(msgContext);
                throw e;
            }
        }
    }

    public static void sendFault(MessageContext msgContext) throws AxisFault {
        OperationContext opContext;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(msgContext.getLogIDString() + " sendFault:" + msgContext.getMessageID()));
        }
        if ((opContext = msgContext.getOperationContext()) != null) {
            AxisOperation axisOperation = opContext.getAxisOperation();
            ArrayList faultExecutionChain = axisOperation.getPhasesOutFaultFlow();
            ArrayList outFaultPhases = new ArrayList();
            outFaultPhases.addAll((ArrayList)faultExecutionChain.clone());
            msgContext.setExecutionChain((ArrayList)outFaultPhases.clone());
            msgContext.setFLOW(4);
            try {
                Handler.InvocationResponse pi = AxisEngine.invoke(msgContext, NOT_RESUMING_EXECUTION);
                if (pi.equals(Handler.InvocationResponse.SUSPEND)) {
                    log.warn((Object)(msgContext.getLogIDString() + " The resumption of this flow may function incorrectly, as the OutFaultFlow will not be used"));
                    return;
                }
                if (pi.equals(Handler.InvocationResponse.ABORT)) {
                    AxisEngine.flowComplete(msgContext);
                    return;
                }
                if (!pi.equals(Handler.InvocationResponse.CONTINUE)) {
                    String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.sendFault()";
                    log.error((Object)(msgContext.getLogIDString() + " " + errorMsg));
                    throw new AxisFault(errorMsg);
                }
            }
            catch (AxisFault e) {
                msgContext.setFailureReason(e);
                AxisEngine.flowComplete(msgContext);
                throw e;
            }
        }
        ArrayList<Handler> executionChain = new ArrayList<Handler>(msgContext.getConfigurationContext().getAxisConfiguration().getOutFaultFlowPhases());
        msgContext.setExecutionChain(executionChain);
        msgContext.setFLOW(4);
        Handler.InvocationResponse pi = AxisEngine.invoke(msgContext, NOT_RESUMING_EXECUTION);
        if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            if (transportOut == null) {
                throw new AxisFault("Transport out has not been set");
            }
            TransportSender sender = transportOut.getSender();
            sender.invoke(msgContext);
            AxisEngine.flowComplete(msgContext);
        } else if (!pi.equals(Handler.InvocationResponse.SUSPEND)) {
            if (pi.equals(Handler.InvocationResponse.ABORT)) {
                AxisEngine.flowComplete(msgContext);
            } else {
                String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.sendFault()";
                log.error((Object)(msgContext.getLogIDString() + " " + errorMsg));
                throw new AxisFault(errorMsg);
            }
        }
    }

    public static void resumeSendFault(MessageContext msgContext) throws AxisFault {
        OperationContext opContext;
        if (LoggingControl.debugLoggingAllowed && log.isTraceEnabled()) {
            log.trace((Object)(msgContext.getLogIDString() + " resumeSendFault:" + msgContext.getMessageID()));
        }
        if ((opContext = msgContext.getOperationContext()) != null) {
            try {
                Handler.InvocationResponse pi = AxisEngine.invoke(msgContext, RESUMING_EXECUTION);
                if (pi.equals(Handler.InvocationResponse.SUSPEND)) {
                    log.warn((Object)(msgContext.getLogIDString() + " The resumption of this flow may function incorrectly, as the OutFaultFlow will not be used"));
                    return;
                }
                if (pi.equals(Handler.InvocationResponse.ABORT)) {
                    AxisEngine.flowComplete(msgContext);
                    return;
                }
                if (!pi.equals(Handler.InvocationResponse.CONTINUE)) {
                    String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.sendFault()";
                    log.error((Object)(msgContext.getLogIDString() + " " + errorMsg));
                    throw new AxisFault(errorMsg);
                }
            }
            catch (AxisFault e) {
                msgContext.setFailureReason(e);
                AxisEngine.flowComplete(msgContext);
                throw e;
            }
        }
        ArrayList<Handler> executionChain = new ArrayList<Handler>(msgContext.getConfigurationContext().getAxisConfiguration().getOutFaultFlowPhases());
        msgContext.setExecutionChain(executionChain);
        msgContext.setFLOW(4);
        Handler.InvocationResponse pi = AxisEngine.invoke(msgContext, NOT_RESUMING_EXECUTION);
        if (pi.equals(Handler.InvocationResponse.CONTINUE)) {
            TransportOutDescription transportOut = msgContext.getTransportOut();
            if (transportOut == null) {
                throw new AxisFault("Transport out has not been set");
            }
            TransportSender sender = transportOut.getSender();
            sender.invoke(msgContext);
            AxisEngine.flowComplete(msgContext);
        } else if (!pi.equals(Handler.InvocationResponse.SUSPEND)) {
            if (pi.equals(Handler.InvocationResponse.ABORT)) {
                AxisEngine.flowComplete(msgContext);
            } else {
                String errorMsg = "Unrecognized InvocationResponse encountered in AxisEngine.sendFault()";
                log.error((Object)(msgContext.getLogIDString() + " " + errorMsg));
                throw new AxisFault(errorMsg);
            }
        }
    }

    private static boolean clientHandlerUnderstandsHeader(SOAPHeaderBlock headerBlock, MessageContext messageContext) {
        boolean headerUnderstood = false;
        QName headerQName = headerBlock.getQName();
        Set understoodHeaders = AxisEngine.getUnderstoodClientHeaders(messageContext);
        if (understoodHeaders != null && understoodHeaders.size() > 0) {
            headerUnderstood = understoodHeaders.contains(headerQName);
        }
        return headerUnderstood;
    }

    private static Set getUnderstoodClientHeaders(MessageContext msgContext) {
        Set returnQN = null;
        OperationContext opCtx = msgContext.getOperationContext();
        MessageContext outboundMC = null;
        try {
            outboundMC = opCtx.getMessageContext("Out");
        }
        catch (AxisFault af) {
            // empty catch block
        }
        if (outboundMC != null) {
            returnQN = (Set)outboundMC.getProperty("client.UnderstoodHeaders");
        }
        return returnQN;
    }

    private static class TransportNonBlockingInvocationWorker
    implements Runnable {
        private MessageContext msgctx;
        private TransportSender sender;

        public TransportNonBlockingInvocationWorker(MessageContext msgctx, TransportSender sender) {
            this.msgctx = msgctx;
            this.sender = sender;
        }

        @Override
        public void run() {
            block4: {
                try {
                    this.sender.invoke(this.msgctx);
                }
                catch (Exception e) {
                    MessageReceiver msgReceiver;
                    AxisOperation axisOperation;
                    log.info((Object)(this.msgctx.getLogIDString() + " " + e.getMessage()));
                    if (this.msgctx.getProperty("disableTransmissionErrorCallback") != null || (axisOperation = this.msgctx.getAxisOperation()) == null || (msgReceiver = axisOperation.getMessageReceiver()) == null || !(msgReceiver instanceof CallbackReceiver)) break block4;
                    Object callback = ((CallbackReceiver)msgReceiver).lookupCallback(this.msgctx.getMessageID());
                    if (callback == null) {
                        return;
                    }
                    if (callback instanceof Callback) {
                        ((Callback)callback).onError(e);
                    }
                    ((AxisCallback)callback).onError(e);
                    ((AxisCallback)callback).onComplete();
                }
            }
        }
    }
}

