/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.xmpp.util.XMPPServerCredentials;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ToContainsFilter;

public class XMPPClientConnectionFactory {
    private static Log log = LogFactory.getLog(XMPPClientConnectionFactory.class);
    private XMPPConnection xmppConnection = null;
    private PacketFilter packetFilter = null;
    private Map<String, XMPPConnectionDetails> xmppConnections = new HashMap<String, XMPPConnectionDetails>();

    public XMPPConnection connect(final XMPPServerCredentials serverCredentials) throws AxisFault {
        if ("transport.xmpp.ServerType.Jabber".equals(serverCredentials.getServerType())) {
            this.xmppConnection = new XMPPConnection(serverCredentials.getServerUrl());
            try {
                this.xmppConnection.connect();
            }
            catch (XMPPException e) {
                log.error((Object)("Failed to connect to server :" + serverCredentials.getServerUrl()), (Throwable)e);
                throw new AxisFault("Failed to connect to server :" + serverCredentials.getServerUrl());
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e5) {
                log.debug((Object)"Sleep interrupted ", (Throwable)e5);
            }
            if (this.xmppConnection.isConnected()) {
                String resource = serverCredentials.getResource() + new Object().hashCode();
                if (!this.xmppConnection.isAuthenticated()) {
                    try {
                        this.xmppConnection.login(serverCredentials.getAccountName(), serverCredentials.getPassword(), resource, true);
                    }
                    catch (XMPPException e) {
                        try {
                            log.error((Object)("Login failed for " + serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl() + ".Retrying in 2 secs"), (Throwable)e);
                            Thread.sleep(2000L);
                            this.xmppConnection.login(serverCredentials.getAccountName(), serverCredentials.getPassword(), resource, true);
                        }
                        catch (InterruptedException e1) {
                            log.error((Object)"Sleep interrupted.", (Throwable)e1);
                        }
                        catch (XMPPException e2) {
                            log.error((Object)("Login failed for : " + serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl()), (Throwable)e2);
                            throw new AxisFault("Login failed for : " + serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl());
                        }
                    }
                    this.packetFilter = new FromContainsFilter(serverCredentials.getServerUrl());
                }
            }
        } else if ("transport.xmpp.ServerType.GoogleTalk".equals(serverCredentials.getServerType())) {
            ConnectionConfiguration connectionConfiguration = new ConnectionConfiguration("talk.google.com", 5222, "gmail.com");
            this.xmppConnection = new XMPPConnection(connectionConfiguration);
            try {
                this.xmppConnection.connect();
                this.xmppConnection.login(serverCredentials.getAccountName(), serverCredentials.getPassword(), serverCredentials.getResource(), true);
                this.packetFilter = new ToContainsFilter("@gmail.com");
            }
            catch (XMPPException e1) {
                log.error((Object)"Error occured while connecting to Googletalk server.", (Throwable)e1);
                throw new AxisFault("Error occured while connecting to Googletalk server.");
            }
        }
        ConnectionListener connectionListener = null;
        connectionListener = new ConnectionListener(){

            public void connectionClosed() {
                log.debug((Object)"Connection closed normally");
            }

            public void connectionClosedOnError(Exception e1) {
                log.error((Object)("Connection to " + serverCredentials.getServerUrl() + " closed with error."), (Throwable)e1);
            }

            public void reconnectingIn(int seconds) {
                log.error((Object)("Connection to " + serverCredentials.getServerUrl() + " failed. Reconnecting in " + seconds + "s"));
            }

            public void reconnectionFailed(Exception e) {
                log.error((Object)("Reconnection to " + serverCredentials.getServerUrl() + " failed."), (Throwable)e);
            }

            public void reconnectionSuccessful() {
                log.debug((Object)("Reconnection to " + serverCredentials.getServerUrl() + " successful."));
            }
        };
        if (this.xmppConnection != null && this.xmppConnection.isConnected()) {
            this.xmppConnection.addConnectionListener(connectionListener);
            log.info((Object)("Connected to " + serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl() + "/" + serverCredentials.getResource()));
        } else {
            log.warn((Object)(" Not Connected to " + serverCredentials.getAccountName() + "@" + serverCredentials.getServerUrl() + "/" + serverCredentials.getResource()));
        }
        return this.xmppConnection;
    }

    public XMPPConnection getXmppConnection() {
        return this.xmppConnection;
    }

    public void stop() {
    }

    public class XMPPConnectionDetails {
        XMPPConnection connection;
        int userCount;
    }
}

