/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.beam.runners.core.construction.PipelineOptionsTranslation;
import org.apache.beam.runners.fnexecution.control.DefaultExecutableStageContext;
import org.apache.beam.runners.fnexecution.control.ExecutableStageContext;
import org.apache.beam.runners.fnexecution.provisioning.JobInfo;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.vendor.grpc.v1p21p0.com.google.protobuf.Struct;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;

public class SparkExecutableStageContextFactory
implements ExecutableStageContext.Factory {
    private static final SparkExecutableStageContextFactory instance = new SparkExecutableStageContextFactory();
    private static final ConcurrentMap<String, DefaultExecutableStageContext.MultiInstanceFactory> jobFactories = new ConcurrentHashMap<String, DefaultExecutableStageContext.MultiInstanceFactory>();

    private SparkExecutableStageContextFactory() {
    }

    public static SparkExecutableStageContextFactory getInstance() {
        return instance;
    }

    public ExecutableStageContext get(JobInfo jobInfo) {
        DefaultExecutableStageContext.MultiInstanceFactory jobFactory = jobFactories.computeIfAbsent(jobInfo.jobId(), k -> {
            PortablePipelineOptions portableOptions = (PortablePipelineOptions)PipelineOptionsTranslation.fromProto((Struct)jobInfo.pipelineOptions()).as(PortablePipelineOptions.class);
            return new DefaultExecutableStageContext.MultiInstanceFactory(((Long)MoreObjects.firstNonNull((Object)portableOptions.getSdkWorkerParallelism(), (Object)1L)).intValue(), (SerializableFunction & Serializable)caller -> false);
        });
        return jobFactory.get(jobInfo);
    }
}

