/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.extras.constraints.checkdigit;

import org.apache.bval.extras.constraints.checkdigit.ModulusValidator;
import org.apache.bval.extras.constraints.checkdigit.Sedol;

public final class SedolValidator
extends ModulusValidator<Sedol> {
    private static final int[] POSITION_WEIGHT = new int[]{1, 3, 1, 7, 3, 9, 1};

    public SedolValidator() {
        super(10);
    }

    @Override
    protected int weightedValue(int charValue, int leftPos, int rightPos) throws Exception {
        return charValue * POSITION_WEIGHT[leftPos - 1];
    }

    @Override
    protected int toInt(char character, int leftPos, int rightPos) {
        int charValue = Character.getNumericValue(character);
        if (charValue < 0 || charValue > 35) {
            throw new IllegalArgumentException("Invalid Character[" + leftPos + "] = '" + charValue + "'");
        }
        return charValue;
    }
}

