/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.calcite.adapter.druid.DefaultDimensionSpec;
import org.apache.calcite.adapter.druid.DimensionSpec;
import org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidRules;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.adapter.druid.ExtractionFunction;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.adapter.druid.LocalInterval;
import org.apache.calcite.adapter.druid.QueryType;
import org.apache.calcite.adapter.druid.TimeExtractionDimensionSpec;
import org.apache.calcite.adapter.druid.TimeExtractionFunction;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class DruidQuery
extends AbstractRelNode
implements BindableRel {
    protected QuerySpec querySpec;
    final RelOptTable table;
    final DruidTable druidTable;
    final ImmutableList<LocalInterval> intervals;
    final ImmutableList<RelNode> rels;
    private static final Pattern VALID_SIG = Pattern.compile("sf?p?(a?|ao)l?");
    private static final String EXTRACT_COLUMN_NAME_PREFIX = "extract";
    private static final String FLOOR_COLUMN_NAME_PREFIX = "floor";
    protected static final String DRUID_QUERY_FETCH = "druid.query.fetch";

    protected DruidQuery(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<LocalInterval> intervals, List<RelNode> rels) {
        super(cluster, traitSet);
        this.table = table;
        this.druidTable = druidTable;
        this.intervals = ImmutableList.copyOf(intervals);
        this.rels = ImmutableList.copyOf(rels);
        assert (this.isValid(Litmus.THROW, null));
    }

    String signature() {
        StringBuilder b = new StringBuilder();
        boolean flag = false;
        for (RelNode rel : this.rels) {
            b.append((char)(rel instanceof TableScan ? 115 : (rel instanceof Project && flag ? 111 : (rel instanceof Filter ? 102 : (rel instanceof Aggregate ? 97 : (rel instanceof Sort ? 108 : (rel instanceof Project ? 112 : 33)))))));
            flag = flag || rel instanceof Aggregate;
        }
        return b.toString();
    }

    public boolean isValid(Litmus litmus, RelNode.Context context) {
        if (!super.isValid(litmus, context)) {
            return false;
        }
        String signature = this.signature();
        if (!DruidQuery.isValidSignature(signature)) {
            return litmus.fail("invalid signature [{}]", new Object[]{signature});
        }
        if (this.rels.isEmpty()) {
            return litmus.fail("must have at least one rel", new Object[0]);
        }
        for (int i = 0; i < this.rels.size(); ++i) {
            Filter filter;
            Aggregate aggregate;
            RelNode r = (RelNode)this.rels.get(i);
            if (i == 0) {
                if (!(r instanceof TableScan)) {
                    return litmus.fail("first rel must be TableScan, was ", new Object[]{r});
                }
                if (r.getTable() == this.table) continue;
                return litmus.fail("first rel must be based on table table", new Object[0]);
            }
            List inputs = r.getInputs();
            if (inputs.size() != 1 || inputs.get(0) != this.rels.get(i - 1)) {
                return litmus.fail("each rel must have a single input", new Object[0]);
            }
            if (r instanceof Aggregate && ((aggregate = (Aggregate)r).getGroupSets().size() != 1 || aggregate.indicator)) {
                return litmus.fail("no grouping sets", new Object[0]);
            }
            if (r instanceof Filter && !this.isValidFilter((filter = (Filter)r).getCondition())) {
                return litmus.fail("invalid filter [{}]", new Object[]{filter.getCondition()});
            }
            if (!(r instanceof Sort)) continue;
            Sort sort = (Sort)r;
            if (sort.offset == null || RexLiteral.intValue((RexNode)sort.offset) == 0) continue;
            return litmus.fail("offset not supported", new Object[0]);
        }
        return true;
    }

    public boolean isValidFilter(RexNode e) {
        return this.isValidFilter(e, false, null);
    }

    public boolean isValidFilter(RexNode e, RelNode input) {
        return this.isValidFilter(e, false, input);
    }

    public boolean isValidFilter(RexNode e, boolean boundedComparator, RelNode input) {
        switch (e.getKind()) {
            case INPUT_REF: {
                if (input == null) {
                    return true;
                }
                int nameIndex = ((RexInputRef)e).getIndex();
                String name = ((RelDataTypeField)input.getRowType().getFieldList().get(nameIndex)).getName();
                return !this.druidTable.isMetric(name);
            }
            case LITERAL: {
                return ((RexLiteral)e).getValue() != null;
            }
            case AND: 
            case OR: 
            case NOT: 
            case EQUALS: 
            case NOT_EQUALS: 
            case IN: {
                return this.areValidFilters(((RexCall)e).getOperands(), false, input);
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case BETWEEN: {
                return this.areValidFilters(((RexCall)e).getOperands(), true, input);
            }
            case CAST: {
                return DruidQuery.isValidCast((RexCall)e, boundedComparator);
            }
            case EXTRACT: {
                return TimeExtractionFunction.isValidTimeExtract((RexCall)e);
            }
            case IS_TRUE: {
                return this.isValidFilter((RexNode)((RexCall)e).getOperands().get(0), boundedComparator, input);
            }
        }
        return false;
    }

    private boolean areValidFilters(List<RexNode> es, boolean boundedComparator, RelNode input) {
        for (RexNode e : es) {
            if (this.isValidFilter(e, boundedComparator, input)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidCast(RexCall e, boolean boundedComparator) {
        assert (e.isA(SqlKind.CAST));
        if (((RexNode)e.getOperands().get(0)).isA(SqlKind.INPUT_REF) && e.getType().getFamily() == SqlTypeFamily.CHARACTER) {
            return true;
        }
        if (((RexNode)e.getOperands().get(0)).isA(SqlKind.INPUT_REF) && e.getType().getFamily() == SqlTypeFamily.NUMERIC && boundedComparator) {
            return true;
        }
        return ((RexNode)e.getOperands().get(0)).isA(SqlKind.LITERAL) && e.getType().getFamily() == SqlTypeFamily.TIMESTAMP;
    }

    static boolean isValidSignature(String signature) {
        return VALID_SIG.matcher(signature).matches();
    }

    public static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<RelNode> rels) {
        return new DruidQuery(cluster, traitSet, table, druidTable, (List<LocalInterval>)druidTable.intervals, rels);
    }

    private static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<LocalInterval> intervals, List<RelNode> rels) {
        return new DruidQuery(cluster, traitSet, table, druidTable, intervals, rels);
    }

    public static DruidQuery extendQuery(DruidQuery query, RelNode r) {
        ImmutableList.Builder builder = ImmutableList.builder();
        return DruidQuery.create(query.getCluster(), r.getTraitSet().replace((RelTrait)query.getConvention()), query.getTable(), query.druidTable, query.intervals, (List<RelNode>)builder.addAll(query.rels).add((Object)r).build());
    }

    public static DruidQuery extendQuery(DruidQuery query, List<LocalInterval> intervals) {
        return DruidQuery.create(query.getCluster(), query.getTraitSet(), query.getTable(), query.druidTable, intervals, query.rels);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.getCluster().getTypeFactory().createStructType(Pair.right((List)((RelNode)Util.last(this.rels)).getRowType().getFieldList()), this.getQuerySpec().fieldNames);
    }

    public TableScan getTableScan() {
        return (TableScan)this.rels.get(0);
    }

    public RelNode getTopNode() {
        return (RelNode)Util.last(this.rels);
    }

    public RelOptTable getTable() {
        return this.table;
    }

    public DruidTable getDruidTable() {
        return this.druidTable;
    }

    public RelWriter explainTerms(RelWriter pw) {
        for (RelNode rel : this.rels) {
            if (rel instanceof TableScan) {
                TableScan tableScan = (TableScan)rel;
                pw.item("table", (Object)tableScan.getTable().getQualifiedName());
                pw.item("intervals", this.intervals);
                continue;
            }
            if (rel instanceof Filter) {
                pw.item("filter", (Object)((Filter)rel).getCondition());
                continue;
            }
            if (rel instanceof Project) {
                if (((Project)rel).getInput() instanceof Aggregate) {
                    pw.item("post_projects", (Object)((Project)rel).getProjects());
                    continue;
                }
                pw.item("projects", (Object)((Project)rel).getProjects());
                continue;
            }
            if (rel instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)rel;
                pw.item("groups", (Object)aggregate.getGroupSet()).item("aggs", (Object)aggregate.getAggCallList());
                continue;
            }
            if (rel instanceof Sort) {
                Sort sort = (Sort)rel;
                for (Ord ord : Ord.zip((List)sort.collation.getFieldCollations())) {
                    pw.item("sort" + ord.i, (Object)((RelFieldCollation)ord.e).getFieldIndex());
                }
                for (Ord ord : Ord.zip((List)sort.collation.getFieldCollations())) {
                    pw.item("dir" + ord.i, (Object)((RelFieldCollation)ord.e).shortString());
                }
                pw.itemIf("fetch", (Object)sort.fetch, sort.fetch != null);
                continue;
            }
            throw new AssertionError((Object)("rel type not supported in Druid query " + rel));
        }
        return pw;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return ((RelNode)Util.last(this.rels)).computeSelfCost(planner, mq).multiplyBy(RelMdUtil.linear((int)this.querySpec.fieldNames.size(), (int)2, (int)100, (double)1.0, (double)2.0)).multiplyBy(this.getQueryTypeCostMultiplier()).multiplyBy(Util.last(this.rels) instanceof Sort ? 0.1 : 1.0);
    }

    private double getQueryTypeCostMultiplier() {
        switch (this.querySpec.queryType) {
            case SELECT: {
                return 0.1;
            }
            case GROUP_BY: {
                return 0.08;
            }
            case TIMESERIES: {
                return 0.06;
            }
            case TOP_N: {
                return 0.04;
            }
        }
        return 0.2;
    }

    public void register(RelOptPlanner planner) {
        for (RelOptRule rule : DruidRules.RULES) {
            planner.addRule(rule);
        }
        for (RelOptRule rule : Bindables.RULES) {
            planner.addRule(rule);
        }
    }

    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    public Enumerable<Object[]> bind(DataContext dataContext) {
        return ((ScannableTable)this.table.unwrap(ScannableTable.class)).scan(dataContext);
    }

    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        return new DruidQueryNode(implementor.interpreter, this);
    }

    public QuerySpec getQuerySpec() {
        if (this.querySpec == null) {
            this.querySpec = this.deriveQuerySpec();
            assert (this.querySpec != null) : this;
        }
        return this.querySpec;
    }

    protected QuerySpec deriveQuerySpec() {
        RelDataType rowType = this.table.getRowType();
        int i = 1;
        RexNode filter = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Filter) {
            Filter filterRel = (Filter)this.rels.get(i++);
            filter = filterRel.getCondition();
        }
        List projects = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Project) {
            Project project = (Project)this.rels.get(i++);
            projects = project.getProjects();
        }
        ImmutableBitSet groupSet = null;
        List aggCalls = null;
        List aggNames = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)this.rels.get(i++);
            groupSet = aggregate.getGroupSet();
            aggCalls = aggregate.getAggCallList();
            aggNames = Util.skip((List)aggregate.getRowType().getFieldNames(), (int)groupSet.cardinality());
        }
        Project postProject = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Project) {
            postProject = (Project)this.rels.get(i++);
        }
        ArrayList<Integer> collationIndexes = null;
        ArrayList<RelFieldCollation.Direction> collationDirections = null;
        ImmutableBitSet.Builder numericCollationBitSetBuilder = ImmutableBitSet.builder();
        Integer fetch = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Sort) {
            Sort sort = (Sort)this.rels.get(i++);
            collationIndexes = new ArrayList<Integer>();
            collationDirections = new ArrayList<RelFieldCollation.Direction>();
            for (RelFieldCollation fCol : sort.collation.getFieldCollations()) {
                collationIndexes.add(fCol.getFieldIndex());
                collationDirections.add(fCol.getDirection());
                if (((RelDataTypeField)sort.getRowType().getFieldList().get(fCol.getFieldIndex())).getType().getFamily() != SqlTypeFamily.NUMERIC) continue;
                numericCollationBitSetBuilder.set(fCol.getFieldIndex());
            }
            Integer n = fetch = sort.fetch != null ? Integer.valueOf(RexLiteral.intValue((RexNode)sort.fetch)) : null;
        }
        if (i != this.rels.size()) {
            throw new AssertionError((Object)"could not implement all rels");
        }
        return this.getQuery(rowType, filter, projects, groupSet, aggCalls, aggNames, collationIndexes, collationDirections, numericCollationBitSetBuilder.build(), fetch, postProject);
    }

    public QueryType getQueryType() {
        return this.getQuerySpec().queryType;
    }

    public String getQueryString() {
        return this.getQuerySpec().queryString;
    }

    protected CalciteConnectionConfig getConnectionConfig() {
        return (CalciteConnectionConfig)this.getCluster().getPlanner().getContext().unwrap(CalciteConnectionConfig.class);
    }

    protected QuerySpec getQuery(RelDataType rowType, RexNode filter, List<RexNode> projects, ImmutableBitSet groupSet, List<AggregateCall> aggCalls, List<String> aggNames, List<Integer> collationIndexes, List<RelFieldCollation.Direction> collationDirections, ImmutableBitSet numericCollationIndexes, Integer fetch, Project postProject) {
        CalciteConnectionConfig config = this.getConnectionConfig();
        QueryType queryType = QueryType.SELECT;
        Translator translator = new Translator(this.druidTable, rowType, config.timeZone());
        List fieldNames = rowType.getFieldNames();
        HashSet usedFieldNames = Sets.newHashSet((Iterable)fieldNames);
        JsonFilter jsonFilter = null;
        if (filter != null) {
            jsonFilter = translator.translateFilter(filter);
        }
        if (projects != null) {
            translator.clearFieldNameLists();
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RexNode project : projects) {
                builder.add((Object)translator.translate(project, true));
            }
            fieldNames = builder.build();
        }
        ArrayList<DimensionSpec> dimensions = new ArrayList<DimensionSpec>();
        ArrayList<JsonAggregation> aggregations = new ArrayList<JsonAggregation>();
        ArrayList<JsonPostAggregation> postAggs = new ArrayList<JsonPostAggregation>();
        Granularity finalGranularity = Granularity.ALL;
        RelFieldCollation.Direction timeSeriesDirection = null;
        JsonLimit limit = null;
        TimeExtractionDimensionSpec timeExtractionDimensionSpec = null;
        if (groupSet != null) {
            String fieldName;
            int groupKey;
            Iterator iterator;
            assert (aggCalls != null);
            assert (aggNames != null);
            assert (aggCalls.size() == aggNames.size());
            int timePositionIdx = -1;
            ImmutableList.Builder builder = ImmutableList.builder();
            if (projects != null) {
                iterator = groupSet.iterator();
                block13: while (iterator.hasNext()) {
                    String extractColumnName;
                    groupKey = (Integer)iterator.next();
                    fieldName = (String)fieldNames.get(groupKey);
                    RexNode project = projects.get(groupKey);
                    if (project instanceof RexInputRef) {
                        RexInputRef ref = (RexInputRef)project;
                        String originalFieldName = ((RelDataTypeField)this.druidTable.getRowType(this.getCluster().getTypeFactory()).getFieldList().get(ref.getIndex())).getName();
                        if (originalFieldName.equals(this.druidTable.timestampFieldName)) {
                            finalGranularity = Granularity.ALL;
                            extractColumnName = SqlValidatorUtil.uniquify((String)EXTRACT_COLUMN_NAME_PREFIX, (Set)usedFieldNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                            timeExtractionDimensionSpec = TimeExtractionDimensionSpec.makeFullTimeExtract(extractColumnName, config.timeZone());
                            dimensions.add(timeExtractionDimensionSpec);
                            builder.add((Object)extractColumnName);
                            assert (timePositionIdx == -1);
                            timePositionIdx = groupKey;
                            continue;
                        }
                        dimensions.add(new DefaultDimensionSpec(fieldName));
                        builder.add((Object)fieldName);
                        continue;
                    }
                    if (project instanceof RexCall) {
                        RexCall call = (RexCall)project;
                        Granularity funcGranularity = DruidDateTimeUtils.extractGranularity((RexNode)call);
                        if (funcGranularity != null) {
                            switch (call.getKind()) {
                                case EXTRACT: {
                                    finalGranularity = Granularity.ALL;
                                    extractColumnName = SqlValidatorUtil.uniquify((String)("extract_" + funcGranularity.value), (Set)usedFieldNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                                    timeExtractionDimensionSpec = TimeExtractionDimensionSpec.makeTimeExtract(funcGranularity, extractColumnName, config.timeZone());
                                    dimensions.add(timeExtractionDimensionSpec);
                                    builder.add((Object)extractColumnName);
                                    continue block13;
                                }
                                case FLOOR: {
                                    if (groupSet.cardinality() > 1) {
                                        extractColumnName = SqlValidatorUtil.uniquify((String)("floor_" + funcGranularity.value), (Set)usedFieldNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                                        dimensions.add(TimeExtractionDimensionSpec.makeTimeFloor(funcGranularity, extractColumnName, config.timeZone()));
                                        finalGranularity = Granularity.ALL;
                                        builder.add((Object)extractColumnName);
                                    } else {
                                        finalGranularity = funcGranularity;
                                        builder.add((Object)fieldName);
                                    }
                                    assert (timePositionIdx == -1);
                                    timePositionIdx = groupKey;
                                    continue block13;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                        }
                        dimensions.add(new DefaultDimensionSpec(fieldName));
                        builder.add((Object)fieldName);
                        continue;
                    }
                    throw new AssertionError((Object)("incompatible project expression: " + project));
                }
            } else {
                iterator = groupSet.iterator();
                while (iterator.hasNext()) {
                    groupKey = (Integer)iterator.next();
                    String s = (String)fieldNames.get(groupKey);
                    if (s.equals(this.druidTable.timestampFieldName)) {
                        finalGranularity = Granularity.ALL;
                        String extractColumnName = SqlValidatorUtil.uniquify((String)EXTRACT_COLUMN_NAME_PREFIX, (Set)usedFieldNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                        timeExtractionDimensionSpec = TimeExtractionDimensionSpec.makeFullTimeExtract(extractColumnName, config.timeZone());
                        dimensions.add(timeExtractionDimensionSpec);
                        builder.add((Object)extractColumnName);
                        assert (timePositionIdx == -1);
                        timePositionIdx = groupKey;
                        continue;
                    }
                    dimensions.add(new DefaultDimensionSpec(s));
                    builder.add((Object)s);
                }
            }
            for (Pair agg : Pair.zip(aggCalls, aggNames)) {
                JsonAggregation jsonAggregation = this.getJsonAggregation(fieldNames, (String)agg.right, (AggregateCall)agg.left, projects, translator);
                aggregations.add(jsonAggregation);
                builder.add((Object)jsonAggregation.name);
            }
            fieldNames = builder.build();
            if (postProject != null) {
                builder = ImmutableList.builder();
                for (Pair pair : postProject.getNamedProjects()) {
                    fieldName = (String)pair.right;
                    RexNode rex = (RexNode)pair.left;
                    builder.add((Object)fieldName);
                    if (!(rex instanceof RexCall)) continue;
                    JsonPostAggregation jsonPost = this.getJsonPostAggregation(fieldName, rex, postProject.getInput());
                    postAggs.add(jsonPost);
                }
                fieldNames = builder.build();
            }
            ImmutableList collations = null;
            boolean sortsMetric = false;
            if (collationIndexes != null) {
                assert (collationDirections != null);
                ImmutableList.Builder colBuilder = ImmutableList.builder();
                for (Pair p : Pair.zip(collationIndexes, collationDirections)) {
                    String dimensionOrder = numericCollationIndexes.get(((Integer)p.left).intValue()) ? "numeric" : "alphanumeric";
                    colBuilder.add((Object)new JsonCollation((String)fieldNames.get((Integer)p.left), p.right == RelFieldCollation.Direction.DESCENDING ? "descending" : "ascending", dimensionOrder));
                    if ((Integer)p.left >= groupSet.cardinality() && p.right == RelFieldCollation.Direction.DESCENDING) {
                        sortsMetric = true;
                        continue;
                    }
                    if ((Integer)p.left != timePositionIdx) continue;
                    assert (timeSeriesDirection == null);
                    timeSeriesDirection = (RelFieldCollation.Direction)p.right;
                }
                collations = colBuilder.build();
            }
            limit = new JsonLimit("default", fetch, collations);
            if (dimensions.isEmpty() && (collations == null || timeSeriesDirection != null)) {
                queryType = QueryType.TIMESERIES;
                assert (fetch == null);
            } else {
                queryType = dimensions.size() == 1 && finalGranularity == Granularity.ALL && sortsMetric && collations.size() == 1 && fetch != null && config.approximateTopN() ? QueryType.TOP_N : QueryType.GROUP_BY;
            }
        } else {
            assert (aggCalls == null);
            assert (aggNames == null);
            assert (collationIndexes == null || collationIndexes.isEmpty());
            assert (collationDirections == null || collationDirections.isEmpty());
        }
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator((Writer)sw);
            if (aggregations.isEmpty()) {
                aggregations.add(new JsonAggregation("longSum", "dummy_agg", "dummy_agg"));
            }
            switch (queryType) {
                case TIMESERIES: {
                    generator.writeStartObject();
                    generator.writeStringField("queryType", "timeseries");
                    generator.writeStringField("dataSource", this.druidTable.dataSource);
                    generator.writeBooleanField("descending", timeSeriesDirection != null && timeSeriesDirection == RelFieldCollation.Direction.DESCENDING);
                    generator.writeStringField("granularity", finalGranularity.value);
                    DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
                    DruidQuery.writeField(generator, "aggregations", aggregations);
                    DruidQuery.writeFieldIf(generator, "postAggregations", postAggs.size() > 0 ? postAggs : null);
                    DruidQuery.writeField(generator, "intervals", this.intervals);
                    generator.writeFieldName("context");
                    generator.writeStartObject();
                    generator.writeBooleanField("skipEmptyBuckets", true);
                    generator.writeEndObject();
                    generator.writeEndObject();
                    break;
                }
                case TOP_N: {
                    generator.writeStartObject();
                    generator.writeStringField("queryType", "topN");
                    generator.writeStringField("dataSource", this.druidTable.dataSource);
                    generator.writeStringField("granularity", finalGranularity.value);
                    DruidQuery.writeField(generator, "dimension", dimensions.get(0));
                    generator.writeStringField("metric", (String)fieldNames.get(collationIndexes.get(0)));
                    DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
                    DruidQuery.writeField(generator, "aggregations", aggregations);
                    DruidQuery.writeFieldIf(generator, "postAggregations", postAggs.size() > 0 ? postAggs : null);
                    DruidQuery.writeField(generator, "intervals", this.intervals);
                    generator.writeNumberField("threshold", fetch.intValue());
                    generator.writeEndObject();
                    break;
                }
                case GROUP_BY: {
                    generator.writeStartObject();
                    generator.writeStringField("queryType", "groupBy");
                    generator.writeStringField("dataSource", this.druidTable.dataSource);
                    generator.writeStringField("granularity", finalGranularity.value);
                    DruidQuery.writeField(generator, "dimensions", dimensions);
                    DruidQuery.writeFieldIf(generator, "limitSpec", limit);
                    DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
                    DruidQuery.writeField(generator, "aggregations", aggregations);
                    DruidQuery.writeFieldIf(generator, "postAggregations", postAggs.size() > 0 ? postAggs : null);
                    DruidQuery.writeField(generator, "intervals", this.intervals);
                    DruidQuery.writeFieldIf(generator, "having", null);
                    generator.writeEndObject();
                    break;
                }
                case SELECT: {
                    generator.writeStartObject();
                    generator.writeStringField("queryType", "select");
                    generator.writeStringField("dataSource", this.druidTable.dataSource);
                    generator.writeBooleanField("descending", false);
                    DruidQuery.writeField(generator, "intervals", this.intervals);
                    DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
                    DruidQuery.writeField(generator, "dimensions", translator.dimensions);
                    DruidQuery.writeField(generator, "metrics", translator.metrics);
                    generator.writeStringField("granularity", finalGranularity.value);
                    generator.writeFieldName("pagingSpec");
                    generator.writeStartObject();
                    generator.writeNumberField("threshold", fetch != null ? fetch.intValue() : CalciteConnectionProperty.DRUID_FETCH.wrap(new Properties()).getInt());
                    generator.writeBooleanField("fromNext", true);
                    generator.writeEndObject();
                    generator.writeFieldName("context");
                    generator.writeStartObject();
                    generator.writeBooleanField(DRUID_QUERY_FETCH, fetch != null);
                    generator.writeEndObject();
                    generator.writeEndObject();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown query type " + (Object)((Object)queryType)));
                }
            }
            generator.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new QuerySpec(queryType, sw.toString(), fieldNames);
    }

    protected JsonAggregation getJsonAggregation(List<String> fieldNames, String name, AggregateCall aggCall, List<RexNode> projects, Translator translator) {
        JsonAggregation aggregation;
        boolean fractional;
        ArrayList<String> list = new ArrayList<String>();
        for (Integer arg : aggCall.getArgList()) {
            list.add(fieldNames.get(arg));
        }
        String only = (String)Iterables.getFirst(list, null);
        RelDataType type = aggCall.getType();
        SqlTypeName sqlTypeName = type.getSqlTypeName();
        if (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains(sqlTypeName)) {
            fractional = true;
        } else if (SqlTypeFamily.INTEGER.getTypeNames().contains(sqlTypeName)) {
            fractional = false;
        } else if (SqlTypeFamily.EXACT_NUMERIC.getTypeNames().contains(sqlTypeName)) {
            assert (sqlTypeName == SqlTypeName.DECIMAL);
            fractional = type.getScale() != 0;
        } else {
            throw new AssertionError((Object)("unknown aggregate type " + type));
        }
        CalciteConnectionConfig config = this.getConnectionConfig();
        ComplexMetric complexMetric = this.druidTable.resolveComplexMetric(only, aggCall);
        switch (aggCall.getAggregation().getKind()) {
            case COUNT: {
                if (aggCall.isDistinct()) {
                    if (config.approximateDistinctCount()) {
                        if (complexMetric == null) {
                            aggregation = new JsonCardinalityAggregation("cardinality", name, list);
                            break;
                        }
                        aggregation = new JsonAggregation(complexMetric.getMetricType(), name, complexMetric.getMetricName());
                        break;
                    }
                    throw new UnsupportedOperationException("Cannot push " + aggCall + " because an approximate count distinct is not acceptable.");
                }
                aggregation = new JsonAggregation("count", name, only);
                break;
            }
            case SUM: 
            case SUM0: {
                aggregation = new JsonAggregation(fractional ? "doubleSum" : "longSum", name, only);
                break;
            }
            case MIN: {
                aggregation = new JsonAggregation(fractional ? "doubleMin" : "longMin", name, only);
                break;
            }
            case MAX: {
                aggregation = new JsonAggregation(fractional ? "doubleMax" : "longMax", name, only);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown aggregate " + aggCall));
            }
        }
        if (aggCall.hasFilter()) {
            RexCall filterNode = (RexCall)projects.get(aggCall.filterArg);
            JsonFilter filter = translator.translateFilter((RexNode)filterNode.getOperands().get(0));
            aggregation = new JsonFilteredAggregation(filter, aggregation);
        }
        return aggregation;
    }

    public JsonPostAggregation getJsonPostAggregation(String name, RexNode rexNode, RelNode rel) {
        if (rexNode instanceof RexCall) {
            ArrayList<JsonPostAggregation> fields = new ArrayList<JsonPostAggregation>();
            for (RexNode ele : ((RexCall)rexNode).getOperands()) {
                JsonPostAggregation field = this.getJsonPostAggregation("", ele, rel);
                if (field == null) {
                    throw new RuntimeException("Unchecked types that cannot be parsed as Post Aggregator");
                }
                fields.add(field);
            }
            switch (rexNode.getKind()) {
                case PLUS: {
                    return new JsonArithmetic(name, "+", fields, null);
                }
                case MINUS: {
                    return new JsonArithmetic(name, "-", fields, null);
                }
                case DIVIDE: {
                    return new JsonArithmetic(name, "quotient", fields, null);
                }
                case TIMES: {
                    return new JsonArithmetic(name, "*", fields, null);
                }
                case CAST: {
                    return this.getJsonPostAggregation(name, (RexNode)((RexCall)rexNode).getOperands().get(0), rel);
                }
            }
        } else {
            if (rexNode instanceof RexInputRef) {
                Integer indexSkipGroup = ((RexInputRef)rexNode).getIndex() - ((Aggregate)rel).getGroupCount();
                AggregateCall aggCall = (AggregateCall)((Aggregate)rel).getAggCallList().get(indexSkipGroup);
                if (aggCall.isDistinct() && aggCall.getAggregation().getKind() == SqlKind.COUNT) {
                    String fieldName = (String)rel.getRowType().getFieldNames().get(((RexInputRef)rexNode).getIndex());
                    List fieldNames = ((Aggregate)rel).getInput().getRowType().getFieldNames();
                    String complexName = (String)fieldNames.get((Integer)aggCall.getArgList().get(0));
                    ComplexMetric metric = this.druidTable.resolveComplexMetric(complexName, aggCall);
                    if (metric != null) {
                        switch (metric.getDruidType()) {
                            case THETA_SKETCH: {
                                return new JsonThetaSketchEstimate("", fieldName);
                            }
                            case HYPER_UNIQUE: {
                                return new JsonHyperUniqueCardinality("", fieldName);
                            }
                        }
                        throw new AssertionError((Object)("Can not translate complex metric type: " + (Object)((Object)metric.getDruidType())));
                    }
                    return new JsonHyperUniqueCardinality("", fieldName);
                }
                return new JsonFieldAccessor("", (String)rel.getRowType().getFieldNames().get(((RexInputRef)rexNode).getIndex()));
            }
            if (rexNode instanceof RexLiteral && ((RexLiteral)rexNode).getValue3() instanceof BigDecimal) {
                return new JsonConstant("", ((BigDecimal)((RexLiteral)rexNode).getValue3()).doubleValue());
            }
        }
        throw new RuntimeException("Unchecked types that cannot be parsed as Post Aggregator");
    }

    protected static void writeField(JsonGenerator generator, String fieldName, Object o) throws IOException {
        generator.writeFieldName(fieldName);
        DruidQuery.writeObject(generator, o);
    }

    protected static void writeFieldIf(JsonGenerator generator, String fieldName, Object o) throws IOException {
        if (o != null) {
            DruidQuery.writeField(generator, fieldName, o);
        }
    }

    protected static void writeArray(JsonGenerator generator, List<?> elements) throws IOException {
        generator.writeStartArray();
        for (Object o : elements) {
            DruidQuery.writeObject(generator, o);
        }
        generator.writeEndArray();
    }

    protected static void writeObject(JsonGenerator generator, Object o) throws IOException {
        if (o instanceof String) {
            String s = (String)o;
            generator.writeString(s);
        } else if (o instanceof LocalInterval) {
            generator.writeString(o.toString());
        } else if (o instanceof Integer) {
            Integer i = (Integer)o;
            generator.writeNumber(i.intValue());
        } else if (o instanceof List) {
            DruidQuery.writeArray(generator, (List)o);
        } else if (o instanceof Json) {
            ((Json)o).write(generator);
        } else {
            throw new AssertionError((Object)("not a json object: " + o));
        }
    }

    static String metadataQuery(String dataSourceName, List<LocalInterval> intervals) {
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator((Writer)sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "segmentMetadata");
            generator.writeStringField("dataSource", dataSourceName);
            generator.writeBooleanField("merge", true);
            generator.writeBooleanField("lenientAggregatorMerge", true);
            generator.writeArrayFieldStart("analysisTypes");
            generator.writeString("aggregators");
            generator.writeEndArray();
            DruidQuery.writeFieldIf(generator, "intervals", intervals);
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    private static class JsonThetaSketchEstimate
    extends JsonPostAggregation {
        final String fieldName;

        private JsonThetaSketchEstimate(String name, String fieldName) {
            super(name, "thetaSketchEstimate");
            this.fieldName = fieldName;
        }

        @Override
        public JsonPostAggregation copy() {
            return new JsonThetaSketchEstimate(this.name, this.fieldName);
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            super.write(generator);
            DruidQuery.writeField(generator, "field", new JsonFieldAccessor("", this.fieldName));
            generator.writeEndObject();
        }
    }

    private static class JsonHyperUniqueCardinality
    extends JsonPostAggregation {
        final String fieldName;

        private JsonHyperUniqueCardinality(String name, String fieldName) {
            super(name, "hyperUniqueCardinality");
            this.fieldName = fieldName;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            super.write(generator);
            generator.writeStringField("fieldName", this.fieldName);
            generator.writeEndObject();
        }

        @Override
        public JsonPostAggregation copy() {
            return new JsonHyperUniqueCardinality(this.name, this.fieldName);
        }
    }

    private static class JsonArithmetic
    extends JsonPostAggregation {
        final String fn;
        final List<JsonPostAggregation> fields;
        final String ordering;

        private JsonArithmetic(String name, String fn, List<JsonPostAggregation> fields, String ordering) {
            super(name, "arithmetic");
            this.fn = fn;
            this.fields = fields;
            this.ordering = ordering;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            super.write(generator);
            generator.writeStringField("fn", this.fn);
            DruidQuery.writeFieldIf(generator, "fields", this.fields);
            DruidQuery.writeFieldIf(generator, "ordering", this.ordering);
            generator.writeEndObject();
        }

        @Override
        public JsonPostAggregation copy() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonPostAggregation field : this.fields) {
                builder.add((Object)field.copy());
            }
            return new JsonArithmetic(this.name, this.fn, (List<JsonPostAggregation>)builder.build(), this.ordering);
        }
    }

    private static class JsonGreatestLeast
    extends JsonPostAggregation {
        final List<JsonPostAggregation> fields;
        final boolean fractional;
        final boolean greatest;

        private JsonGreatestLeast(String name, List<JsonPostAggregation> fields, boolean fractional, boolean greatest) {
            super(name, greatest ? (fractional ? "doubleGreatest" : "longGreatest") : (fractional ? "doubleLeast" : "longLeast"));
            this.fields = fields;
            this.fractional = fractional;
            this.greatest = greatest;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            super.write(generator);
            DruidQuery.writeFieldIf(generator, "fields", this.fields);
            generator.writeEndObject();
        }

        @Override
        public JsonPostAggregation copy() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JsonPostAggregation field : this.fields) {
                builder.add((Object)field.copy());
            }
            return new JsonGreatestLeast(this.name, (List<JsonPostAggregation>)builder.build(), this.fractional, this.greatest);
        }
    }

    private static class JsonConstant
    extends JsonPostAggregation {
        final double value;

        private JsonConstant(String name, double value) {
            super(name, "constant");
            this.value = value;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            super.write(generator);
            generator.writeNumberField("value", this.value);
            generator.writeEndObject();
        }

        @Override
        public JsonPostAggregation copy() {
            return new JsonConstant(this.name, this.value);
        }
    }

    private static class JsonFieldAccessor
    extends JsonPostAggregation {
        final String fieldName;

        private JsonFieldAccessor(String name, String fieldName) {
            super(name, "fieldAccess");
            this.fieldName = fieldName;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            super.write(generator);
            generator.writeStringField("fieldName", this.fieldName);
            generator.writeEndObject();
        }

        @Override
        public JsonPostAggregation copy() {
            return new JsonFieldAccessor(this.name, this.fieldName);
        }
    }

    protected static abstract class JsonPostAggregation
    implements Json {
        final String type;
        String name;

        private JsonPostAggregation(String name, String type) {
            this.type = type;
            this.name = name;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
        }

        public void setName(String name) {
            this.name = name;
        }

        public abstract JsonPostAggregation copy();
    }

    protected static class JsonInFilter
    extends JsonFilter {
        private final String dimension;
        private final List<String> values;
        private final ExtractionFunction extractionFunction;

        private JsonInFilter(String dimension, List<String> values, ExtractionFunction extractionFunction) {
            super(JsonFilter.Type.IN);
            this.dimension = dimension;
            this.values = values;
            this.extractionFunction = extractionFunction;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type.lowercase());
            generator.writeStringField("dimension", this.dimension);
            DruidQuery.writeField(generator, "values", this.values);
            DruidQuery.writeFieldIf(generator, "extractionFn", this.extractionFunction);
            generator.writeEndObject();
        }
    }

    private static class JsonCompositeFilter
    extends JsonFilter {
        private final List<? extends JsonFilter> fields;

        private JsonCompositeFilter(JsonFilter.Type type, Iterable<? extends JsonFilter> fields) {
            super(type);
            this.fields = ImmutableList.copyOf(fields);
        }

        private JsonCompositeFilter(JsonFilter.Type type, JsonFilter ... fields) {
            this(type, (Iterable<? extends JsonFilter>)ImmutableList.copyOf((Object[])fields));
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type.lowercase());
            switch (this.type) {
                case NOT: {
                    DruidQuery.writeField(generator, "field", this.fields.get(0));
                    break;
                }
                default: {
                    DruidQuery.writeField(generator, "fields", this.fields);
                }
            }
            generator.writeEndObject();
        }
    }

    @VisibleForTesting
    protected static class JsonBound
    extends JsonFilter {
        private final String dimension;
        private final String lower;
        private final boolean lowerStrict;
        private final String upper;
        private final boolean upperStrict;
        private final boolean alphaNumeric;
        private final ExtractionFunction extractionFunction;

        private JsonBound(String dimension, String lower, boolean lowerStrict, String upper, boolean upperStrict, boolean alphaNumeric, ExtractionFunction extractionFunction) {
            super(JsonFilter.Type.BOUND);
            this.dimension = dimension;
            this.lower = lower;
            this.lowerStrict = lowerStrict;
            this.upper = upper;
            this.upperStrict = upperStrict;
            this.alphaNumeric = alphaNumeric;
            this.extractionFunction = extractionFunction;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type.lowercase());
            generator.writeStringField("dimension", this.dimension);
            if (this.lower != null) {
                generator.writeStringField("lower", this.lower);
                generator.writeBooleanField("lowerStrict", this.lowerStrict);
            }
            if (this.upper != null) {
                generator.writeStringField("upper", this.upper);
                generator.writeBooleanField("upperStrict", this.upperStrict);
            }
            if (this.alphaNumeric) {
                generator.writeStringField("ordering", "numeric");
            } else {
                generator.writeStringField("ordering", "lexicographic");
            }
            DruidQuery.writeFieldIf(generator, "extractionFn", this.extractionFunction);
            generator.writeEndObject();
        }
    }

    private static class JsonSelector
    extends JsonFilter {
        private final String dimension;
        private final String value;
        private final ExtractionFunction extractionFunction;

        private JsonSelector(String dimension, String value, ExtractionFunction extractionFunction) {
            super(JsonFilter.Type.SELECTOR);
            this.dimension = dimension;
            this.value = value;
            this.extractionFunction = extractionFunction;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type.lowercase());
            generator.writeStringField("dimension", this.dimension);
            generator.writeStringField("value", this.value);
            DruidQuery.writeFieldIf(generator, "extractionFn", this.extractionFunction);
            generator.writeEndObject();
        }
    }

    private static abstract class JsonFilter
    implements Json {
        final Type type;

        private JsonFilter(Type type) {
            this.type = type;
        }

        protected static enum Type {
            AND,
            OR,
            NOT,
            SELECTOR,
            IN,
            BOUND;


            public String lowercase() {
                return this.name().toLowerCase(Locale.ROOT);
            }
        }
    }

    private static class JsonFilteredAggregation
    extends JsonAggregation {
        final JsonFilter filter;
        final JsonAggregation aggregation;

        private JsonFilteredAggregation(JsonFilter filter, JsonAggregation aggregation) {
            super("filtered", aggregation.name, aggregation.fieldName);
            this.filter = filter;
            this.aggregation = aggregation;
            assert (!(aggregation instanceof JsonFilteredAggregation));
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            DruidQuery.writeField(generator, "filter", this.filter);
            DruidQuery.writeField(generator, "aggregator", this.aggregation);
            generator.writeEndObject();
        }
    }

    private static class JsonCardinalityAggregation
    extends JsonAggregation {
        final List<String> fieldNames;

        private JsonCardinalityAggregation(String type, String name, List<String> fieldNames) {
            super(type, name, null);
            this.fieldNames = fieldNames;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
            DruidQuery.writeFieldIf(generator, "fieldNames", this.fieldNames);
            generator.writeEndObject();
        }
    }

    private static class JsonCollation
    implements Json {
        final String dimension;
        final String direction;
        final String dimensionOrder;

        private JsonCollation(String dimension, String direction, String dimensionOrder) {
            this.dimension = dimension;
            this.direction = direction;
            this.dimensionOrder = dimensionOrder;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("dimension", this.dimension);
            DruidQuery.writeFieldIf(generator, "direction", this.direction);
            DruidQuery.writeFieldIf(generator, "dimensionOrder", this.dimensionOrder);
            generator.writeEndObject();
        }
    }

    private static class JsonLimit
    implements Json {
        final String type;
        final Integer limit;
        final ImmutableList<JsonCollation> collations;

        private JsonLimit(String type, Integer limit, ImmutableList<JsonCollation> collations) {
            this.type = type;
            this.limit = limit;
            this.collations = collations;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            DruidQuery.writeFieldIf(generator, "limit", this.limit);
            DruidQuery.writeFieldIf(generator, "columns", this.collations);
            generator.writeEndObject();
        }
    }

    private static class JsonAggregation
    implements Json {
        final String type;
        final String name;
        final String fieldName;

        private JsonAggregation(String type, String name, String fieldName) {
            this.type = type;
            this.name = name;
            this.fieldName = fieldName;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
            DruidQuery.writeFieldIf(generator, "fieldName", this.fieldName);
            generator.writeEndObject();
        }
    }

    public static interface Json {
        public void write(JsonGenerator var1) throws IOException;
    }

    private static class DruidQueryNode
    implements Node {
        private final Sink sink;
        private final DruidQuery query;
        private final QuerySpec querySpec;

        DruidQueryNode(Interpreter interpreter, DruidQuery query) {
            this.query = query;
            this.sink = interpreter.sink((RelNode)query);
            this.querySpec = query.getQuerySpec();
            Hook.QUERY_PLAN.run((Object)this.querySpec);
        }

        public void run() throws InterruptedException {
            ArrayList<ColumnMetaData.Rep> fieldTypes = new ArrayList<ColumnMetaData.Rep>();
            for (RelDataTypeField field : this.query.getRowType().getFieldList()) {
                fieldTypes.add(this.getPrimitive(field));
            }
            DruidConnectionImpl connection = new DruidConnectionImpl(this.query.druidTable.schema.url, this.query.druidTable.schema.coordinatorUrl);
            boolean limitQuery = DruidQueryNode.containsLimit(this.querySpec);
            DruidConnectionImpl.Page page = new DruidConnectionImpl.Page();
            do {
                String queryString = this.querySpec.getQueryString(page.pagingIdentifier, page.offset);
                connection.request(this.querySpec.queryType, queryString, this.sink, this.querySpec.fieldNames, fieldTypes, page);
            } while (!limitQuery && page.pagingIdentifier != null && page.totalRowCount > 0);
        }

        private static boolean containsLimit(QuerySpec querySpec) {
            return querySpec.queryString.contains("\"context\":{\"druid.query.fetch\":true");
        }

        private ColumnMetaData.Rep getPrimitive(RelDataTypeField field) {
            switch (field.getType().getSqlTypeName()) {
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    return ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP;
                }
                case BIGINT: {
                    return ColumnMetaData.Rep.LONG;
                }
                case INTEGER: {
                    return ColumnMetaData.Rep.INTEGER;
                }
                case SMALLINT: {
                    return ColumnMetaData.Rep.SHORT;
                }
                case TINYINT: {
                    return ColumnMetaData.Rep.BYTE;
                }
                case REAL: {
                    return ColumnMetaData.Rep.FLOAT;
                }
                case DOUBLE: 
                case FLOAT: {
                    return ColumnMetaData.Rep.DOUBLE;
                }
            }
            return null;
        }
    }

    @VisibleForTesting
    protected static class Translator {
        final List<String> dimensions = new ArrayList<String>();
        final List<String> metrics = new ArrayList<String>();
        final DruidTable druidTable;
        final RelDataType rowType;
        final String timeZone;

        Translator(DruidTable druidTable, RelDataType rowType, String timeZone) {
            this.druidTable = druidTable;
            this.rowType = rowType;
            for (RelDataTypeField f : rowType.getFieldList()) {
                String fieldName = f.getName();
                if (druidTable.isMetric(fieldName)) {
                    this.metrics.add(fieldName);
                    continue;
                }
                if (druidTable.timestampFieldName.equals(fieldName) || "__time".equals(fieldName)) continue;
                this.dimensions.add(fieldName);
            }
            this.timeZone = timeZone;
        }

        protected void clearFieldNameLists() {
            this.dimensions.clear();
            this.metrics.clear();
        }

        String translate(RexNode e, boolean set) {
            int index = -1;
            switch (e.getKind()) {
                case INPUT_REF: {
                    RexInputRef ref = (RexInputRef)e;
                    index = ref.getIndex();
                    break;
                }
                case CAST: {
                    return this.tr(e, 0, set);
                }
                case LITERAL: {
                    return ((RexLiteral)e).getValue3().toString();
                }
                case EXTRACT: 
                case FLOOR: {
                    RexCall call = (RexCall)e;
                    assert (DruidDateTimeUtils.extractGranularity((RexNode)call) != null);
                    index = (Integer)RelOptUtil.InputFinder.bits((RexNode)e).asList().get(0);
                    break;
                }
                case IS_TRUE: {
                    return "";
                }
            }
            if (index == -1) {
                throw new AssertionError((Object)("invalid expression " + e));
            }
            String fieldName = ((RelDataTypeField)this.rowType.getFieldList().get(index)).getName();
            if (set) {
                if (this.druidTable.metricFieldNames.contains((Object)fieldName)) {
                    this.metrics.add(fieldName);
                } else if (!this.druidTable.timestampFieldName.equals(fieldName) && !"__time".equals(fieldName)) {
                    this.dimensions.add(fieldName);
                }
            }
            return fieldName;
        }

        private JsonFilter translateFilter(RexNode e) {
            switch (e.getKind()) {
                case EQUALS: 
                case NOT_EQUALS: 
                case IN: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: 
                case BETWEEN: {
                    String dimName;
                    int posConstant;
                    int posRef;
                    RexCall call = (RexCall)e;
                    if (RexUtil.isConstant((RexNode)((RexNode)call.getOperands().get(1)))) {
                        posRef = 0;
                        posConstant = 1;
                    } else if (RexUtil.isConstant((RexNode)((RexNode)call.getOperands().get(0)))) {
                        posRef = 1;
                        posConstant = 0;
                    } else {
                        throw new AssertionError((Object)("it is not a valid comparison: " + e));
                    }
                    boolean numeric = ((RexNode)call.getOperands().get(posRef)).getType().getFamily() == SqlTypeFamily.NUMERIC;
                    Granularity granularity = DruidDateTimeUtils.extractGranularity((RexNode)call.getOperands().get(posRef));
                    TimeExtractionFunction extractionFunction = null;
                    if (granularity != null) {
                        extractionFunction = TimeExtractionFunction.createExtractFromGranularity(granularity, this.timeZone);
                    }
                    if ((dimName = this.tr(e, posRef)).equals("timestamp")) {
                        dimName = "__time";
                    }
                    switch (e.getKind()) {
                        case EQUALS: {
                            return new JsonSelector(dimName, this.tr(e, posConstant), extractionFunction);
                        }
                        case NOT_EQUALS: {
                            return new JsonCompositeFilter(JsonFilter.Type.NOT, new JsonFilter[]{new JsonSelector(dimName, this.tr(e, posConstant), extractionFunction)});
                        }
                        case GREATER_THAN: {
                            return new JsonBound(dimName, this.tr(e, posConstant), true, null, false, numeric, extractionFunction);
                        }
                        case GREATER_THAN_OR_EQUAL: {
                            return new JsonBound(dimName, this.tr(e, posConstant), false, null, false, numeric, extractionFunction);
                        }
                        case LESS_THAN: {
                            return new JsonBound(dimName, null, false, this.tr(e, posConstant), true, numeric, extractionFunction);
                        }
                        case LESS_THAN_OR_EQUAL: {
                            return new JsonBound(dimName, null, false, this.tr(e, posConstant), false, numeric, extractionFunction);
                        }
                        case IN: {
                            ImmutableList.Builder listBuilder = ImmutableList.builder();
                            for (RexNode rexNode : call.getOperands()) {
                                if (rexNode.getKind() != SqlKind.LITERAL) continue;
                                listBuilder.add((Object)((RexLiteral)rexNode).getValue3().toString());
                            }
                            return new JsonInFilter(dimName, (List)listBuilder.build(), extractionFunction);
                        }
                        case BETWEEN: {
                            return new JsonBound(dimName, this.tr(e, 2), false, this.tr(e, 3), false, numeric, extractionFunction);
                        }
                    }
                    throw new AssertionError();
                }
                case AND: 
                case OR: 
                case NOT: {
                    RexCall call = (RexCall)e;
                    return new JsonCompositeFilter(JsonFilter.Type.valueOf(e.getKind().name()), this.translateFilters(call.getOperands()));
                }
            }
            throw new AssertionError((Object)("cannot translate filter: " + e));
        }

        private String tr(RexNode call, int index) {
            return this.tr(call, index, false);
        }

        private String tr(RexNode call, int index, boolean set) {
            return this.translate((RexNode)((RexCall)call).getOperands().get(index), set);
        }

        private List<JsonFilter> translateFilters(List<RexNode> operands) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (RexNode operand : operands) {
                builder.add((Object)this.translateFilter(operand));
            }
            return builder.build();
        }
    }

    public static class QuerySpec {
        final QueryType queryType;
        final String queryString;
        final List<String> fieldNames;

        QuerySpec(QueryType queryType, String queryString, List<String> fieldNames) {
            this.queryType = (QueryType)((Object)Preconditions.checkNotNull((Object)((Object)queryType)));
            this.queryString = (String)Preconditions.checkNotNull((Object)queryString);
            this.fieldNames = ImmutableList.copyOf(fieldNames);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.queryType, this.queryString, this.fieldNames});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof QuerySpec && this.queryType == ((QuerySpec)obj).queryType && this.queryString.equals(((QuerySpec)obj).queryString) && this.fieldNames.equals(((QuerySpec)obj).fieldNames);
        }

        public String toString() {
            return "{queryType: " + (Object)((Object)this.queryType) + ", queryString: " + this.queryString + ", fieldNames: " + this.fieldNames + "}";
        }

        public String getQueryString(String pagingIdentifier, int offset) {
            if (pagingIdentifier == null) {
                return this.queryString;
            }
            return this.queryString.replace("\"threshold\":", "\"pagingIdentifiers\":{\"" + pagingIdentifier + "\":" + offset + "},\"threshold\":");
        }
    }
}

