/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.calcite.adapter.druid.DruidSchema;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.adapter.druid.DruidType;
import org.apache.calcite.adapter.druid.LocalInterval;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableFactory;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public class DruidTableFactory
implements TableFactory {
    public static final DruidTableFactory INSTANCE = new DruidTableFactory();

    private DruidTableFactory() {
    }

    public Table create(SchemaPlus schema, String name, Map operand, RelDataType rowType) {
        Object interval;
        Object metricsRaw;
        Object complexMetricsRaw;
        DruidSchema druidSchema = (DruidSchema)((Object)schema.unwrap(DruidSchema.class));
        String dataSource = (String)operand.get("dataSource");
        LinkedHashSet<String> metricNameBuilder = new LinkedHashSet<String>();
        LinkedHashMap<String, SqlTypeName> fieldBuilder = new LinkedHashMap<String, SqlTypeName>();
        HashMap<String, List<ComplexMetric>> complexMetrics = new HashMap<String, List<ComplexMetric>>();
        String timestampColumnName = operand.get("timestampColumn") != null ? (String)operand.get("timestampColumn") : "__time";
        fieldBuilder.put(timestampColumnName, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        Object dimensionsRaw = operand.get("dimensions");
        if (dimensionsRaw instanceof List) {
            List dimensions = (List)dimensionsRaw;
            for (Object dimension : dimensions) {
                fieldBuilder.put((String)dimension, SqlTypeName.VARCHAR);
            }
        }
        if ((complexMetricsRaw = operand.get("complexMetrics")) instanceof List) {
            List complexMetricList = (List)complexMetricsRaw;
            for (Object metric : complexMetricList) {
                complexMetrics.put((String)metric, new ArrayList());
            }
        }
        if ((metricsRaw = operand.get("metrics")) instanceof List) {
            List metrics = (List)metricsRaw;
            for (Object metric : metrics) {
                String metricName;
                DruidType druidType = DruidType.LONG;
                String fieldName = null;
                if (metric instanceof Map) {
                    Map map2 = (Map)metric;
                    if (!(map2.get("name") instanceof String)) {
                        throw new IllegalArgumentException("metric must have name");
                    }
                    metricName = (String)map2.get("name");
                    String type = (String)map2.get("type");
                    fieldName = (String)map2.get("fieldName");
                    druidType = DruidType.getTypeFromMetric(type);
                } else {
                    metricName = (String)metric;
                }
                if (!druidType.isComplex()) {
                    fieldBuilder.put(metricName, druidType.sqlType);
                    metricNameBuilder.add(metricName);
                    continue;
                }
                assert (fieldName != null);
                if (!complexMetrics.containsKey(fieldName)) continue;
                SqlTypeName type = (SqlTypeName)fieldBuilder.get(fieldName);
                if (type != SqlTypeName.VARCHAR) {
                    fieldBuilder.put(fieldName, SqlTypeName.VARBINARY);
                }
                ((List)complexMetrics.get(fieldName)).add(new ComplexMetric(metricName, druidType));
            }
        }
        ImmutableList intervals = (interval = operand.get("interval")) instanceof String ? ImmutableList.of((Object)LocalInterval.create((String)interval)) : null;
        String dataSourceName = (String)Util.first((Object)dataSource, (Object)name);
        if (dimensionsRaw == null || metricsRaw == null) {
            DruidConnectionImpl connection = new DruidConnectionImpl(druidSchema.url, druidSchema.url.replace(":8082", ":8081"));
            return DruidTable.create(druidSchema, dataSourceName, (List<LocalInterval>)intervals, fieldBuilder, metricNameBuilder, timestampColumnName, connection, complexMetrics);
        }
        return DruidTable.create(druidSchema, dataSourceName, (List<LocalInterval>)intervals, fieldBuilder, metricNameBuilder, timestampColumnName, complexMetrics);
    }
}

