/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import org.apache.calcite.sql.type.SqlTypeName;

public final class DruidType
extends Enum<DruidType> {
    public static final /* enum */ DruidType LONG = new DruidType(SqlTypeName.BIGINT);
    public static final /* enum */ DruidType FLOAT = new DruidType(SqlTypeName.DOUBLE);
    public static final /* enum */ DruidType STRING = new DruidType(SqlTypeName.VARCHAR);
    public static final /* enum */ DruidType HYPER_UNIQUE = new DruidType(SqlTypeName.VARBINARY);
    public static final /* enum */ DruidType THETA_SKETCH = new DruidType(SqlTypeName.VARBINARY);
    public final SqlTypeName sqlType;
    private static final /* synthetic */ DruidType[] $VALUES;

    public static DruidType[] values() {
        return (DruidType[])$VALUES.clone();
    }

    public static DruidType valueOf(String name) {
        return Enum.valueOf(DruidType.class, name);
    }

    private DruidType(SqlTypeName sqlType) {
        this.sqlType = sqlType;
    }

    public boolean isComplex() {
        return this == THETA_SKETCH || this == HYPER_UNIQUE;
    }

    public static DruidType getTypeFromMetric(String type) {
        assert (type != null);
        if (type.equals("hyperUnique")) {
            return HYPER_UNIQUE;
        }
        if (type.equals("thetaSketch")) {
            return THETA_SKETCH;
        }
        if (type.startsWith("long") || type.equals("count")) {
            return LONG;
        }
        if (type.startsWith("double")) {
            return FLOAT;
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public static DruidType getTypeFromMetaData(String type) {
        assert (type != null);
        switch (type) {
            case "LONG": {
                return LONG;
            }
            case "FLOAT": {
                return FLOAT;
            }
            case "STRING": {
                return STRING;
            }
        }
        return DruidType.getTypeFromMetric(type);
    }

    static {
        $VALUES = new DruidType[]{LONG, FLOAT, STRING, HYPER_UNIQUE, THETA_SKETCH};
    }
}

